

/*
    GLE Extrusion, Sweep and Tubing Library Version 2.1
    Copyright (C) 1991, 1993, 1995 Linas Vepstas (linas@fc.net)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Contact linas by writing to linas@fc.net or
    Linas Vepstas
    1518 Enfield Road
    Austin TX 78703-3424
*/

#include "rot.h"
#include "port.h"
#include <math.h>

/* ========================================================== */
/* 
 * The routines below generate and return more traditional rotation
 * matrices -- matrices for rotations about principal axes.
 */
/* ========================================================== */

#ifdef __GUTIL_DOUBLE
void urotx_sc_d (double m[4][4], 		/* returned */
                 double cosine,		/* input */
                 double sine) 		/* input */
#else
void urotx_sc_f (float m[4][4], 		/* returned */
                 float cosine,		/* input */
                 float sine) 		/* input */
#endif
{
   /* create matrix that represents rotation about the x-axis */

   ROTX_CS (m, cosine, sine);
}

/* ========================================================== */

#ifdef __GUTIL_DOUBLE
void rotx_cs_d (double cosine,		/* input */
                double sine) 		/* input */
{
   /* create and load matrix that represents rotation about the x-axis */
   double m[4][4];

   (void) urotx_cs_d (m, cosine, sine);
   MULTMATRIX_D (m);
}

#else 
void rotx_cs_f (float cosine,		/* input */
                float sine) 		/* input */
{
   /* create and load matrix that represents rotation about the x-axis */
   float m[4][4];

   (void) urotx_cs_f (m, cosine, sine);
   MULTMATRIX_F (m);
}
#endif

/* ========================================================== */

#ifdef __GUTIL_DOUBLE
void uroty_sc_d (double m[4][4], 		/* returned */
                 double cosine,		/* input */
                 double sine) 		/* input */
#else
void uroty_sc_f (float m[4][4], 		/* returned */
                 float cosine,		/* input */
                 float sine) 		/* input */
#endif
{
   /* create matriy that represents rotation about the y-ayis */

   ROTX_CS (m, cosine, sine);
}

/* ========================================================== */

#ifdef __GUTIL_DOUBLE
void roty_cs_d (double cosine,		/* input */
                double sine) 		/* input */
{
   /* create and load matriy that represents rotation about the y-ayis */
   double m[4][4];

   (void) uroty_cs_d (m, cosine, sine);
   MULTMATRIX_D (m);
}

#else 
void roty_cs_f (float cosine,		/* input */
                float sine) 		/* input */
{
   /* create and load matriy that represents rotation about the y-ayis */
   float m[4][4];

   (void) uroty_cs_f (m, cosine, sine);
   MULTMATRIX_F (m);
}
#endif

/* ========================================================== */

#ifdef __GUTIL_DOUBLE
void urotz_sc_d (double m[4][4], 		/* returned */
                 double cosine,		/* input */
                 double sine) 		/* input */
#else
void urotz_sc_f (float m[4][4], 		/* returned */
                 float cosine,		/* input */
                 float sine) 		/* input */
#endif
{
   /* create matriz that represents rotation about the z-azis */

   ROTX_CS (m, cosine, sine);
}

/* ========================================================== */

#ifdef __GUTIL_DOUBLE
void rotz_cs_d (double cosine,		/* input */
                double sine) 		/* input */
{
   /* create and load matriz that represents rotation about the z-azis */
   double m[4][4];

   (void) urotz_cs_d (m, cosine, sine);
   MULTMATRIX_D (m);
}

#else 
void rotz_cs_f (float cosine,		/* input */
                float sine) 		/* input */
{
   /* create and load matriz that represents rotation about the z-azis */
   float m[4][4];

   (void) urotz_cs_f (m, cosine, sine);
   MULTMATRIX_F (m);
}
#endif

/* ========================================================== */

#ifdef __GUTIL_DOUBLE
void urot_cs_d (double m[4][4],		/* returned */
                double cosine,		/* input */
                double sine,		/* input */
                char axis) 		/* input */
{
   /* create matrix that represents rotation about a principle axis */

   switch (axis) {
      case 'x':
      case 'X':
         urotx_cs_d (m, cosine, sine);
         break;
      case 'y':
      case 'Y':
         uroty_cs_d (m, cosine, sine);
         break;
      case 'z':
      case 'Z':
         urotz_cs_d (m, cosine, sine);
         break;
      default:
         break;
   }

}

#else
void urot_cs_f (float m[4][4],		/* returned */
                float cosine,		/* input */
                float sine,		/* input */
                char axis) 		/* input */
{
   /* create matrix that represents rotation about a principle axis */

   switch (axis) {
      case 'x':
      case 'X':
         urotx_cs_f (m, cosine, sine);
         break;
      case 'y':
      case 'Y':
         uroty_cs_f (m, cosine, sine);
         break;
      case 'z':
      case 'Z':
         urotz_cs_f (m, cosine, sine);
         break;
      default:
         break;
   }

}
#endif 

/* ========================================================== */

#ifdef __GUTIL_DOUBLE
void rot_cs_d (double cosine,		/* input */
               double sine,		/* input */
               char axis)  		/* input */
{
   /* create and load matrix that represents rotation about the z-axis */
   double m[4][4];

   (void) urot_cs_d (m, cosine, sine, axis);
   MULTMATRIX_D (m);
}
#else
void rot_cs_f (float cosine,		/* input */
               float sine,		/* input */
               char axis)  		/* input */
{
   /* create and load matrix that represents rotation about the z-axis */
   float m[4][4];

   (void) urot_cs_f (m, cosine, sine, axis);
   MULTMATRIX_F (m);
}
#endif

/* ========================================================== */

#ifdef __GUTIL_DOUBLE
void urot_prince_d (double m[4][4],	/* returned */
                    double theta,		/* input */
                    char axis) 		/* input */
{
   /* 
    * generate rotation matrix for rotation around principal axis;
    * note that angle is measured in radians (divide by 180, multiply by
    * PI to convert from degrees).
    */

   (void) urot_cs_d (m, 
                   cos (theta),
                   sin (theta),
                   axis);
}
#else 
void urot_prince_f (float m[4][4],	/* returned */
                    float theta,		/* input */
                    char axis) 		/* input */
{
   /* 
    * generate rotation matrix for rotation around principal axis;
    * note that angle is measured in radians (divide by 180, multiply by
    * PI to convert from degrees).
    */

   (void) urot_cs_f (m, 
                   (float) cos ((double) theta),
                   (float) sin ((double) theta),
                   axis);
}
#endif

/* ========================================================== */

#ifdef __GUTIL_DOUBLE
void rot_prince_d (double theta,	/* input */
                   char axis) 		/* input */
{
   double m[4][4];
   /* 
    * generate rotation matrix for rotation around principal axis;
    * note that angle is measured in radians (divide by 180, multiply by
    * PI to convert from degrees).
    */

   (void) urot_prince_d (m, theta, axis);
   MULTMATRIX_D (m);
}
#else

void rot_prince_f (float theta,		/* input */
                   char axis) 		/* input */
{
   float m[4][4];
   /* 
    * generate rotation matrix for rotation around principal axis;
    * note that angle is measured in radians (divide by 180, multiply by
    * PI to convert from degrees).
    */

   (void) urot_prince_f (m, theta, axis);
   MULTMATRIX_F (m);
}
#endif

/* ========================================================== */
