
#include "context.h"
#include "xmesaP.h"


#define COLOR_SPAN_ARGS	GLuint n, GLint x, GLint y,			\
			const GLubyte red[], const GLubyte green[],	\
			const GLubyte blue[], const GLubyte alpha[],	\
			const GLubyte mask[]


void write_span_8A8B8G8R_ximage1( COLOR_SPAN_ARGS )
{
   register GLuint i;
   register GLuint *ptr;
   ptr = (GLuint *) XMesa->backimage->data + OFFSET4(x,y);
   if (mask) {
      for (i=0;i<n;i++) {
         if (mask[i]) {
            ptr[i] = (alpha[i] << 24) | (blue[i] << 16) | (green[i] << 8) | red[i];
         }
      }
   }
   else {
      /* draw all pixels */
      for (i=0;i<n;i++) {
         ptr[i] = (alpha[i] << 24) | (blue[i] << 16) | (green[i] << 8) | red[i];
      }
   }
}


void write_span_8A8B8G8R_ximage2( COLOR_SPAN_ARGS )
{
   register GLuint i;
   register GLuint *ptr;
   ptr = (GLuint *) XMesa->backimage->data + OFFSET4(x,y);
   if (mask) {
      for (i=0;i<n;i++,ptr++, alpha++,blue++,green++,red++) {
         if (mask[i]) {
            *ptr = (*alpha << 24) | (*blue << 16) | (*green << 8) | *red;
         }
      }
   }
   else {
      /* draw all pixels */
      for (i=0;i<n;i++,ptr++, alpha++,blue++,green++,red++) {
         *ptr = (*alpha << 24) | (*blue << 16) | (*green << 8) | *red;
      }
   }
}

