/* quikpoly.c */

/*
 * Mesa 3-D graphics library
 * Version:  1.2
 * Copyright (C) 1995  Brian Paul  (brianp@ssec.wisc.edu)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
$Id: quikpoly.c,v 1.6 1995/07/27 18:03:59 brianp Exp $

$Log: quikpoly.c,v $
 * Revision 1.6  1995/07/27  18:03:59  brianp
 * check for negative ymin per Mats Lofkvist
 *
 * Revision 1.5  1995/06/09  17:48:16  brianp
 * renamed as quikpoly.[ch]
 *
 * Revision 1.4  1995/05/22  21:02:41  brianp
 * Release 1.2
 *
 * Revision 1.3  1995/04/12  15:36:15  brianp
 * updated to use DD.draw_* function pointers
 *
 * Revision 1.2  1995/03/04  19:29:44  brianp
 * 1.1 beta revision
 *
 * Revision 1.1  1995/02/24  14:26:56  brianp
 * Initial revision
 *
 */


/*
 * Quick and dirty polygon rasterizer.
 * This should only be used by device drivers that don't have an OS/hardware
 * polygon filler available.
 */




#include "GL/gl.h"
#include "config.h"
#include "dd.h"



static GLubyte Mask[MAX_WIDTH];
static GLint Left[MAX_HEIGHT], Right[MAX_HEIGHT];


/* process an edge for scan conversion of a flat-shaded polygon. */
static void edge( GLint x1, GLint y1, GLint x2, GLint y2 )
{
   GLint dx, dy, xf, yf, a, b, t, i;

   if (x1==x2 && y1==y2)
      return;

   if (x2>x1) {
      dx = x2-x1;
      xf = 1;
   }
   else {
      dx = x1-x2;
      xf = -1;
   }

   if (y2>y1) {
      dy = y2-y1;
      yf = 1;
   }
   else {
      dy = y1-y2;
      yf = -1;
   }

   if (dx>dy) {
      a = dy+dy;
      t = a-dx;
      b = t-dx;
      for (i=0;i<=dx;i++) {
	 if (x1<Left[y1]) {
            Left[y1] = x1;
         }
	 if (x1>Right[y1]) {
	    Right[y1] = x1;
	 }
         x1 += xf;
         if (t<0) {
            t += a;
         }
         else {
            t += b;
            y1 += yf;
         }
      }
   }
   else {
      a = dx+dx;
      t = a-dy;
      b = t-dy;
      for (i=0;i<=dy;i++) {
	 if (x1<Left[y1]) {
            Left[y1] = x1;
         }
	 if (x1>Right[y1]) {
	    Right[y1] = x1;
         }
         y1 += yf;
         if (t<0) {
            t += a;
         }
         else {
            t += b;
            x1 += xf;
         }
      }
   }
}




/*
 * Scan convert a simple polygon using the current color or index.
 * This function shouldn't be used if the hardware/OS provides a polygon
 * drawing function.
 */
void gl_quick_polygon( GLuint n, GLint x[], GLint y[] )
{
   GLuint i, iy;
   GLint ymin, ymax;
   static GLboolean first_time = GL_TRUE;

   if (first_time) {
      for (i=0;i<MAX_WIDTH;i++) {
	 Mask[i] = 1;
      }
      first_time = GL_FALSE;
   }

   /* find topmost and bottommost points */
   ymin = ymax = y[0];
   for (i=1;i<n;i++) {
      if (y[i]<ymin)  ymin = y[i];
      if (y[i]>ymax)  ymax = y[i];
   }

   /* suggested by Mats Lofkvist: */
   if (ymin<0) {
      ymin = 0;
   }

   /* clear edge tables */
   for (i=ymin;i<=ymax;i++) {
      Left[i] = MAX_WIDTH+1;
      Right[i] = -1;
   }

   /* define edges */
   edge( x[n-1], y[n-1], x[0], y[0] );
   for (i=0;i<n-1;i++) {
      edge( x[i], y[i], x[i+1], y[i+1] );
   }

   /* process scan lines */
   for (iy=ymin;iy<=ymax;iy++) {
      if (Left[iy]<=Right[iy]) {
	 (*DD.draw_line)( Left[iy], iy, Right[iy], iy );
      }
   }

}
