#include <stdio.h>
#include <Sender.h>
#include <Receiver.h>


main(int argc, char** argv)
{
  Sender*	sender;
  Receiver*	receiver;
  Port		senderPort;
  PortArray*	appList;
  int		counter;

  printf("Starting the test.\n");
  printf("Port number to connect to is %d.\n",PortMgrPortNumber);
  senderPort.hostName = argv[1];
  senderPort.portNumber = PortMgrPortNumber;
  sender = NewSender(&senderPort);
  receiver = NewReceiver(sender,argv[0],AnyPort);
  printf("Connected with the Port Manager.\n");
  SenderGetOpenApps(sender,&appList);
  if (appList)
    {
      printf("Here is the list of apps currently registered with the Port Manager:\n");
      for (counter = 0; counter < appList->numberOfPorts; counter++)
	{
	  printf("%d. Name: %s \t Host: %s \t Port: %d\n",
		 counter+1,
		 appList->portArray[counter].appName,
		 appList->portArray[counter].hostName,
		 appList->portArray[counter].portNumber);
	}
      printf("Done printing the list of apps.\n");
    }
  else
    {
      printf("No apps currently open.\n");
    }
  printf("Got list of open apps. Exiting.\n");
  DestroyReceiver(sender, receiver);
  exit(0);
}
