#include <stdio.h>
#include <Sender.h>
#include <Receiver.h>

/* Usage: connectWithPortMgrTest <hostName>
 *	where "hostName" is the name of the host on which the
 *	PortManager is running.
 */

main(int argc, char** argv)
{
  Sender*	sender;
  Receiver*	receiver;
  Port		senderPort;
  int		result;

  printf("The Port Manager should be listening on port number %d.\n",
	 PortMgrPortNumber);
  senderPort.hostName = argv[1];				    /* Where is the PortManager with which to connect? */
  senderPort.portNumber = PortMgrPortNumber;			    /* Defined constant to indicate PortManager's port number */
  sender = NewSender(&senderPort);				    /* Try to make a communication link with the PortManager */
  if (sender == (Sender*) NULL)					    /* Could not make a connection */
    exit(1);
  receiver = NewReceiver(sender,argv[0],AnyPort);		    /* Try to register services with the PortManager */
  if (receiver == (Receiver*) NULL)				    /* Could not register my services */
    exit(1);
  printf("Connected with the Port Manager.\n");
  DestroyReceiver(sender, receiver);				    /* Disconnect with PortManager, free space taken by receiver */
  exit(0);
}
