/*
 * vcrEdit_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `vcrEdit.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include <gcm.h>
#include "vcrEdit_ui.h"

/*
 * Create object `previewMenu' in the specified instance.
 */
Xv_opaque
vcrEdit_previewMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	PreviewStartEnd(Menu_item, Menu_generate);
	extern Menu_item	EditPreview(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Video Preview",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Play entire edit",
			MENU_GEN_PROC, PreviewStartEnd,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Play part of edit...",
			MENU_GEN_PROC, EditPreview,
			NULL,
		MENU_DEFAULT, 2,
		MENU_GEN_PIN_WINDOW, owner, "Video Preview",
		NULL);
	return obj;
}

/*
 * Create object `editAudioMenu' in the specified instance.
 */
Xv_opaque
vcrEdit_editAudioMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	EditAudioStereo(Menu_item, Menu_generate);
	extern Menu_item	EditAudioRight(Menu_item, Menu_generate);
	extern Menu_item	EditAudioLeft(Menu_item, Menu_generate);
	extern Menu_item	EditAudioMute(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Stereo",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Stereo",
			MENU_GEN_PROC, EditAudioStereo,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Right",
			MENU_GEN_PROC, EditAudioRight,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Left",
			MENU_GEN_PROC, EditAudioLeft,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Mute",
			MENU_GEN_PROC, EditAudioMute,
			NULL,
		MENU_DEFAULT, 2,
		MENU_GEN_PIN_WINDOW, owner, "Stereo",
		NULL);
	return obj;
}

/*
 * Create object `DocMenu' in the specified instance.
 */
Xv_opaque
vcrEdit_DocMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	FileLoad(Menu_item, Menu_generate);
	extern Menu_item	FileSave(Menu_item, Menu_generate);
	extern Menu_item	FileSaveAs(Menu_item, Menu_generate);
	extern Menu_item	EditFileClose(Menu_item, Menu_generate);
	extern Menu_item	EditCloseWindow(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Document",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Open",
			MENU_GEN_PROC, FileLoad,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Save",
			MENU_GEN_PROC, FileSave,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Save As ...",
			MENU_GEN_PROC, FileSaveAs,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Close File",
			MENU_GEN_PROC, EditFileClose,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Close Window",
			MENU_GEN_PROC, EditCloseWindow,
			NULL,
		MENU_GEN_PIN_WINDOW, owner, "Document",
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `window1'.
 */
vcrEdit_window1_objects *
vcrEdit_window1_objects_initialize(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (vcrEdit_window1_objects *) calloc(1, sizeof (vcrEdit_window1_objects))))
		return (vcrEdit_window1_objects *) NULL;
	if (!ip->window1)
		ip->window1 = vcrEdit_window1_window1_create(ip, owner);
	if (!ip->remoteCtrlControls)
		ip->remoteCtrlControls = vcrEdit_window1_remoteCtrlControls_create(ip, ip->window1);
	if (!ip->optionsButton)
		ip->optionsButton = vcrEdit_window1_optionsButton_create(ip, ip->remoteCtrlControls);
	if (!ip->editButton)
		ip->editButton = vcrEdit_window1_editButton_create(ip, ip->remoteCtrlControls);
	if (!ip->quitButton)
		ip->quitButton = vcrEdit_window1_quitButton_create(ip, ip->remoteCtrlControls);
	if (!ip->timeStg)
		ip->timeStg = vcrEdit_window1_timeStg_create(ip, ip->remoteCtrlControls);
	if (!ip->timeMsg)
		ip->timeMsg = vcrEdit_window1_timeMsg_create(ip, ip->remoteCtrlControls);
	if (!ip->timePlusButton)
		ip->timePlusButton = vcrEdit_window1_timePlusButton_create(ip, ip->remoteCtrlControls);
	if (!ip->secSlider)
		ip->secSlider = vcrEdit_window1_secSlider_create(ip, ip->remoteCtrlControls);
	if (!ip->hrSlider)
		ip->hrSlider = vcrEdit_window1_hrSlider_create(ip, ip->remoteCtrlControls);
	if (!ip->frameSlider)
		ip->frameSlider = vcrEdit_window1_frameSlider_create(ip, ip->remoteCtrlControls);
	if (!ip->minSlider)
		ip->minSlider = vcrEdit_window1_minSlider_create(ip, ip->remoteCtrlControls);
	if (!ip->absSlider)
		ip->absSlider = vcrEdit_window1_absSlider_create(ip, ip->remoteCtrlControls);
	if (!ip->timeMinusButton)
		ip->timeMinusButton = vcrEdit_window1_timeMinusButton_create(ip, ip->remoteCtrlControls);
	if (!ip->frameTxt1)
		ip->frameTxt1 = vcrEdit_window1_frameTxt1_create(ip, ip->remoteCtrlControls);
	if (!ip->frameTxt2)
		ip->frameTxt2 = vcrEdit_window1_frameTxt2_create(ip, ip->remoteCtrlControls);
	if (!ip->frameTxt3)
		ip->frameTxt3 = vcrEdit_window1_frameTxt3_create(ip, ip->remoteCtrlControls);
	if (!ip->frameTxt4)
		ip->frameTxt4 = vcrEdit_window1_frameTxt4_create(ip, ip->remoteCtrlControls);
	if (!ip->searchButton)
		ip->searchButton = vcrEdit_window1_searchButton_create(ip, ip->remoteCtrlControls);
	if (!ip->currFrameButton)
		ip->currFrameButton = vcrEdit_window1_currFrameButton_create(ip, ip->remoteCtrlControls);
	if (!ip->remoteIconControls)
		ip->remoteIconControls = vcrEdit_window1_remoteIconControls_create(ip, ip->window1);
	if (!ip->pauseButton)
		ip->pauseButton = vcrEdit_window1_pauseButton_create(ip, ip->remoteIconControls);
	if (!ip->playButton)
		ip->playButton = vcrEdit_window1_playButton_create(ip, ip->remoteIconControls);
	if (!ip->stopButton)
		ip->stopButton = vcrEdit_window1_stopButton_create(ip, ip->remoteIconControls);
	if (!ip->scanRevButton)
		ip->scanRevButton = vcrEdit_window1_scanRevButton_create(ip, ip->remoteIconControls);
	if (!ip->scanFwdButton)
		ip->scanFwdButton = vcrEdit_window1_scanFwdButton_create(ip, ip->remoteIconControls);
	if (!ip->indexPrevButton)
		ip->indexPrevButton = vcrEdit_window1_indexPrevButton_create(ip, ip->remoteIconControls);
	if (!ip->revStepButton)
		ip->revStepButton = vcrEdit_window1_revStepButton_create(ip, ip->remoteIconControls);
	if (!ip->fwdStepButton)
		ip->fwdStepButton = vcrEdit_window1_fwdStepButton_create(ip, ip->remoteIconControls);
	if (!ip->indexNextButton)
		ip->indexNextButton = vcrEdit_window1_indexNextButton_create(ip, ip->remoteIconControls);
	if (!ip->IndexScanRevButton)
		ip->IndexScanRevButton = vcrEdit_window1_IndexScanRevButton_create(ip, ip->remoteIconControls);
	if (!ip->indexScanFwdButton)
		ip->indexScanFwdButton = vcrEdit_window1_indexScanFwdButton_create(ip, ip->remoteIconControls);
	if (!ip->speedTxt)
		ip->speedTxt = vcrEdit_window1_speedTxt_create(ip, ip->remoteIconControls);
	if (!ip->speedMsg)
		ip->speedMsg = vcrEdit_window1_speedMsg_create(ip, ip->remoteIconControls);
	if (!ip->speedSlider)
		ip->speedSlider = vcrEdit_window1_speedSlider_create(ip, ip->remoteIconControls);
	if (!ip->powerButton)
		ip->powerButton = vcrEdit_window1_powerButton_create(ip, ip->remoteIconControls);
	if (!ip->ejectButton)
		ip->ejectButton = vcrEdit_window1_ejectButton_create(ip, ip->remoteIconControls);
	return ip;
}

/*
 * Create object `window1' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_window1_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque		window1_image;
	static unsigned short	window1_bits[] = {
#include "icons/vcrEditIcon"
	};
	
	window1_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, window1_bits,
		XV_WIDTH, 64,
		XV_HEIGHT, 64,
		NULL);
	obj = xv_create(owner, FRAME,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 234,
		XV_HEIGHT, 452,
		XV_LABEL, "VCR Remote Controller",
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_ICON, xv_create(XV_NULL, ICON,
			ICON_IMAGE, window1_image,
			NULL),
		NULL);
	gcm_initialize_colors(obj, "BG1", NULL);
	return obj;
}

/*
 * Create object `remoteCtrlControls' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_remoteCtrlControls_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 204,
		WIN_BORDER, FALSE,
		NULL);
	gcm_initialize_colors(obj, "BG1", "Black");
	return obj;
}

/*
 * Create object `optionsButton' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_optionsButton_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Options(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:optionsButton",
		XV_X, 12,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Options...",
		PANEL_NOTIFY_PROC, Options,
		NULL);
	return obj;
}

/*
 * Create object `editButton' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_editButton_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Edit(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editButton",
		XV_X, 100,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, " Edit...",
		PANEL_NOTIFY_PROC, Edit,
		NULL);
	return obj;
}

/*
 * Create object `quitButton' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_quitButton_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Quit(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:quitButton",
		XV_X, 168,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, " Quit  ",
		PANEL_NOTIFY_PROC, Quit,
		NULL);
	return obj;
}

/*
 * Create object `timeStg' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_timeStg_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		TimeInput(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:timeStg",
		XV_X, 16,
		XV_Y, 48,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOOSE_NONE, FALSE,
		PANEL_NOTIFY_PROC, TimeInput,
		PANEL_CHOICE_STRINGS,
			"Abs",
			"Hr",
			"Min",
			"Sec",
			"Frame",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `timeMsg' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_timeMsg_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 72,
		XV_Y, 80,
		PANEL_LABEL_STRING, "00:00:00:00",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `timePlusButton' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_timePlusButton_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		TimePlus(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:timePlusButton",
		XV_X, 192,
		XV_Y, 80,
		PANEL_LABEL_STRING, "+ ",
		PANEL_NOTIFY_PROC, TimePlus,
		NULL);
	return obj;
}

/*
 * Create object `secSlider' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_secSlider_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		SecInput(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 100,
		PANEL_SLIDER_WIDTH, 130,
		PANEL_TICKS, 7,
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, FALSE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 60,
		PANEL_VALUE, 0,
		PANEL_NOTIFY_PROC, SecInput,
		NULL);
	return obj;
}

/*
 * Create object `hrSlider' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_hrSlider_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		HrInput(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 100,
		PANEL_SLIDER_WIDTH, 130,
		PANEL_TICKS, 9,
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, FALSE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 8,
		PANEL_VALUE, 0,
		PANEL_NOTIFY_PROC, HrInput,
		NULL);
	return obj;
}

/*
 * Create object `frameSlider' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_frameSlider_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		FrameInput(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 100,
		PANEL_SLIDER_WIDTH, 130,
		PANEL_TICKS, 4,
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, FALSE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 30,
		PANEL_VALUE, 0,
		PANEL_NOTIFY_PROC, FrameInput,
		NULL);
	return obj;
}

/*
 * Create object `minSlider' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_minSlider_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		MinInput(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 100,
		PANEL_SLIDER_WIDTH, 130,
		PANEL_TICKS, 7,
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, TRUE,
		PANEL_SHOW_VALUE, FALSE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 60,
		PANEL_VALUE, 0,
		PANEL_NOTIFY_PROC, MinInput,
		NULL);
	return obj;
}

/*
 * Create object `absSlider' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_absSlider_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		AbsInput(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 100,
		PANEL_SLIDER_WIDTH, 130,
		PANEL_TICKS, 9,
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, FALSE,
		PANEL_SHOW_VALUE, FALSE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 864000,
		PANEL_VALUE, 0,
		PANEL_NOTIFY_PROC, AbsInput,
		NULL);
	return obj;
}

/*
 * Create object `timeMinusButton' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_timeMinusButton_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		TimeMinus(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:timeMinusButton",
		XV_X, 192,
		XV_Y, 116,
		PANEL_LABEL_STRING, "- ",
		PANEL_NOTIFY_PROC, TimeMinus,
		NULL);
	return obj;
}

/*
 * Create object `frameTxt1' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_frameTxt1_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	HrTxtInput(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:frameTxt1",
		XV_X, 16,
		XV_Y, 140,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, HrTxtInput,
		NULL);
	return obj;
}

/*
 * Create object `frameTxt2' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_frameTxt2_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	MinTxtInput(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:frameTxt2",
		XV_X, 64,
		XV_Y, 140,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_LABEL_STRING, ":",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, MinTxtInput,
		NULL);
	return obj;
}

/*
 * Create object `frameTxt3' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_frameTxt3_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	SecTxtInput(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:frameTxt3",
		XV_X, 112,
		XV_Y, 140,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_LABEL_STRING, ":",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, SecTxtInput,
		NULL);
	return obj;
}

/*
 * Create object `frameTxt4' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_frameTxt4_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	FrameTxtInput(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:frameTxt4",
		XV_X, 164,
		XV_Y, 140,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_LABEL_STRING, ":",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, FrameTxtInput,
		NULL);
	return obj;
}

/*
 * Create object `searchButton' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_searchButton_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Search(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:searchButton",
		XV_X, 24,
		XV_Y, 172,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Search",
		PANEL_NOTIFY_PROC, Search,
		NULL);
	return obj;
}

/*
 * Create object `currFrameButton' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_currFrameButton_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		CurrentFrame(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:currFrameButton",
		XV_X, 120,
		XV_Y, 172,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Current Time",
		PANEL_NOTIFY_PROC, CurrentFrame,
		NULL);
	return obj;
}

/*
 * Create object `remoteIconControls' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_remoteIconControls_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 203,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, TRUE,
		NULL);
	gcm_initialize_colors(obj, "BG1", NULL);
	return obj;
}

/*
 * Create object `pauseButton' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_pauseButton_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Pause(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		pauseButton_image;
	static unsigned short	pauseButton_bits[] = {
#include "icons/pauseIcon"
	};
	
	pauseButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, pauseButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 15,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:pauseButton",
		XV_X, 24,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, pauseButton_image,
		PANEL_NOTIFY_PROC, Pause,
		NULL);
	return obj;
}

/*
 * Create object `playButton' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_playButton_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Play(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		playButton_image;
	static unsigned short	playButton_bits[] = {
#include "icons/playIcon"
	};
	
	playButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, playButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 15,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:playButton",
		XV_X, 92,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, playButton_image,
		PANEL_NOTIFY_PROC, Play,
		NULL);
	return obj;
}

/*
 * Create object `stopButton' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_stopButton_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Stop(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		stopButton_image;
	static unsigned short	stopButton_bits[] = {
#include "icons/stopIcon"
	};
	
	stopButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, stopButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 15,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:stopButton",
		XV_X, 160,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, stopButton_image,
		PANEL_NOTIFY_PROC, Stop,
		NULL);
	return obj;
}

/*
 * Create object `scanRevButton' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_scanRevButton_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		ScanReverse(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		scanRevButton_image;
	static unsigned short	scanRevButton_bits[] = {
#include "icons/rwIcon"
	};
	
	scanRevButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, scanRevButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 12,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:scanRevButton",
		XV_X, 64,
		XV_Y, 48,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, scanRevButton_image,
		PANEL_NOTIFY_PROC, ScanReverse,
		NULL);
	return obj;
}

/*
 * Create object `scanFwdButton' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_scanFwdButton_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		ScanForward(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		scanFwdButton_image;
	static unsigned short	scanFwdButton_bits[] = {
#include "icons/ffIcon"
	};
	
	scanFwdButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, scanFwdButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 12,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:scanFwdButton",
		XV_X, 120,
		XV_Y, 48,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, scanFwdButton_image,
		PANEL_NOTIFY_PROC, ScanForward,
		NULL);
	return obj;
}

/*
 * Create object `indexPrevButton' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_indexPrevButton_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		PrevIndexSearch(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		indexPrevButton_image;
	static unsigned short	indexPrevButton_bits[] = {
#include "icons/rIndexIcon"
	};
	
	indexPrevButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, indexPrevButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 12,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:indexPrevButton",
		XV_X, 12,
		XV_Y, 96,
		PANEL_LABEL_IMAGE, indexPrevButton_image,
		PANEL_NOTIFY_PROC, PrevIndexSearch,
		NULL);
	return obj;
}

/*
 * Create object `revStepButton' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_revStepButton_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		ReverseStep(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		revStepButton_image;
	static unsigned short	revStepButton_bits[] = {
#include "icons/rStepIcon"
	};
	
	revStepButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, revStepButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 12,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:revStepButton",
		XV_X, 68,
		XV_Y, 96,
		PANEL_LABEL_IMAGE, revStepButton_image,
		PANEL_NOTIFY_PROC, ReverseStep,
		NULL);
	return obj;
}

/*
 * Create object `fwdStepButton' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_fwdStepButton_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		ForwardStep(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		fwdStepButton_image;
	static unsigned short	fwdStepButton_bits[] = {
#include "icons/fStepIcon"
	};
	
	fwdStepButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, fwdStepButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 12,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:fwdStepButton",
		XV_X, 120,
		XV_Y, 96,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, fwdStepButton_image,
		PANEL_NOTIFY_PROC, ForwardStep,
		NULL);
	return obj;
}

/*
 * Create object `indexNextButton' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_indexNextButton_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		NextIndexSearch(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		indexNextButton_image;
	static unsigned short	indexNextButton_bits[] = {
#include "icons/fIndexIcon"
	};
	
	indexNextButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, indexNextButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 12,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:indexNextButton",
		XV_X, 176,
		XV_Y, 96,
		PANEL_LABEL_IMAGE, indexNextButton_image,
		PANEL_NOTIFY_PROC, NextIndexSearch,
		NULL);
	return obj;
}

/*
 * Create object `IndexScanRevButton' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_IndexScanRevButton_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		IndexScanRev(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:IndexScanRevButton",
		XV_X, 56,
		XV_Y, 128,
		PANEL_LABEL_STRING, "|< Scan",
		PANEL_NOTIFY_PROC, IndexScanRev,
		NULL);
	return obj;
}

/*
 * Create object `indexScanFwdButton' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_indexScanFwdButton_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		IndexScanFwd(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:indexScanFwdButton",
		XV_X, 120,
		XV_Y, 128,
		PANEL_LABEL_STRING, "Scan >|",
		PANEL_NOTIFY_PROC, IndexScanFwd,
		NULL);
	return obj;
}

/*
 * Create object `speedTxt' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_speedTxt_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:speedTxt",
		XV_X, 40,
		XV_Y, 164,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_VALUE_STORED_LENGTH, 5,
		PANEL_LABEL_STRING, "Speed:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `speedMsg' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_speedMsg_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 140,
		XV_Y, 164,
		PANEL_LABEL_STRING, "frames/sec",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `speedSlider' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_speedSlider_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		SpeedChange(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:speedSlider",
		XV_X, 12,
		XV_Y, 188,
		PANEL_SLIDER_WIDTH, 200,
		PANEL_TICKS, 0,
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, FALSE,
		PANEL_SHOW_VALUE, FALSE,
		PANEL_MIN_VALUE, -810,
		PANEL_MAX_VALUE, 810,
		PANEL_VALUE, 0,
		PANEL_NOTIFY_PROC, SpeedChange,
		NULL);
	return obj;
}

/*
 * Create object `powerButton' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_powerButton_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Power(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		powerButton_image;
	static unsigned short	powerButton_bits[] = {
#include "icons/powerIcon"
	};
	
	powerButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, powerButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 15,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:powerButton",
		XV_X, 24,
		XV_Y, 216,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, powerButton_image,
		PANEL_NOTIFY_PROC, Power,
		NULL);
	return obj;
}

/*
 * Create object `ejectButton' in the specified instance.
 */
Xv_opaque
vcrEdit_window1_ejectButton_create(vcrEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Eject(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		ejectButton_image;
	static unsigned short	ejectButton_bits[] = {
#include "icons/ejectIcon"
	};
	
	ejectButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, ejectButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 15,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:ejectButton",
		XV_X, 168,
		XV_Y, 216,
		PANEL_LABEL_IMAGE, ejectButton_image,
		PANEL_NOTIFY_PROC, Eject,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `optionsPopup'.
 */
vcrEdit_optionsPopup_objects *
vcrEdit_optionsPopup_objects_initialize(vcrEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (vcrEdit_optionsPopup_objects *) calloc(1, sizeof (vcrEdit_optionsPopup_objects))))
		return (vcrEdit_optionsPopup_objects *) NULL;
	if (!ip->optionsPopup)
		ip->optionsPopup = vcrEdit_optionsPopup_optionsPopup_create(ip, owner);
	if (!ip->optionsControls)
		ip->optionsControls = vcrEdit_optionsPopup_optionsControls_create(ip, ip->optionsPopup);
	if (!ip->optionsPlayerStg)
		ip->optionsPlayerStg = vcrEdit_optionsPopup_optionsPlayerStg_create(ip, ip->optionsControls);
	if (!ip->optionsPreSearch)
		ip->optionsPreSearch = vcrEdit_optionsPopup_optionsPreSearch_create(ip, ip->optionsControls);
	if (!ip->port)
		ip->port = vcrEdit_optionsPopup_port_create(ip, ip->optionsControls);
	if (!ip->setPlayerButton)
		ip->setPlayerButton = vcrEdit_optionsPopup_setPlayerButton_create(ip, ip->optionsControls);
	if (!ip->optionsNetworkHost)
		ip->optionsNetworkHost = vcrEdit_optionsPopup_optionsNetworkHost_create(ip, ip->optionsControls);
	if (!ip->optionsAudioStg)
		ip->optionsAudioStg = vcrEdit_optionsPopup_optionsAudioStg_create(ip, ip->optionsControls);
	if (!ip->optionsVideoStg)
		ip->optionsVideoStg = vcrEdit_optionsPopup_optionsVideoStg_create(ip, ip->optionsControls);
	if (!ip->optionsMutedScreen)
		ip->optionsMutedScreen = vcrEdit_optionsPopup_optionsMutedScreen_create(ip, ip->optionsControls);
	if (!ip->optionsBrightStg)
		ip->optionsBrightStg = vcrEdit_optionsPopup_optionsBrightStg_create(ip, ip->optionsControls);
	if (!ip->optionsInfoButton)
		ip->optionsInfoButton = vcrEdit_optionsPopup_optionsInfoButton_create(ip, ip->optionsControls);
	if (!ip->optionsDoneButton)
		ip->optionsDoneButton = vcrEdit_optionsPopup_optionsDoneButton_create(ip, ip->optionsControls);
	return ip;
}

/*
 * Create object `optionsPopup' in the specified instance.
 */
Xv_opaque
vcrEdit_optionsPopup_optionsPopup_create(vcrEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 448,
		XV_HEIGHT, 270,
		XV_LABEL, "Video Options",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `optionsControls' in the specified instance.
 */
Xv_opaque
vcrEdit_optionsPopup_optionsControls_create(vcrEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:optionsControls",
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	gcm_initialize_colors(obj, "BG1", "Black");
	return obj;
}

/*
 * Create object `optionsPlayerStg' in the specified instance.
 */
Xv_opaque
vcrEdit_optionsPopup_optionsPlayerStg_create(vcrEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:optionsPlayerStg",
		XV_X, 49,
		XV_Y, 16,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_LABEL_STRING, "Player :",
		PANEL_CHOICE_STRING, 0, "None",
		NULL);
	return obj;
}

/*
 * Create object `optionsPreSearch' in the specified instance.
 */
Xv_opaque
vcrEdit_optionsPopup_optionsPreSearch_create(vcrEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	extern void		SetPreSearch(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:optionsPreSearch",
		XV_X, 248,
		XV_Y, 20,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOOSE_NONE, FALSE,
		PANEL_LABEL_STRING, "Pre-search :",
		PANEL_NOTIFY_PROC, SetPreSearch,
		PANEL_CHOICE_STRINGS,
			"No",
			"Yes",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `port' in the specified instance.
 */
Xv_opaque
vcrEdit_optionsPopup_port_create(vcrEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:port",
		XV_X, 21,
		XV_Y, 52,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOOSE_NONE, FALSE,
		PANEL_LABEL_STRING, "Serial Port :",
		PANEL_CHOICE_STRINGS,
			"Default",
			"A",
			"B",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `setPlayerButton' in the specified instance.
 */
Xv_opaque
vcrEdit_optionsPopup_setPlayerButton_create(vcrEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	extern void		SetPlayer(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 108,
		XV_Y, 96,
		PANEL_ITEM_COLOR, gcm_color_index("Foreground"),
		PANEL_LABEL_STRING, "Set Player",
		PANEL_NOTIFY_PROC, SetPlayer,
		NULL);
	return obj;
}

/*
 * Create object `optionsNetworkHost' in the specified instance.
 */
Xv_opaque
vcrEdit_optionsPopup_optionsNetworkHost_create(vcrEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	SetNetworkHost(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:optionsNetworkHost",
		XV_X, 5,
		XV_Y, 136,
		PANEL_VALUE_DISPLAY_LENGTH, 30,
		PANEL_VALUE_STORED_LENGTH, 30,
		PANEL_LABEL_STRING, "Network Host:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, SetNetworkHost,
		NULL);
	return obj;
}

/*
 * Create object `optionsAudioStg' in the specified instance.
 */
Xv_opaque
vcrEdit_optionsPopup_optionsAudioStg_create(vcrEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	extern void		AudioSelect(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:optionsAudioStg",
		XV_X, 16,
		XV_Y, 168,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_CHOOSE_NONE, FALSE,
		PANEL_LABEL_STRING, "Audio:",
		PANEL_NOTIFY_PROC, AudioSelect,
		PANEL_CHOICE_STRINGS,
			"Mute",
			"Left",
			"Right",
			"Stereo",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `optionsVideoStg' in the specified instance.
 */
Xv_opaque
vcrEdit_optionsPopup_optionsVideoStg_create(vcrEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	extern void		VideoSelect(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:optionsVideoStg",
		XV_X, 292,
		XV_Y, 168,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOOSE_NONE, FALSE,
		PANEL_LABEL_STRING, "  Video:",
		PANEL_NOTIFY_PROC, VideoSelect,
		PANEL_CHOICE_STRINGS,
			"Mute",
			"On",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `optionsMutedScreen' in the specified instance.
 */
Xv_opaque
vcrEdit_optionsPopup_optionsMutedScreen_create(vcrEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	extern void		ScreenSelect(Panel_item, int, Event *);
	Xv_opaque	obj;
	Xv_opaque		optionsMutedScreen_image0;
	static unsigned short	optionsMutedScreen_bits0[] = {
#include "icons/Chip"
	};
	
	optionsMutedScreen_image0 = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, optionsMutedScreen_bits0,
		XV_WIDTH, 48,
		XV_HEIGHT, 22,
		NULL);
	obj = xv_create(owner, PANEL_CHOICE, PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:optionsMutedScreen",
		XV_X, 192,
		XV_Y, 198,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_LABEL_STRING, "Color of Muted Screen:",
		PANEL_NOTIFY_PROC, ScreenSelect,
		PANEL_CHOICE_IMAGES,
			optionsMutedScreen_image0,
			optionsMutedScreen_image0,
			optionsMutedScreen_image0,
			optionsMutedScreen_image0,
			optionsMutedScreen_image0,
			optionsMutedScreen_image0,
			optionsMutedScreen_image0,
			optionsMutedScreen_image0,
			NULL,
		PANEL_CHOICE_COLOR,  0, gcm_color_index("Magenta"),
		PANEL_CHOICE_COLOR,  1, gcm_color_index("Blue"),
		PANEL_CHOICE_COLOR,  2, gcm_color_index("Green"),
		PANEL_CHOICE_COLOR,  3, gcm_color_index("Yellow"),
		PANEL_CHOICE_COLOR,  4, gcm_color_index("Red"),
		PANEL_CHOICE_COLOR,  5, gcm_color_index("Violet"),
		PANEL_CHOICE_COLOR,  6, gcm_color_index("Cyan"),
		PANEL_CHOICE_COLOR,  7, gcm_color_index("Green Yellow"),
		NULL);
	return obj;
}

/*
 * Create object `optionsBrightStg' in the specified instance.
 */
Xv_opaque
vcrEdit_optionsPopup_optionsBrightStg_create(vcrEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	extern void		BrightSelect(Panel_item, int, Event *);
	Xv_opaque	obj;
	Xv_opaque		optionsBrightStg_image0;
	static unsigned short	optionsBrightStg_bits0[] = {
#include "icons/Full"
	};
	
	optionsBrightStg_image0 = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, optionsBrightStg_bits0,
		XV_WIDTH, 16,
		XV_HEIGHT, 16,
		NULL);
	obj = xv_create(owner, PANEL_CHOICE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:optionsBrightStg",
		XV_X, 16,
		XV_Y, 201,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOOSE_NONE, FALSE,
		PANEL_LABEL_STRING, "Brightness:",
		PANEL_NOTIFY_PROC, BrightSelect,
		PANEL_CHOICE_IMAGES,
			optionsBrightStg_image0,
			optionsBrightStg_image0,
			optionsBrightStg_image0,
			NULL,
		PANEL_CHOICE_COLOR,  0, gcm_color_index("White"),
		PANEL_CHOICE_COLOR,  1, gcm_color_index("BG2"),
		PANEL_CHOICE_COLOR,  2, gcm_color_index("Dark Slate Gray"),
		NULL);
	return obj;
}

/*
 * Create object `optionsInfoButton' in the specified instance.
 */
Xv_opaque
vcrEdit_optionsPopup_optionsInfoButton_create(vcrEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	extern void		Info(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:optionsInfoButton",
		XV_X, 152,
		XV_Y, 244,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Info...",
		PANEL_NOTIFY_PROC, Info,
		NULL);
	return obj;
}

/*
 * Create object `optionsDoneButton' in the specified instance.
 */
Xv_opaque
vcrEdit_optionsPopup_optionsDoneButton_create(vcrEdit_optionsPopup_objects *ip, Xv_opaque owner)
{
	extern void		Done(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 256,
		XV_Y, 244,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Done",
		PANEL_NOTIFY_PROC, Done,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `previewPopup'.
 */
vcrEdit_previewPopup_objects *
vcrEdit_previewPopup_objects_initialize(vcrEdit_previewPopup_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (vcrEdit_previewPopup_objects *) calloc(1, sizeof (vcrEdit_previewPopup_objects))))
		return (vcrEdit_previewPopup_objects *) NULL;
	if (!ip->previewPopup)
		ip->previewPopup = vcrEdit_previewPopup_previewPopup_create(ip, owner);
	if (!ip->previewControls)
		ip->previewControls = vcrEdit_previewPopup_previewControls_create(ip, ip->previewPopup);
	if (!ip->previewMsg)
		ip->previewMsg = vcrEdit_previewPopup_previewMsg_create(ip, ip->previewControls);
	if (!ip->previewSecMsg)
		ip->previewSecMsg = vcrEdit_previewPopup_previewSecMsg_create(ip, ip->previewControls);
	if (!ip->previewPlayFirstButton)
		ip->previewPlayFirstButton = vcrEdit_previewPopup_previewPlayFirstButton_create(ip, ip->previewControls);
	if (!ip->previewPlayFirstTxt)
		ip->previewPlayFirstTxt = vcrEdit_previewPopup_previewPlayFirstTxt_create(ip, ip->previewControls);
	if (!ip->previewPlayLastButton)
		ip->previewPlayLastButton = vcrEdit_previewPopup_previewPlayLastButton_create(ip, ip->previewControls);
	if (!ip->previewPlayLastTxt)
		ip->previewPlayLastTxt = vcrEdit_previewPopup_previewPlayLastTxt_create(ip, ip->previewControls);
	if (!ip->previewDoneButton)
		ip->previewDoneButton = vcrEdit_previewPopup_previewDoneButton_create(ip, ip->previewControls);
	return ip;
}

/*
 * Create object `previewPopup' in the specified instance.
 */
Xv_opaque
vcrEdit_previewPopup_previewPopup_create(vcrEdit_previewPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 244,
		XV_HEIGHT, 172,
		XV_LABEL, "Video Preview",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `previewControls' in the specified instance.
 */
Xv_opaque
vcrEdit_previewPopup_previewControls_create(vcrEdit_previewPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	gcm_initialize_colors(obj, "BG1", "Black");
	return obj;
}

/*
 * Create object `previewMsg' in the specified instance.
 */
Xv_opaque
vcrEdit_previewPopup_previewMsg_create(vcrEdit_previewPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 72,
		XV_Y, 16,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Play Part of Edit",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `previewSecMsg' in the specified instance.
 */
Xv_opaque
vcrEdit_previewPopup_previewSecMsg_create(vcrEdit_previewPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 88,
		XV_Y, 36,
		PANEL_LABEL_STRING, "(in seconds)",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `previewPlayFirstButton' in the specified instance.
 */
Xv_opaque
vcrEdit_previewPopup_previewPlayFirstButton_create(vcrEdit_previewPopup_objects *ip, Xv_opaque owner)
{
	extern void		PreviewStart(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:previewPlayFirstButton",
		XV_X, 180,
		XV_Y, 64,
		PANEL_ITEM_COLOR, gcm_color_index("Midnight Blue"),
		PANEL_LABEL_STRING, "<- ",
		PANEL_NOTIFY_PROC, PreviewStart,
		NULL);
	return obj;
}

/*
 * Create object `previewPlayFirstTxt' in the specified instance.
 */
Xv_opaque
vcrEdit_previewPopup_previewPlayFirstTxt_create(vcrEdit_previewPopup_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	PreviewStartTxt(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:previewPlayFirstTxt",
		XV_X, 12,
		XV_Y, 68,
		PANEL_VALUE_DISPLAY_LENGTH, 3,
		PANEL_VALUE_STORED_LENGTH, 3,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Play first : ",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 999,
		PANEL_MIN_VALUE, 0,
		PANEL_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, PreviewStartTxt,
		NULL);
	return obj;
}

/*
 * Create object `previewPlayLastButton' in the specified instance.
 */
Xv_opaque
vcrEdit_previewPopup_previewPlayLastButton_create(vcrEdit_previewPopup_objects *ip, Xv_opaque owner)
{
	extern void		PreviewEnd(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:previewPlayLastButton",
		XV_X, 180,
		XV_Y, 96,
		PANEL_ITEM_COLOR, gcm_color_index("Midnight Blue"),
		PANEL_LABEL_STRING, "<- ",
		PANEL_NOTIFY_PROC, PreviewEnd,
		NULL);
	return obj;
}

/*
 * Create object `previewPlayLastTxt' in the specified instance.
 */
Xv_opaque
vcrEdit_previewPopup_previewPlayLastTxt_create(vcrEdit_previewPopup_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	PreviewEndTxt(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:previewPlayLastTxt",
		XV_X, 12,
		XV_Y, 100,
		PANEL_VALUE_DISPLAY_LENGTH, 3,
		PANEL_VALUE_STORED_LENGTH, 3,
		PANEL_LABEL_STRING, "Play last  :",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 100,
		PANEL_MIN_VALUE, 0,
		PANEL_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, PreviewEndTxt,
		NULL);
	return obj;
}

/*
 * Create object `previewDoneButton' in the specified instance.
 */
Xv_opaque
vcrEdit_previewPopup_previewDoneButton_create(vcrEdit_previewPopup_objects *ip, Xv_opaque owner)
{
	extern void		PreviewDone(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:previewDoneButton",
		XV_X, 68,
		XV_Y, 132,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Close window",
		PANEL_NOTIFY_PROC, PreviewDone,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `infoPopup'.
 */
vcrEdit_infoPopup_objects *
vcrEdit_infoPopup_objects_initialize(vcrEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (vcrEdit_infoPopup_objects *) calloc(1, sizeof (vcrEdit_infoPopup_objects))))
		return (vcrEdit_infoPopup_objects *) NULL;
	if (!ip->infoPopup)
		ip->infoPopup = vcrEdit_infoPopup_infoPopup_create(ip, owner);
	if (!ip->infoControls)
		ip->infoControls = vcrEdit_infoPopup_infoControls_create(ip, ip->infoPopup);
	if (!ip->infoMsg5)
		ip->infoMsg5 = vcrEdit_infoPopup_infoMsg5_create(ip, ip->infoControls);
	if (!ip->infoMsg6)
		ip->infoMsg6 = vcrEdit_infoPopup_infoMsg6_create(ip, ip->infoControls);
	if (!ip->infoMsg7)
		ip->infoMsg7 = vcrEdit_infoPopup_infoMsg7_create(ip, ip->infoControls);
	if (!ip->infoMsg1)
		ip->infoMsg1 = vcrEdit_infoPopup_infoMsg1_create(ip, ip->infoControls);
	if (!ip->infoMsg3)
		ip->infoMsg3 = vcrEdit_infoPopup_infoMsg3_create(ip, ip->infoControls);
	if (!ip->infoMsg2)
		ip->infoMsg2 = vcrEdit_infoPopup_infoMsg2_create(ip, ip->infoControls);
	if (!ip->infoMsg8)
		ip->infoMsg8 = vcrEdit_infoPopup_infoMsg8_create(ip, ip->infoControls);
	if (!ip->infoMsg4)
		ip->infoMsg4 = vcrEdit_infoPopup_infoMsg4_create(ip, ip->infoControls);
	if (!ip->infoOkButton)
		ip->infoOkButton = vcrEdit_infoPopup_infoOkButton_create(ip, ip->infoControls);
	return ip;
}

/*
 * Create object `infoPopup' in the specified instance.
 */
Xv_opaque
vcrEdit_infoPopup_infoPopup_create(vcrEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 477,
		XV_HEIGHT, 265,
		XV_LABEL, "About vcrEdit",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `infoControls' in the specified instance.
 */
Xv_opaque
vcrEdit_infoPopup_infoControls_create(vcrEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	gcm_initialize_colors(obj, "BG1", "Black");
	return obj;
}

/*
 * Create object `infoMsg5' in the specified instance.
 */
Xv_opaque
vcrEdit_infoPopup_infoMsg5_create(vcrEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 162,
		XV_Y, 16,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "VCR Edit  Version 1.14",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `infoMsg6' in the specified instance.
 */
Xv_opaque
vcrEdit_infoPopup_infoMsg6_create(vcrEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 78,
		XV_Y, 40,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "An application for annotating and editing videotape",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `infoMsg7' in the specified instance.
 */
Xv_opaque
vcrEdit_infoPopup_infoMsg7_create(vcrEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 21,
		XV_Y, 64,
		PANEL_LABEL_STRING, "designed for use with the MAEstro Multimedia Authoring Environment",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `infoMsg1' in the specified instance.
 */
Xv_opaque
vcrEdit_infoPopup_infoMsg1_create(vcrEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 180,
		XV_Y, 96,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "by Wee-Lee Lim",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `infoMsg3' in the specified instance.
 */
Xv_opaque
vcrEdit_infoPopup_infoMsg3_create(vcrEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 132,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Copyright (C) 1990, 1991, 1992 Libraries and Information Resources (L&IR)",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `infoMsg2' in the specified instance.
 */
Xv_opaque
vcrEdit_infoPopup_infoMsg2_create(vcrEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 176,
		XV_Y, 156,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Stanford University",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `infoMsg8' in the specified instance.
 */
Xv_opaque
vcrEdit_infoPopup_infoMsg8_create(vcrEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 177,
		XV_Y, 176,
		PANEL_LABEL_STRING, "Stanford, California",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `infoMsg4' in the specified instance.
 */
Xv_opaque
vcrEdit_infoPopup_infoMsg4_create(vcrEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 82,
		XV_Y, 204,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "For more info, contact maestro@sioux.stanford.edu",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `infoOkButton' in the specified instance.
 */
Xv_opaque
vcrEdit_infoPopup_infoOkButton_create(vcrEdit_infoPopup_objects *ip, Xv_opaque owner)
{
	extern void		InfoDone(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:infoOkButton",
		XV_X, 216,
		XV_Y, 236,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "OK",
		PANEL_NOTIFY_PROC, InfoDone,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `editPopup'.
 */
vcrEdit_editPopup_objects *
vcrEdit_editPopup_objects_initialize(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (vcrEdit_editPopup_objects *) calloc(1, sizeof (vcrEdit_editPopup_objects))))
		return (vcrEdit_editPopup_objects *) NULL;
	if (!ip->editPopup)
		ip->editPopup = vcrEdit_editPopup_editPopup_create(ip, owner);
	if (!ip->editFileControls)
		ip->editFileControls = vcrEdit_editPopup_editFileControls_create(ip, ip->editPopup);
	if (!ip->editDocButton)
		ip->editDocButton = vcrEdit_editPopup_editDocButton_create(ip, ip->editFileControls);
	if (!ip->editScrollListControls)
		ip->editScrollListControls = vcrEdit_editPopup_editScrollListControls_create(ip, ip->editPopup);
	if (!ip->editListMsg)
		ip->editListMsg = vcrEdit_editPopup_editListMsg_create(ip, ip->editScrollListControls);
	if (!ip->editNumEditMsg)
		ip->editNumEditMsg = vcrEdit_editPopup_editNumEditMsg_create(ip, ip->editScrollListControls);
	if (!ip->editTableHeader)
		ip->editTableHeader = vcrEdit_editPopup_editTableHeader_create(ip, ip->editScrollListControls);
	if (!ip->editTableHeader2)
		ip->editTableHeader2 = vcrEdit_editPopup_editTableHeader2_create(ip, ip->editScrollListControls);
	if (!ip->editTableHeader3)
		ip->editTableHeader3 = vcrEdit_editPopup_editTableHeader3_create(ip, ip->editScrollListControls);
	if (!ip->editScrollList)
		ip->editScrollList = vcrEdit_editPopup_editScrollList_create(ip, ip->editScrollListControls);
	if (!ip->editSelectionControls)
		ip->editSelectionControls = vcrEdit_editPopup_editSelectionControls_create(ip, ip->editPopup);
	if (!ip->editNewEditMsg)
		ip->editNewEditMsg = vcrEdit_editPopup_editNewEditMsg_create(ip, ip->editSelectionControls);
	if (!ip->editTimeMsg1)
		ip->editTimeMsg1 = vcrEdit_editPopup_editTimeMsg1_create(ip, ip->editSelectionControls);
	if (!ip->editTimeMsg2)
		ip->editTimeMsg2 = vcrEdit_editPopup_editTimeMsg2_create(ip, ip->editSelectionControls);
	if (!ip->editTimeMsg3)
		ip->editTimeMsg3 = vcrEdit_editPopup_editTimeMsg3_create(ip, ip->editSelectionControls);
	if (!ip->editTimeMsg4)
		ip->editTimeMsg4 = vcrEdit_editPopup_editTimeMsg4_create(ip, ip->editSelectionControls);
	if (!ip->editGetStartButton)
		ip->editGetStartButton = vcrEdit_editPopup_editGetStartButton_create(ip, ip->editSelectionControls);
	if (!ip->editStartTxt1)
		ip->editStartTxt1 = vcrEdit_editPopup_editStartTxt1_create(ip, ip->editSelectionControls);
	if (!ip->editStartTxt2)
		ip->editStartTxt2 = vcrEdit_editPopup_editStartTxt2_create(ip, ip->editSelectionControls);
	if (!ip->editStartTxt3)
		ip->editStartTxt3 = vcrEdit_editPopup_editStartTxt3_create(ip, ip->editSelectionControls);
	if (!ip->editStartTxt4)
		ip->editStartTxt4 = vcrEdit_editPopup_editStartTxt4_create(ip, ip->editSelectionControls);
	if (!ip->editInstruct1)
		ip->editInstruct1 = vcrEdit_editPopup_editInstruct1_create(ip, ip->editSelectionControls);
	if (!ip->editGetEndButton)
		ip->editGetEndButton = vcrEdit_editPopup_editGetEndButton_create(ip, ip->editSelectionControls);
	if (!ip->editInstruct2)
		ip->editInstruct2 = vcrEdit_editPopup_editInstruct2_create(ip, ip->editSelectionControls);
	if (!ip->editSpeedTxt)
		ip->editSpeedTxt = vcrEdit_editPopup_editSpeedTxt_create(ip, ip->editSelectionControls);
	if (!ip->editEndTxt1)
		ip->editEndTxt1 = vcrEdit_editPopup_editEndTxt1_create(ip, ip->editSelectionControls);
	if (!ip->editEndTxt2)
		ip->editEndTxt2 = vcrEdit_editPopup_editEndTxt2_create(ip, ip->editSelectionControls);
	if (!ip->editEndTxt3)
		ip->editEndTxt3 = vcrEdit_editPopup_editEndTxt3_create(ip, ip->editSelectionControls);
	if (!ip->editEndTxt4)
		ip->editEndTxt4 = vcrEdit_editPopup_editEndTxt4_create(ip, ip->editSelectionControls);
	if (!ip->editSpeedMsg)
		ip->editSpeedMsg = vcrEdit_editPopup_editSpeedMsg_create(ip, ip->editSelectionControls);
	if (!ip->editLabelTxt)
		ip->editLabelTxt = vcrEdit_editPopup_editLabelTxt_create(ip, ip->editSelectionControls);
	if (!ip->editAudioMenuButton)
		ip->editAudioMenuButton = vcrEdit_editPopup_editAudioMenuButton_create(ip, ip->editSelectionControls);
	if (!ip->editDurTxt)
		ip->editDurTxt = vcrEdit_editPopup_editDurTxt_create(ip, ip->editSelectionControls);
	if (!ip->editDurSecMsg)
		ip->editDurSecMsg = vcrEdit_editPopup_editDurSecMsg_create(ip, ip->editSelectionControls);
	if (!ip->editAudioMsg)
		ip->editAudioMsg = vcrEdit_editPopup_editAudioMsg_create(ip, ip->editSelectionControls);
	if (!ip->editAddButton)
		ip->editAddButton = vcrEdit_editPopup_editAddButton_create(ip, ip->editSelectionControls);
	if (!ip->editModButton)
		ip->editModButton = vcrEdit_editPopup_editModButton_create(ip, ip->editSelectionControls);
	if (!ip->editDelButton)
		ip->editDelButton = vcrEdit_editPopup_editDelButton_create(ip, ip->editSelectionControls);
	if (!ip->editDelAllButton)
		ip->editDelAllButton = vcrEdit_editPopup_editDelAllButton_create(ip, ip->editSelectionControls);
	if (!ip->editPreviewButton)
		ip->editPreviewButton = vcrEdit_editPopup_editPreviewButton_create(ip, ip->editSelectionControls);
	return ip;
}

/*
 * Create object `editPopup' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editPopup_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 584,
		XV_HEIGHT, 482,
		XV_LABEL, "Untitled",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		NULL);
	gcm_initialize_colors(obj, "BG1", NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `editFileControls' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editFileControls_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 40,
		WIN_BORDER, FALSE,
		NULL);
	gcm_initialize_colors(obj, "BG1", NULL);
	return obj;
}

/*
 * Create object `editDocButton' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editDocButton_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 28,
		XV_Y, 12,
		PANEL_LABEL_STRING, "Document",
		PANEL_ITEM_MENU, vcrEdit_DocMenu_create((caddr_t) ip, ip->editPopup),
		NULL);
	return obj;
}

/*
 * Create object `editScrollListControls' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editScrollListControls_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, (int)xv_get(ip->editFileControls, XV_Y) +
		      (int)xv_get(ip->editFileControls, XV_HEIGHT),
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 226,
		WIN_BORDER, TRUE,
		NULL);
	gcm_initialize_colors(obj, "BG1", NULL);
	return obj;
}

/*
 * Create object `editListMsg' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editListMsg_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 264,
		XV_Y, 15,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Edit List",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `editNumEditMsg' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editNumEditMsg_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 424,
		XV_Y, 15,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "No. of Edits : 0",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editTableHeader' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editTableHeader_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 24,
		XV_Y, 39,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "  Edit #            Label                             Start              End",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `editTableHeader2' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editTableHeader2_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 440,
		XV_Y, 39,
		PANEL_LABEL_STRING, "Audio",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `editTableHeader3' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editTableHeader3_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 500,
		XV_Y, 39,
		PANEL_LABEL_STRING, "Speed",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `editScrollList' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editScrollList_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	extern int		List(Panel_item, char *, Xv_opaque, Panel_list_op, Event *, int);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_LIST,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editScrollList",
		XV_X, 4,
		XV_Y, 64,
		PANEL_LIST_WIDTH, 545,
		PANEL_LIST_DISPLAY_ROWS, 7,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_CHOOSE_ONE, TRUE,
		PANEL_CHOOSE_NONE, TRUE,
		PANEL_NOTIFY_PROC, List,
		NULL);
	return obj;
}

/*
 * Create object `editSelectionControls' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editSelectionControls_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, (int)xv_get(ip->editScrollListControls, XV_Y) +
		      (int)xv_get(ip->editScrollListControls, XV_HEIGHT) + 2,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	gcm_initialize_colors(obj, "BG1", "Black");
	return obj;
}

/*
 * Create object `editNewEditMsg' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editNewEditMsg_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 196,
		XV_Y, 16,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Current Selection : New Edit",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `editTimeMsg1' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editTimeMsg1_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 84,
		XV_Y, 44,
		PANEL_LABEL_STRING, "Hr",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editTimeMsg2' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editTimeMsg2_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 132,
		XV_Y, 44,
		PANEL_LABEL_STRING, "Min",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editTimeMsg3' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editTimeMsg3_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 188,
		XV_Y, 44,
		PANEL_LABEL_STRING, "Sec",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editTimeMsg4' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editTimeMsg4_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 232,
		XV_Y, 44,
		PANEL_LABEL_STRING, "Frame",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editGetStartButton' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editGetStartButton_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	extern void		GetStart(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editGetStartButton",
		XV_X, 276,
		XV_Y, 64,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "<-",
		PANEL_NOTIFY_PROC, GetStart,
		NULL);
	return obj;
}

/*
 * Create object `editStartTxt1' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editStartTxt1_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editStartTxt1",
		XV_X, 16,
		XV_Y, 68,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Start  : ",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editStartTxt2' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editStartTxt2_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editStartTxt2",
		XV_X, 112,
		XV_Y, 68,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_LABEL_STRING, ":",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editStartTxt3' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editStartTxt3_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editStartTxt3",
		XV_X, 168,
		XV_Y, 68,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_LABEL_STRING, ":",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editStartTxt4' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editStartTxt4_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editStartTxt4",
		XV_X, 220,
		XV_Y, 68,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_LABEL_STRING, ":",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editInstruct1' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editInstruct1_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 312,
		XV_Y, 68,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Get current frame ",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editGetEndButton' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editGetEndButton_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	extern void		GetEnd(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editGetEndButton",
		XV_X, 276,
		XV_Y, 88,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "<-",
		PANEL_NOTIFY_PROC, GetEnd,
		NULL);
	return obj;
}

/*
 * Create object `editInstruct2' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editInstruct2_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 316,
		XV_Y, 88,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "number",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editSpeedTxt' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editSpeedTxt_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	EditSpeedSet(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editSpeedTxt",
		XV_X, 424,
		XV_Y, 88,
		PANEL_VALUE_DISPLAY_LENGTH, 5,
		PANEL_VALUE_STORED_LENGTH, 5,
		PANEL_LABEL_STRING, "Speed:",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 810,
		PANEL_MIN_VALUE, 0,
		PANEL_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, EditSpeedSet,
		NULL);
	return obj;
}

/*
 * Create object `editEndTxt1' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editEndTxt1_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editEndTxt1",
		XV_X, 16,
		XV_Y, 92,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "End    : ",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editEndTxt2' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editEndTxt2_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editEndTxt2",
		XV_X, 112,
		XV_Y, 92,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_LABEL_STRING, ":",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editEndTxt3' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editEndTxt3_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editEndTxt3",
		XV_X, 168,
		XV_Y, 92,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_LABEL_STRING, ":",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editEndTxt4' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editEndTxt4_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editEndTxt4",
		XV_X, 220,
		XV_Y, 92,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_LABEL_STRING, ":",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editSpeedMsg' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editSpeedMsg_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 480,
		XV_Y, 112,
		PANEL_LABEL_STRING, "frames/sec",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editLabelTxt' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editLabelTxt_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editLabelTxt",
		XV_X, 16,
		XV_Y, 120,
		PANEL_VALUE_DISPLAY_LENGTH, 22,
		PANEL_VALUE_STORED_LENGTH, 22,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Label :",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editAudioMenuButton' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editAudioMenuButton_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editAudioMenuButton",
		XV_X, 476,
		XV_Y, 140,
		PANEL_LABEL_WIDTH, 57,
		PANEL_LABEL_STRING, "Stereo",
		PANEL_ITEM_MENU, vcrEdit_editAudioMenu_create((caddr_t) ip, ip->editPopup),
		NULL);
	return obj;
}

/*
 * Create object `editDurTxt' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editDurTxt_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editDurTxt",
		XV_X, 16,
		XV_Y, 144,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Approximate duration :",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `editDurSecMsg' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editDurSecMsg_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 248,
		XV_Y, 144,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "seconds",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editAudioMsg' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editAudioMsg_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 424,
		XV_Y, 144,
		PANEL_LABEL_STRING, "Audio:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `editAddButton' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editAddButton_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	extern void		EditAdd(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editAddButton",
		XV_X, 16,
		XV_Y, 176,
		PANEL_LABEL_WIDTH, 57,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    Add",
		PANEL_NOTIFY_PROC, EditAdd,
		NULL);
	return obj;
}

/*
 * Create object `editModButton' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editModButton_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	extern void		EditModify(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editModButton",
		XV_X, 132,
		XV_Y, 176,
		PANEL_LABEL_WIDTH, 57,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "  Modify",
		PANEL_NOTIFY_PROC, EditModify,
		NULL);
	return obj;
}

/*
 * Create object `editDelButton' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editDelButton_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	extern void		EditDelete(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editDelButton",
		XV_X, 244,
		XV_Y, 176,
		PANEL_LABEL_WIDTH, 57,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "  Delete",
		PANEL_NOTIFY_PROC, EditDelete,
		NULL);
	return obj;
}

/*
 * Create object `editDelAllButton' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editDelAllButton_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	extern void		EditDeleteAll(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editDelAllButton",
		XV_X, 356,
		XV_Y, 176,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Delete All...",
		PANEL_NOTIFY_PROC, EditDeleteAll,
		NULL);
	return obj;
}

/*
 * Create object `editPreviewButton' in the specified instance.
 */
Xv_opaque
vcrEdit_editPopup_editPreviewButton_create(vcrEdit_editPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_HELP_DATA, "vcrEdit:editPreviewButton",
		XV_X, 476,
		XV_Y, 176,
		PANEL_LABEL_WIDTH, 57,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Preview  ",
		PANEL_ITEM_MENU, vcrEdit_previewMenu_create((caddr_t) ip, ip->editPopup),
		NULL);
	return obj;
}

