/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/VideoObject/RCS/PlayerStatus.h,v 1.3 92/09/01 17:10:48 drapeau Exp $ */
/* $Log:	PlayerStatus.h,v $
 * Revision 1.3  92/09/01  17:10:48  drapeau
 * Updated copyright notice.
 * 
 * Revision 1.2  91/08/24  13:38:12  lim
 * 1. Updated status codes, so that unified among all drivers.
 * However, drivers may define their own special return codes
 * for internal use by the driver in their own header files.
 * 
 * Revision 1.1  91/08/09  10:49:50  lim
 * Initial revision
 * 
 * Revision 0.11  91/08/07  13:17:16  lim
 * Added _PlayerStatusHeader_
 * 
 * Revision 0.10  91/07/29  22:20:30  lim
 * Initial revision
 *  */


#ifndef _PlayerStatusHeader_
#define _PlayerStatusHeader_


/* Error codes */

#define PlayerCantInitDevice         -1
#define PlayerInvalidBaudRate        -2

#define PlayerUnknownError           -100
#define PlayerUnknownReturnCode      -101
#define PlayerUnknownCommand         -102
#define PlayerNakError               -103
#define PlayerReturnError            -104


/* Player status and command option codes */

#define PlayerOk                 0

#define FeatureOff               0
#define FeatureOn                1

#define DisplayFrame             0
#define DisplayChapter           1
#define DisplayFrameAndChapter   2

#define PlayerFrameMode          0
#define PlayerChapterMode        1
#define PlayerTimeMode           2

#define PlayerAudioMute          0       
#define PlayerAudioLeft          1
#define PlayerAudioRight         2
#define PlayerAudioStereo        3
#define PlayerAudioMono          4

#define PlayerForwardPlay        10
#define PlayerReversePlay        11
#define PlayerMultiSpeedPlay     12
#define PlayerForwardStep        13
#define PlayerReverseStep        14
#define PlayerMultiStepFwd       15
#define PlayerMultiStepRev       16
#define PlayerForwardSlow        17
#define PlayerReverseSlow        18
#define PlayerForwardFast        19
#define PlayerReverseFast        20
#define PlayerScan               21
#define PlayerSearch             22
#define PlayerStill              23
#define PlayerPause              24
#define PlayerStop               25

#define PlayerVideoSignalPresent 30
#define PlayerVideoSignalAbsent  31

#define PlayerRecording          40
#define PlayerRecordPause        41
#define PlayerLineInput          42
#define PlayerTunerInput         43

#define PlayerLoad               50
#define PlayerEject              51
#define PlayerWait               52
#define PlayerSystemDown         53
#define PlayerDoorOpen           54
#define PlayerNoMedium           55
#define PlayerPark               56
#define PlayerSpinUp             57

#define PlayerSPMode             60
#define PlayerEPMode             61

#endif _PlayerStatusHeader_
