/*
 * Copyright (c) 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/drapeau/VideoFrame/RCS/utils.c,v 1.1 92/07/14 14:35:20 drapeau Exp $ */
/* $Log:	utils.c,v $
 * Revision 1.1  92/07/14  14:35:20  drapeau
 * Initial revision
 *  */

#include "VideoFrame.h"

static char utilsRcsid[] = "$Header: /Source/Media/drapeau/VideoFrame/RCS/utils.c,v 1.1 92/07/14 14:35:20 drapeau Exp $";


/*
 * This function displays a notice prompt,  used to alert the
 * author that something is wrong.
 */
void AlertMessage(char*	msg1, char* msg2)
{
  notice_prompt(VideoFrame_mainWindow->mainWindow, NULL,
		NOTICE_MESSAGE_STRINGS,
		msg1, msg2,
		NULL,
		NOTICE_BUTTON, "OK", 100,
		NULL);
  return;
}								    /* end function AlertMessage */



/*
 * This function formats a string for printing on a scrolled list.
 */
void FormatEntry(int whichItem, Edit* listItem, char* label)
{
  sprintf(label, " %5d.  %s", whichItem + 1, listItem->label);
  return;
}								    /* end function FormatEntry */


void EmptyList(Edit* theList)
{
  int	i;
  
  for (i=0; i < numEdits; i++)					    /* Delete all the entries in the edit list */
  {
    xv_set(VideoFrame_mainWindow->editList,
	   PANEL_LIST_DELETE, 0,
	   NULL);
  }
  return;
}								    /* end function EmptyList */



void UpdateHeader (void)
{
  char	label[MAXPATHLEN+32];
  
  if (unsavedChanges == True)
  {
    sprintf(label, "VideoFrame Document : \"%s\" (modified)",
	    editListFileName);
  }
  else
  {
    sprintf(label, "VideoFrame Document : \"%s\" ", editListFileName);
  }
  xv_set(VideoFrame_mainWindow->mainWindow,			    /* Print the new label string on the title bar */
	 XV_LABEL, label, NULL);
}								    /* end function UpdateHeader */
