/*
 * Copyright (c) 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/drapeau/VideoFrame/RCS/network.c,v 1.1 92/07/14 14:42:45 drapeau Exp $ */
/* $Log:	network.c,v $
 * Revision 1.1  92/07/14  14:42:45  drapeau
 * Initial revision
 *  */

#include "VideoFrame.h"

static char networkRcsid[] = "$Header: /Source/Media/drapeau/VideoFrame/RCS/network.c,v 1.1 92/07/14 14:42:45 drapeau Exp $";


void OpenDoc(char** filename)
{
  OpenEditList(*filename, 0);
}								    /* end function OpenDoc */


void SetSelection(MAESelection* selection)
{
  if (selection->start <= editList.numEdits)
  currentEdit = selection->start;
  return;
}								    /* end function SetSelection */


void PerformSelection(void* unusedArg)
{
  LoadCurrentSelection(currentEdit);
}								    /* end function PerformSelection */


char** GetDoc(void* unusedArg)
{
  return((char**)&editListFileName);
}								    /* end function GetDoc */


MAESelection* GetSelection(void* unusedArg)
{
  static MAESelection selection;
  
  selection.duration = 1000;
  selection.start = currentEdit;
  selection.end = currentEdit;
  selection.offset = 0;
  sprintf(selection.label, "%s", editList.item[currentEdit].label);
  return (&selection);
}								    /* end function GetSelection */


void HaltSelection(MAESelection* selection)
{
}								    /* end function HaltSelection */


void PauseSelection(void* unusedArg)
{
}								    /* end function PauseSelection */


void ResumeSelection(void* unusedArg)
{
}								    /* end function ResumeSelection */


void HideApplication(void* unusedArg)
{
  xv_set(VideoFrame_mainWindow->mainWindow, FRAME_CLOSED, TRUE, NULL); /* Iconify the app */
  xv_set(VideoFrame_inputWindow1->inputWindow1, FRAME_CLOSED, TRUE, NULL); /* Iconify video input window 1 */
  xv_set(VideoFrame_inputWindow2->inputWindow2, FRAME_CLOSED, TRUE, NULL); /* Iconify video input window 2 */
  XFlush((Display *) xv_get(VideoFrame_mainWindow->mainWindow, 
			    XV_DISPLAY));
  return;
}								    /* end function HideApplication */


void ShowApplication(void* unusedArg)
{
  xv_set(VideoFrame_mainWindow->mainWindow, FRAME_CLOSED, FALSE, NULL);	/* Open the app if it is iconified */
  xv_set(VideoFrame_mainWindow->mainWindow, XV_SHOW, TRUE, NULL);   /* Bring the app to the front */
  xv_set(VideoFrame_inputWindow1->inputWindow1, FRAME_CLOSED, FALSE, NULL);

  if (xv_get(VideoFrame_inputWindow1->inputWindow1, XV_SHOW) == TRUE) 
  {
    xv_set(VideoFrame_inputWindow1->inputWindow1, XV_SHOW, TRUE, NULL);
  }
  xv_set(VideoFrame_inputWindow2->inputWindow2, FRAME_CLOSED, FALSE, NULL);
  if (xv_get(VideoFrame_inputWindow2->inputWindow2, XV_SHOW) == TRUE) 
  {
    xv_set(VideoFrame_inputWindow2->inputWindow2, XV_SHOW, TRUE, NULL);
  }
  XFlush((Display *) xv_get(VideoFrame_mainWindow->mainWindow, 
			    XV_DISPLAY));
  return;
}								    /* end function ShowApplication */


IconData* GetAppIcon(void* unusedArg)
{
  static IconData returnVal;
  static unsigned short iconBits[] = 
  {
#include "icons/VideoFrame"
  };

  returnVal.iconData = (char *) malloc(sizeof(iconBits));
  bcopy(iconBits, returnVal.iconData, sizeof(iconBits));
  if (returnVal.iconData) 
  {
    returnVal.dataLength = sizeof(iconBits);
  }
  return(&returnVal);
}								    /* end function GetAppIcon */


