/*
 * Copyright (c) 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/drapeau/VideoFrame/RCS/VideoFrame.h,v 1.1 92/07/14 14:39:09 drapeau Exp $ */
/* $Log:	VideoFrame.h,v $
 * Revision 1.1  92/07/14  14:39:09  drapeau
 * Initial revision
 *  */

#ifndef _VideoFrameHeader_
#define _VideoFrameHeader_

#include <stdio.h>
#include <sys/file.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/font.h>
#include <xview/notice.h>
#include <xview/notify.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include "VideoFrame_ui.h"
#include <xview/cursor.h>
#include <gdd.h>

#include <MAEstro.h>
#include <Sender.h>
#include <Receiver.h>
#include <Browse.h>
#include <Video.h>

static char videoFrameHeaderRcsid[] = "$Header: /Source/Media/drapeau/VideoFrame/RCS/VideoFrame.h,v 1.1 92/07/14 14:39:09 drapeau Exp $";

#define	True			1
#define False			0
#define MaxNumberEditListItems	100
#define Any			1
#define Fixed			0
#define NoCurrentEdit		-1
#define VideoFrameDocument "#VideoFrame Document#"

typedef struct _InputAttrs
{
  int	shown;
  int	cropped;
  int	aspectRatio;
  int	brightness;
  int	contrast;
  int	saturation;
  int	hue;
  int	width;
  int	height;
  int	x;
  int	y;
} InputAttrs;


typedef struct _Edit
{
  char		label[LabelLength];
  InputAttrs	input1;
  InputAttrs	input2;
} Edit;

typedef struct _EditList
{
  int		numEdits;
  Edit		item[MaxNumberEditListItems];
} EditList;



extern int	OpenEditList(char* filename, int id);
extern int	SaveEditList(char* filename, int id);
Menu_item	NewHandler(Menu_item item, Menu_generate op);
Menu_item	QuitHandler(Menu_item item, Menu_generate op);
void		FormatEntry(int whichItem, Edit* listItem, char* label);
void		InitXVideoCanvases(void);
void 		OpenDoc(char** filename);
void		SetSelection(MAESelection* selection);
void		PerformSelection(void*);
char**		GetDoc(void* unusedArg);
MAESelection*	GetSelection(void* unusedArg);
void		HaltSelection(MAESelection* selection);
void		PauseSelection(void*);
void		ResumeSelection(void*);
void		HideApplication(void*);
void		ShowApplication(void*);
IconData*	GetAppIcon(void*);
void		UpdateHeader(void);


extern VideoFrame_mainWindow_objects	*VideoFrame_mainWindow;		    /* Global object definitions. */
extern VideoFrame_inputWindow1_objects	*VideoFrame_inputWindow1;
extern VideoFrame_inputWindow2_objects	*VideoFrame_inputWindow2;

extern VideoIn	videoIn1;
extern VideoIn	videoIn2;

extern EditList	editList;
extern Edit	currentSelection;
extern int	numEdits;
extern int	unsavedChanges;
extern int	currentEdit;
extern char*	editListFileName;     


#endif

