/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/*$Header: /Source/Media/collab/QuoteMaker/RCS/openpanel.c,v 2.11 92/05/14 15:43:40 drapeau Exp $*/
/* $Log:	openpanel.c,v $
 * Revision 2.11  92/05/14  15:43:40  drapeau
 * * Updated copyright information.
 * 
 * Revision 2.10  91/12/31  18:44:08  drapeau
 * Moved the inclusion of string.h so that it does not create
 * include file conflicts, especially with strings.h.
 * 
 * Revision 2.0  91/09/30  15:02:40  derek
 * Version number changed to 2.0.
 * 
 * Revision 1.7  91/09/18  20:54:25  derek
 * The Makefile is changed due to the changes made in the collab/ directory.
 * 
 * Revision 1.6  91/09/15  20:06:31  derek
 * The following things are done:
 * 1.      The foreground of mainTextPane and Quote Window are set to be black.
 *         Also, the color of all the text fields are set to black.
 * 2.      Now the quoted text will be shown directly on the Quote Window
 *         when a panel-item selection is made.  The text will also be shown
 *         while the author is highlighting a selection in the text window.
 * 3.      The inconsistency problem regarding text selection is being taken
 *         care of.  When the mouse cursor re-enters the text window,
 *         the selection will be highlighted again.
 * 4.      When the play button is pressed, the text currently selected
 *         in the text window (rather than the text initially associated
 *         with the edit) will be displayed.
 * 5.      The name of the menu_option "Show Quote Window Specifications panel"
 *         is shortened to be "Quote Window Options ..."
 * 6.      A notify_interpose_destroy_func() is being added to fix the bug
 *         that QuoteMaker might exit without killing the Quote Window (which
 *         is also a base window).
 * 7.      When a different font family or font style is selected, the change
 *         will be automatically be reflected on the Quote Window (without the
 *         need to "play" the edit in order to verify the font).  For font
 *         size, the change will be reflected when either a return character is
 *         entered at the text field or when one of those numeric "arrows"
 *         are pressed.
 * 8.      The play button will now flash when an edit is being played.
 *         Pause button will also glow when playing is paused.
 * 9.      In the course of playing, when another edit is selected,
 *         the playing will be stopped.
 * 10.     I have used Saber to clean up the code.
 * 11.     The left-over "NewEditListPopUp" window is removed.
 * 12.     The bug that when quote window is iconified, it wont be un-iconified
 *         when the edit is played in timeline, is fixed.
 * 13.     The DurationEstimate function is changed so that it no longer
 *         needs an edit to be selected first.  It will take textWindowStart
 *         and textWindowEnd directly as input parameters.
 * 
 * 
 * 
 * Revision 1.5  91/09/05  15:48:04  derek
 * The following changes are made:
 * 1.      The name "Quoted Text Window" has been changed to "Quote Window"
 *         in the app.
 * 2.      ShowApplication() and HideApplication() is changed because of the
 *         the change of quote window from a popup to a basewindow.
 * 3.      The QuitProc of QuoteMaker is fixed so that the quote window,
 *         as a base window, will be destroyed separately.
 * 4.      Now hitting return in the label field will not result in adding
 *         a new edit.
 * 5.      Copyright messages are included in front of every .h and .c file.
 * 6.      The scrollbar and the footer of the Quote Window are hidden.
 * 7.      I have changed the include openpanel.h statement in QuoteMaker.c
 *         to include Browse.h.
 * 8.      The delete bug corresponding to the change that the panel-list
 *         must have a choice -- is fixed.  Also, the corresponding bug
 *         for deleteAll is also fixed.
 * 9.      Now, deleteAll and deletion of the last item in Panel_list
 *         will cause the panel-list to be destroyed and a new one will
 *         be created.
 * 10.     GetOpt files have been removed from the directory.  Corresponding
 *         changes are made.
 * 11.     The start and end byte fields are removed from the main panel.
 * 12.     I have put iconify, hide and show quote window to be buttons
 *         instead of menu options.
 * 13.     I have removed the PreviewPanelPopup and incorporated its features into
 *         the main panel.  The three buttons:  pause, play and stop and
 *         the DurationGauge are moved to the main panel.  But the
 *         StatusMessage is removed.
 * 14.     The EnableLocationChange and EnableSizeChange choice setting
 *         are removed.  There are no longer such choices.
 * 15.     Right now if a panel-item is selected and if another panel-item
 *         is picked, the DeselectList() operation in the middle is
 *         eliminated.  This operation involves updating of text fields and
 *         messages and its removal speeds up the program.  The panel-list
 *         must now take at least one choice.  (A choice must be selected
 *         whenever there is at least one item on the list).  And now
 *         there is no way to deselect a list by the user.
 * 16.     The "modified bit" associated with the CurrentSelectionNumberLabel
 *         is implemented.  Now, if a selection is picked, and if either
 *         the quote window is moved or any text fields are changed, the
 *         modified bit will be on.
 * 17.     The Show-text-window button and the Show-quote-window-specifications-popup
 *         button are removed.  They are now menu options under the Options Menu.
 * 18.     The Modify button has its name changed to "Update Edit".
 * 
 * Revision 1.4  91/08/28  14:06:11  derek
 * The following things are done:
 * 1.	I have changed the NewEditList option to call the file browser
 * 	instead of giving a popup window.
 * 2.	I ahve renamed all the options in the file menu so that they
 * 	are clearer and more informative.
 * 3.	The documentFileType has been changed from "DTR" (which was
 * 	a copying fault :)) to "QuoteMaker".
 * 4.	I ahve changed the stop button so that if it sees that 
 * 	HideQTWAfterPlayingEdit is true, stopplay will hide the window too.
 * 5.	I have changed QuoteMaker.G (the interface) so that there is no
 * 	way to deselect a fontfamily and fontstyle item from the panel list
 * 	(ie. a choice is required.)
 * 
 * Revision 1.3  91/08/27  14:37:38  derek
 * The following things are done:
 * 1.	The QuotedTextWindow is changed from a base window to a popup window
 * 	(now it's called QuotedMaker_quotedTextBaseWindow).  I have also
 * 	added a few options: show, hide and iconify QTW and also created
 * 	an icon for QTW.
 * 2.	The quoted text will be set in PerformSelection() instead of 
 * 	in SetSelection().
 * 3.	I have changed the Document field and the EditList field of 
 * 	QuoteMaker so that they will display fill paths.
 * 
 * Revision 1.2  91/08/26  12:10:21  derek
 * The following things are done:
 * 1.	I have added a few notice_prompts to the linkProtocol (network)
 * 	functions to give warnings about invalid document names.
 * 2.	The quoted text window will by default be hidden during "blank"
 * 	times. ie. when it is not displaying any text.  The interface has
 * 	been changed so that it now has a HideQuotedTExtWindowAfterPreview
 * 	check box.  The QuotedTextWindow will either stay on the screen
 * 	or be hidden as the author desires.
 * 3.	Make the changes corresponding to the changing of name from OpenPanel
 * 	to Browse.
 * 4.	The return value bug for OpenHandler, SaveHandler is fixed.
 * 5.	I have changed the code so that Save and SaveAs will behave correctly.
 * 	The SaveAs PopUp/Open PopUp are removed.  Browse check is 
 * 	incorporated in the applications.
 * 6.	The QuoteMaker file format has been changed.  An EditNumber field	
 * 	has been added.
 * 7.	Changes corresponding to the return value by OpenDoc and SetSelection
 * 	are made.
 * 8.	GetAppIcon() has been implemented.
 * 9.	Fonts specified in the Edit-list will be preloaded in OpenDoc().
 * 	This will hopefully eliminate the startup delay needed to load
 * 	the font when we put text onto the Quoted TExt Window for the 
 * 	first time.
 * 10.	The "play" button will now play things specified in the 
 * 	QuotedTExtWindowSpecificationsPopUp (instead of those specified
 * 	in the editList).
 * 11.	The show selection button is replaced by the set selection button.
 * 	The Set Selection button willl now not only set the current
 * 	edit parameters but will also highlight the corresponding section
 * 	in the text.  Also, when one item on the panel-list is clicked on,
 * 	the corresponding segment in the text will also be highlighted.
 * 12.	Notify events which tells the app to show the size and location 
 * 	of the Quoted Text Window are set up.  ie. those text-fields
 * 	on the interface will be updated instantaneously.
 * 16.	editList.label is being sent across the network.
 * 17.	The title bar and the footer of the QuotedTExtWindow are hidden.
 * 
 * Revision 1.1  91/08/13  22:52:39  derek
 * Initial revision
 *  */
static char rcsid[] = "$Header: /Source/Media/collab/QuoteMaker/RCS/openpanel.c,v 2.11 92/05/14 15:43:40 drapeau Exp $";

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <gdd.h>
#include "QuoteMaker_ui.h"
#include <sys/stat.h>
#include <xview/font.h>
#include <xview/notice.h>
#include <xview/notify.h>
#include <xview/server.h>          
#include <xview/seln.h>            
#include "Sender.h"
#include "Receiver.h"
#include "quoteMakerDefs.h"
#include <Browse.h>
#include <string.h>

void
  InitBrowse()
{
  (void) CreateBrowse(OpenHandler,
		      SaveHandler,
		      QuoteMaker_baseWindow->baseWindow);
  documentFirstLine = strdup("#QuoteMaker Edit Document#");
  documentFileType = strdup("QuoteMaker");
}



/*
 *  This OpenHandler is called by Browse(), which in turn is invoked by
 *  Menu_item Open(item, op).
 */
int
  OpenHandler(proposedPath, id)
char  *proposedPath;
int   id;
{
  switch(id)
  {
   case IS_TEXTFILE:
  {
    int		result;
    char	message [MAX_MESSAGE_LEN + 1];
    struct stat	fileInfo;

    result = stat(proposedPath,&fileInfo);			    /* Attempt to get info about the specified file */
    if ((result == 0) && (!(fileInfo.st_mode & S_IFDIR)))	    /* Does file exist (if so, is it *not* a directory)? */
    {								    /* Yes, the file exists; continue as normal */
      if (unsavedChangesExist == YES)
	GiveOneLastChanceToSave();
      UnHighlightSelection();
      DeselectList();
      ResetCurrentSelection();
      EmptyList();	   
      UpdateNumEditsMessage();
      SetDocument(proposedPath);
      Show(&QuoteMaker_textWindowPopup->textWindowPopup);
      SetEditList("NoneSpecified");
      untitledEditListNum ++;
      unsavedChangesExist = NO;
      return FILE_OK;
    }
    else
    {
      sprintf(message, "Cannot find '%s'.", proposedPath);
      AlertByNoticePrompt(QuoteMaker_baseWindow->baseWindow, message);
      return FILE_NOT_OK;
    }
  }

   case IS_EDITLIST:
    return(ReadEditListFromFile(proposedPath, USER));
   
   default:
    fprintf(stderr, "Unknown id value in OpenHandler.\n");
    exit(0);

  }
}



/*
 *  This SaveHandler is called by Browse(), which in turn is invoked by
 *  Menu_item Save(item, op).
 */
int
  SaveHandler(proposedPath, id)
char  *proposedPath;
int   id;
{
  switch(id)
  {
   case IS_EDITLIST:
    return(WriteEditListToFile(proposedPath, SAVE_AS));

   default:
    fprintf(stderr, "Unknown id value in SaveHandler.\n");
    exit(0);
  }
}
