/*
 * QuoteMaker_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `QuoteMaker.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include <gcm.h>
#include "QuoteMaker_ui.h"

/*
 * Create object `fileMenu' in the specified instance.
 */
Xv_opaque
QuoteMaker_fileMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	ShowOpenEditListPopup(Menu_item, Menu_generate);
	extern Menu_item	SaveEditListHandler(Menu_item, Menu_generate);
	extern Menu_item	SaveEditListAsHandler(Menu_item, Menu_generate);
	extern Menu_item	NewDocumentToAnnotateHandler(Menu_item, Menu_generate);
	extern Menu_item	Info(Menu_item, Menu_generate);
	extern Menu_item	Quit(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Document",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Open Edit List...",
			MENU_GEN_PROC, ShowOpenEditListPopup,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Save Edit List...",
			MENU_GEN_PROC, SaveEditListHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Save Edit List As...",
			MENU_GEN_PROC, SaveEditListAsHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "New document to annotate...",
			MENU_GEN_PROC, NewDocumentToAnnotateHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Info about QuoteMaker...",
			MENU_GEN_PROC, Info,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Quit",
			MENU_GEN_PROC, Quit,
			NULL,
		MENU_GEN_PIN_WINDOW, owner, "Document",
		NULL);
	return obj;
}

/*
 * Create object `OptionsMenu' in the specified instance.
 */
Xv_opaque
QuoteMaker_OptionsMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	ShowTextWindowHandler(Menu_item, Menu_generate);
	extern Menu_item	ShowQuoteWindowSpecificationsPanelHandler(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show Text Window",
			MENU_GEN_PROC, ShowTextWindowHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Quote Window Options ...",
			MENU_GEN_PROC, ShowQuoteWindowSpecificationsPanelHandler,
			NULL,
		MENU_GEN_PIN_WINDOW, owner, "",
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `baseWindow'.
 */
QuoteMaker_baseWindow_objects *
QuoteMaker_baseWindow_objects_initialize(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (QuoteMaker_baseWindow_objects *) calloc(1, sizeof (QuoteMaker_baseWindow_objects))))
		return (QuoteMaker_baseWindow_objects *) NULL;
	if (!ip->baseWindow)
		ip->baseWindow = QuoteMaker_baseWindow_baseWindow_create(ip, owner);
	if (!ip->editListControlPanel)
		ip->editListControlPanel = QuoteMaker_baseWindow_editListControlPanel_create(ip, ip->baseWindow);
	if (!ip->fileMenuButton)
		ip->fileMenuButton = QuoteMaker_baseWindow_fileMenuButton_create(ip, ip->editListControlPanel);
	if (!ip->OptionsButton)
		ip->OptionsButton = QuoteMaker_baseWindow_OptionsButton_create(ip, ip->editListControlPanel);
	if (!ip->docLabel)
		ip->docLabel = QuoteMaker_baseWindow_docLabel_create(ip, ip->editListControlPanel);
	if (!ip->docNameLabel)
		ip->docNameLabel = QuoteMaker_baseWindow_docNameLabel_create(ip, ip->editListControlPanel);
	if (!ip->editListLabel)
		ip->editListLabel = QuoteMaker_baseWindow_editListLabel_create(ip, ip->editListControlPanel);
	if (!ip->editListNameLabel)
		ip->editListNameLabel = QuoteMaker_baseWindow_editListNameLabel_create(ip, ip->editListControlPanel);
	if (!ip->editListColumnNamesLabel)
		ip->editListColumnNamesLabel = QuoteMaker_baseWindow_editListColumnNamesLabel_create(ip, ip->editListControlPanel);
	if (!ip->editListScrolledList)
		ip->editListScrolledList = QuoteMaker_baseWindow_editListScrolledList_create(ip, ip->editListControlPanel);
	if (!ip->PreviewControl)
		ip->PreviewControl = QuoteMaker_baseWindow_PreviewControl_create(ip, ip->baseWindow);
	if (!ip->PreviewPanelMessage)
		ip->PreviewPanelMessage = QuoteMaker_baseWindow_PreviewPanelMessage_create(ip, ip->PreviewControl);
	if (!ip->PauseButton)
		ip->PauseButton = QuoteMaker_baseWindow_PauseButton_create(ip, ip->PreviewControl);
	if (!ip->StopButton)
		ip->StopButton = QuoteMaker_baseWindow_StopButton_create(ip, ip->PreviewControl);
	if (!ip->PlayButton)
		ip->PlayButton = QuoteMaker_baseWindow_PlayButton_create(ip, ip->PreviewControl);
	if (!ip->DurationGauge)
		ip->DurationGauge = QuoteMaker_baseWindow_DurationGauge_create(ip, ip->PreviewControl);
	if (!ip->StartTimeMessage)
		ip->StartTimeMessage = QuoteMaker_baseWindow_StartTimeMessage_create(ip, ip->PreviewControl);
	if (!ip->EndTimeMessage)
		ip->EndTimeMessage = QuoteMaker_baseWindow_EndTimeMessage_create(ip, ip->PreviewControl);
	if (!ip->selectionControlPanellist2)
		ip->selectionControlPanellist2 = QuoteMaker_baseWindow_selectionControlPanellist2_create(ip, ip->baseWindow);
	if (!ip->currentSelectionLabel)
		ip->currentSelectionLabel = QuoteMaker_baseWindow_currentSelectionLabel_create(ip, ip->selectionControlPanellist2);
	if (!ip->currentSelectionNumberLabel)
		ip->currentSelectionNumberLabel = QuoteMaker_baseWindow_currentSelectionNumberLabel_create(ip, ip->selectionControlPanellist2);
	if (!ip->numEditsLabel)
		ip->numEditsLabel = QuoteMaker_baseWindow_numEditsLabel_create(ip, ip->selectionControlPanellist2);
	if (!ip->showSelectionButton)
		ip->showSelectionButton = QuoteMaker_baseWindow_showSelectionButton_create(ip, ip->selectionControlPanellist2);
	if (!ip->selectionLabelLabel)
		ip->selectionLabelLabel = QuoteMaker_baseWindow_selectionLabelLabel_create(ip, ip->selectionControlPanellist2);
	if (!ip->selectionLabelField)
		ip->selectionLabelField = QuoteMaker_baseWindow_selectionLabelField_create(ip, ip->selectionControlPanellist2);
	if (!ip->Duration)
		ip->Duration = QuoteMaker_baseWindow_Duration_create(ip, ip->selectionControlPanellist2);
	if (!ip->DurationMinsTextField)
		ip->DurationMinsTextField = QuoteMaker_baseWindow_DurationMinsTextField_create(ip, ip->selectionControlPanellist2);
	if (!ip->Minutes)
		ip->Minutes = QuoteMaker_baseWindow_Minutes_create(ip, ip->selectionControlPanellist2);
	if (!ip->DurationSecsTextField)
		ip->DurationSecsTextField = QuoteMaker_baseWindow_DurationSecsTextField_create(ip, ip->selectionControlPanellist2);
	if (!ip->Seconds)
		ip->Seconds = QuoteMaker_baseWindow_Seconds_create(ip, ip->selectionControlPanellist2);
	if (!ip->ShowQuoteWindowButton)
		ip->ShowQuoteWindowButton = QuoteMaker_baseWindow_ShowQuoteWindowButton_create(ip, ip->selectionControlPanellist2);
	if (!ip->EstimateDurationButton)
		ip->EstimateDurationButton = QuoteMaker_baseWindow_EstimateDurationButton_create(ip, ip->selectionControlPanellist2);
	if (!ip->HideQuoteWindowButton)
		ip->HideQuoteWindowButton = QuoteMaker_baseWindow_HideQuoteWindowButton_create(ip, ip->selectionControlPanellist2);
	if (!ip->HIdeQuoteWindowAfterPlayingEditMessage1)
		ip->HIdeQuoteWindowAfterPlayingEditMessage1 = QuoteMaker_baseWindow_HIdeQuoteWindowAfterPlayingEditMessage1_create(ip, ip->selectionControlPanellist2);
	if (!ip->HideQuoteWindowAfterPlayingEditSetting)
		ip->HideQuoteWindowAfterPlayingEditSetting = QuoteMaker_baseWindow_HideQuoteWindowAfterPlayingEditSetting_create(ip, ip->selectionControlPanellist2);
	if (!ip->IconifyQuoteWindowButton)
		ip->IconifyQuoteWindowButton = QuoteMaker_baseWindow_IconifyQuoteWindowButton_create(ip, ip->selectionControlPanellist2);
	if (!ip->HideQuoteWindowAfterPlayingEditMessage2)
		ip->HideQuoteWindowAfterPlayingEditMessage2 = QuoteMaker_baseWindow_HideQuoteWindowAfterPlayingEditMessage2_create(ip, ip->selectionControlPanellist2);
	if (!ip->addButton)
		ip->addButton = QuoteMaker_baseWindow_addButton_create(ip, ip->selectionControlPanellist2);
	if (!ip->modifyButton)
		ip->modifyButton = QuoteMaker_baseWindow_modifyButton_create(ip, ip->selectionControlPanellist2);
	if (!ip->deleteButton)
		ip->deleteButton = QuoteMaker_baseWindow_deleteButton_create(ip, ip->selectionControlPanellist2);
	if (!ip->deleteAllButton)
		ip->deleteAllButton = QuoteMaker_baseWindow_deleteAllButton_create(ip, ip->selectionControlPanellist2);
	return ip;
}

/*
 * Create object `baseWindow' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_baseWindow_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque		baseWindow_image;
	static unsigned short	baseWindow_bits[] = {
#include "./icons/QuoteMaker.icon"
	};
	
	baseWindow_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, baseWindow_bits,
		XV_WIDTH, 64,
		XV_HEIGHT, 64,
		NULL);
	obj = xv_create(owner, FRAME,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 501,
		XV_HEIGHT, 665,
		XV_LABEL, "QuoteMaker",
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_ICON, xv_create(XV_NULL, ICON,
			ICON_IMAGE, baseWindow_image,
			NULL),
		NULL);
	gcm_initialize_colors(obj, "light gray", NULL);
	return obj;
}

/*
 * Create object `editListControlPanel' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_editListControlPanel_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 14,
		XV_Y, 16,
		XV_WIDTH, 471,
		XV_HEIGHT, 298,
		WIN_BORDER, TRUE,
		NULL);
	gcm_initialize_colors(obj, "Light Gray", NULL);
	return obj;
}

/*
 * Create object `fileMenuButton' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_fileMenuButton_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 29,
		XV_Y, 14,
		PANEL_LABEL_STRING, "Document",
		PANEL_ITEM_MENU, QuoteMaker_fileMenu_create((caddr_t) ip, ip->baseWindow),
		NULL);
	return obj;
}

/*
 * Create object `OptionsButton' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_OptionsButton_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 150,
		XV_Y, 14,
		PANEL_LABEL_STRING, "Options",
		PANEL_ITEM_MENU, QuoteMaker_OptionsMenu_create((caddr_t) ip, ip->baseWindow),
		NULL);
	return obj;
}

/*
 * Create object `docLabel' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_docLabel_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 30,
		XV_Y, 43,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Source Text :",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `docNameLabel' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_docNameLabel_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 124,
		XV_Y, 44,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "None Loaded",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `editListLabel' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_editListLabel_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 30,
		XV_Y, 63,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Edit   List  :",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `editListNameLabel' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_editListNameLabel_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 124,
		XV_Y, 63,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Untitled",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `editListColumnNamesLabel' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_editListColumnNamesLabel_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 32,
		XV_Y, 87,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Edit #           Label                  Duration      Hide Window After Play",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `editListScrolledList' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_editListScrolledList_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	extern int		DumpEntry(Panel_item, char *, Xv_opaque, Panel_list_op, Event *, int);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_LIST,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 22,
		XV_Y, 111,
		PANEL_LIST_WIDTH, 410,
		PANEL_LIST_DISPLAY_ROWS, 8,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, TRUE,
		PANEL_CHOOSE_ONE, TRUE,
		PANEL_CHOOSE_NONE, FALSE,
		PANEL_NOTIFY_PROC, DumpEntry,
		NULL);
	return obj;
}

/*
 * Create object `PreviewControl' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_PreviewControl_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 14,
		XV_Y, 323,
		XV_WIDTH, 471,
		XV_HEIGHT, 83,
		WIN_BORDER, TRUE,
		NULL);
	gcm_initialize_colors(obj, "Light Gray", NULL);
	return obj;
}

/*
 * Create object `PreviewPanelMessage' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_PreviewPanelMessage_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 196,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Preview Panel",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `PauseButton' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_PauseButton_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	extern void		PauseButtonHandler(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		PauseButton_image;
	static unsigned short	PauseButton_bits[] = {
#include "icons/pause.icon"
	};
	
	PauseButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, PauseButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 32,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 28,
		XV_Y, 28,
		PANEL_LABEL_IMAGE, PauseButton_image,
		PANEL_NOTIFY_PROC, PauseButtonHandler,
		NULL);
	return obj;
}

/*
 * Create object `StopButton' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_StopButton_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	extern void		StopButtonHandler(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		StopButton_image;
	static unsigned short	StopButton_bits[] = {
#include "icons/stop.icon"
	};
	
	StopButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, StopButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 32,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 92,
		XV_Y, 28,
		PANEL_LABEL_IMAGE, StopButton_image,
		PANEL_NOTIFY_PROC, StopButtonHandler,
		NULL);
	return obj;
}

/*
 * Create object `PlayButton' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_PlayButton_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	extern void		PlayButtonHandler(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		PlayButton_image;
	static unsigned short	PlayButton_bits[] = {
#include "icons/play.icon"
	};
	
	PlayButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, PlayButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 32,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 156,
		XV_Y, 28,
		PANEL_LABEL_IMAGE, PlayButton_image,
		PANEL_NOTIFY_PROC, PlayButtonHandler,
		NULL);
	return obj;
}

/*
 * Create object `DurationGauge' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_DurationGauge_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_GAUGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 232,
		XV_Y, 36,
		PANEL_GAUGE_WIDTH, 130,
		PANEL_TICKS, 0,
		PANEL_LABEL_STRING, "Duration :",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SHOW_RANGE, FALSE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_VALUE, 0,
		NULL);
	return obj;
}

/*
 * Create object `StartTimeMessage' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_StartTimeMessage_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 304,
		XV_Y, 56,
		PANEL_LABEL_STRING, "0:00",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `EndTimeMessage' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_EndTimeMessage_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 424,
		XV_Y, 56,
		PANEL_LABEL_STRING, "0:00",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `selectionControlPanellist2' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_selectionControlPanellist2_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 14,
		XV_Y, 415,
		XV_WIDTH, 471,
		XV_HEIGHT, 230,
		WIN_BORDER, TRUE,
		NULL);
	gcm_initialize_colors(obj, "Light Gray", NULL);
	return obj;
}

/*
 * Create object `currentSelectionLabel' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_currentSelectionLabel_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 36,
		XV_Y, 16,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Current Selection:",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `currentSelectionNumberLabel' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_currentSelectionNumberLabel_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 168,
		XV_Y, 16,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "New Edit",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `numEditsLabel' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_numEditsLabel_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 292,
		XV_Y, 16,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Number of Edits: 0",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `showSelectionButton' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_showSelectionButton_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	extern void		ShowSelection(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 270,
		XV_Y, 51,
		PANEL_LABEL_WIDTH, 167,
		PANEL_LABEL_STRING, "        Set  Selection",
		PANEL_NOTIFY_PROC, ShowSelection,
		NULL);
	return obj;
}

/*
 * Create object `selectionLabelLabel' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_selectionLabelLabel_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 32,
		XV_Y, 52,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Label",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `selectionLabelField' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_selectionLabelField_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	TextFieldAddSelection(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 76,
		XV_Y, 52,
		PANEL_VALUE_DISPLAY_LENGTH, 20,
		PANEL_VALUE_STORED_LENGTH, 20,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, TextFieldAddSelection,
		NULL);
	return obj;
}

/*
 * Create object `Duration' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_Duration_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 31,
		XV_Y, 75,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Duration",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `DurationMinsTextField' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_DurationMinsTextField_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	DurationMinsTextFieldHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 107,
		XV_Y, 75,
		PANEL_VALUE_DISPLAY_LENGTH, 3,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, DurationMinsTextFieldHandler,
		NULL);
	return obj;
}

/*
 * Create object `Minutes' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_Minutes_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 160,
		XV_Y, 75,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "m.",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `DurationSecsTextField' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_DurationSecsTextField_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	DurationSecsTextFieldHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 182,
		XV_Y, 75,
		PANEL_VALUE_DISPLAY_LENGTH, 4,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, DurationSecsTextFieldHandler,
		NULL);
	return obj;
}

/*
 * Create object `Seconds' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_Seconds_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 234,
		XV_Y, 75,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "s.",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `ShowQuoteWindowButton' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_ShowQuoteWindowButton_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	extern void		ShowQuoteWindowButtonHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 269,
		XV_Y, 80,
		PANEL_LABEL_WIDTH, 167,
		PANEL_LABEL_STRING, "   Show Quote Window",
		PANEL_NOTIFY_PROC, ShowQuoteWindowButtonHandler,
		NULL);
	return obj;
}

/*
 * Create object `EstimateDurationButton' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_EstimateDurationButton_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	extern void		EstimateDurationNotifyHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 112,
		XV_Y, 100,
		PANEL_LABEL_STRING, "Estimate Duration",
		PANEL_NOTIFY_PROC, EstimateDurationNotifyHandler,
		NULL);
	return obj;
}

/*
 * Create object `HideQuoteWindowButton' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_HideQuoteWindowButton_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	extern void		HideQuoteWindowButtonHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 269,
		XV_Y, 109,
		PANEL_LABEL_WIDTH, 167,
		PANEL_LABEL_STRING, "   Hide Quote Window",
		PANEL_NOTIFY_PROC, HideQuoteWindowButtonHandler,
		NULL);
	return obj;
}

/*
 * Create object `HIdeQuoteWindowAfterPlayingEditMessage1' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_HIdeQuoteWindowAfterPlayingEditMessage1_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 128,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "Hide Quote Window",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `HideQuoteWindowAfterPlayingEditSetting' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_HideQuoteWindowAfterPlayingEditSetting_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	extern void		HideQuoteWindowAfterPlayingEditSettingHandler(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_CHOICE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 160,
		XV_Y, 132,
		PANEL_CHOICE_NROWS, 1,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_CHOOSE_NONE, FALSE,
		PANEL_NOTIFY_PROC, HideQuoteWindowAfterPlayingEditSettingHandler,
		PANEL_CHOICE_STRINGS,
			"NO",
			"YES",
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `IconifyQuoteWindowButton' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_IconifyQuoteWindowButton_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	extern void		IconifyQuoteWindowButtonHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 269,
		XV_Y, 138,
		PANEL_LABEL_WIDTH, 167,
		PANEL_LABEL_STRING, "  Iconify Quote Window",
		PANEL_NOTIFY_PROC, IconifyQuoteWindowButtonHandler,
		NULL);
	return obj;
}

/*
 * Create object `HideQuoteWindowAfterPlayingEditMessage2' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_HideQuoteWindowAfterPlayingEditMessage2_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 144,
		PANEL_ITEM_COLOR, gcm_color_index("black"),
		PANEL_LABEL_STRING, "After Playing Edit",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `addButton' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_addButton_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	extern void		AddSelection(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 32,
		XV_Y, 184,
		PANEL_LABEL_STRING, "      Add      ",
		PANEL_NOTIFY_PROC, AddSelection,
		NULL);
	return obj;
}

/*
 * Create object `modifyButton' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_modifyButton_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	extern void		ModifySelection(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 130,
		XV_Y, 184,
		PANEL_LABEL_STRING, " Update Edit  ",
		PANEL_NOTIFY_PROC, ModifySelection,
		NULL);
	return obj;
}

/*
 * Create object `deleteButton' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_deleteButton_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	extern void		DeleteSelection(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 240,
		XV_Y, 184,
		PANEL_LABEL_STRING, "    Delete    ",
		PANEL_NOTIFY_PROC, DeleteSelection,
		NULL);
	return obj;
}

/*
 * Create object `deleteAllButton' in the specified instance.
 */
Xv_opaque
QuoteMaker_baseWindow_deleteAllButton_create(QuoteMaker_baseWindow_objects *ip, Xv_opaque owner)
{
	extern void		DeleteAllSelections(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 337,
		XV_Y, 184,
		PANEL_LABEL_STRING, " Delete All ",
		PANEL_NOTIFY_PROC, DeleteAllSelections,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `infoPopup'.
 */
QuoteMaker_infoPopup_objects *
QuoteMaker_infoPopup_objects_initialize(QuoteMaker_infoPopup_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (QuoteMaker_infoPopup_objects *) calloc(1, sizeof (QuoteMaker_infoPopup_objects))))
		return (QuoteMaker_infoPopup_objects *) NULL;
	if (!ip->infoPopup)
		ip->infoPopup = QuoteMaker_infoPopup_infoPopup_create(ip, owner);
	if (!ip->infoControlPanel)
		ip->infoControlPanel = QuoteMaker_infoPopup_infoControlPanel_create(ip, ip->infoPopup);
	if (!ip->appNameMessage)
		ip->appNameMessage = QuoteMaker_infoPopup_appNameMessage_create(ip, ip->infoControlPanel);
	if (!ip->appVersionMessage)
		ip->appVersionMessage = QuoteMaker_infoPopup_appVersionMessage_create(ip, ip->infoControlPanel);
	if (!ip->appDescriptionMessage)
		ip->appDescriptionMessage = QuoteMaker_infoPopup_appDescriptionMessage_create(ip, ip->infoControlPanel);
	if (!ip->appDescription2Message)
		ip->appDescription2Message = QuoteMaker_infoPopup_appDescription2Message_create(ip, ip->infoControlPanel);
	if (!ip->developerMessage)
		ip->developerMessage = QuoteMaker_infoPopup_developerMessage_create(ip, ip->infoControlPanel);
	if (!ip->modsMessage)
		ip->modsMessage = QuoteMaker_infoPopup_modsMessage_create(ip, ip->infoControlPanel);
	if (!ip->copyrightMessage)
		ip->copyrightMessage = QuoteMaker_infoPopup_copyrightMessage_create(ip, ip->infoControlPanel);
	if (!ip->copyright2Message)
		ip->copyright2Message = QuoteMaker_infoPopup_copyright2Message_create(ip, ip->infoControlPanel);
	if (!ip->copyright3Message)
		ip->copyright3Message = QuoteMaker_infoPopup_copyright3Message_create(ip, ip->infoControlPanel);
	if (!ip->moreInfoMessage)
		ip->moreInfoMessage = QuoteMaker_infoPopup_moreInfoMessage_create(ip, ip->infoControlPanel);
	return ip;
}

/*
 * Create object `infoPopup' in the specified instance.
 */
Xv_opaque
QuoteMaker_infoPopup_infoPopup_create(QuoteMaker_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 500,
		XV_HEIGHT, 316,
		XV_LABEL, "QuoteMaker Info",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	gcm_initialize_colors(obj, "light gray", NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `infoControlPanel' in the specified instance.
 */
Xv_opaque
QuoteMaker_infoPopup_infoControlPanel_create(QuoteMaker_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 15,
		XV_Y, 15,
		XV_WIDTH, 472,
		XV_HEIGHT, 285,
		WIN_BORDER, TRUE,
		NULL);
	gcm_initialize_colors(obj, "Light Gray", NULL);
	return obj;
}

/*
 * Create object `appNameMessage' in the specified instance.
 */
Xv_opaque
QuoteMaker_infoPopup_appNameMessage_create(QuoteMaker_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 192,
		XV_Y, 20,
		PANEL_LABEL_STRING, "QuoteMaker",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `appVersionMessage' in the specified instance.
 */
Xv_opaque
QuoteMaker_infoPopup_appVersionMessage_create(QuoteMaker_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 200,
		XV_Y, 40,
		PANEL_LABEL_STRING, "Version 2.13",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `appDescriptionMessage' in the specified instance.
 */
Xv_opaque
QuoteMaker_infoPopup_appDescriptionMessage_create(QuoteMaker_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 112,
		XV_Y, 70,
		PANEL_LABEL_STRING, "Text annotation application for use with",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `appDescription2Message' in the specified instance.
 */
Xv_opaque
QuoteMaker_infoPopup_appDescription2Message_create(QuoteMaker_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 80,
		XV_Y, 90,
		PANEL_LABEL_STRING, "the MAEstro Multimedia Authoring Environment",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `developerMessage' in the specified instance.
 */
Xv_opaque
QuoteMaker_infoPopup_developerMessage_create(QuoteMaker_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 168,
		XV_Y, 122,
		PANEL_LABEL_STRING, "Developed by Derek Lai",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `modsMessage' in the specified instance.
 */
Xv_opaque
QuoteMaker_infoPopup_modsMessage_create(QuoteMaker_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 28,
		XV_Y, 142,
		PANEL_LABEL_STRING, "(based on an application written by Al Sargent and George Drapeau)",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `copyrightMessage' in the specified instance.
 */
Xv_opaque
QuoteMaker_infoPopup_copyrightMessage_create(QuoteMaker_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 168,
		PANEL_LABEL_STRING, "Copyright (C) 1990, 1991, 1992 Libraries and Information Resources (L&IR)",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `copyright2Message' in the specified instance.
 */
Xv_opaque
QuoteMaker_infoPopup_copyright2Message_create(QuoteMaker_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 176,
		XV_Y, 194,
		PANEL_LABEL_STRING, "Stanford University",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `copyright3Message' in the specified instance.
 */
Xv_opaque
QuoteMaker_infoPopup_copyright3Message_create(QuoteMaker_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 176,
		XV_Y, 214,
		PANEL_LABEL_STRING, "Stanford, California",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `moreInfoMessage' in the specified instance.
 */
Xv_opaque
QuoteMaker_infoPopup_moreInfoMessage_create(QuoteMaker_infoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 84,
		XV_Y, 246,
		PANEL_LABEL_STRING, "For more info, contact maestro@sioux.stanford.edu",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `textWindowPopup'.
 */
QuoteMaker_textWindowPopup_objects *
QuoteMaker_textWindowPopup_objects_initialize(QuoteMaker_textWindowPopup_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (QuoteMaker_textWindowPopup_objects *) calloc(1, sizeof (QuoteMaker_textWindowPopup_objects))))
		return (QuoteMaker_textWindowPopup_objects *) NULL;
	if (!ip->textWindowPopup)
		ip->textWindowPopup = QuoteMaker_textWindowPopup_textWindowPopup_create(ip, owner);
	if (!ip->mainTextPane)
		ip->mainTextPane = QuoteMaker_textWindowPopup_mainTextPane_create(ip, ip->textWindowPopup);
	return ip;
}

/*
 * Create object `textWindowPopup' in the specified instance.
 */
Xv_opaque
QuoteMaker_textWindowPopup_textWindowPopup_create(QuoteMaker_textWindowPopup_objects *ip, Xv_opaque owner)
{
	extern Notify_value	TextWindowPopupEventHandler(Xv_window, Event *, Notify_arg, Notify_event_type);
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 600,
		XV_HEIGHT, 565,
		XV_LABEL, "QuoteMaker: No Current Document",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(obj, WIN_CONSUME_EVENTS,
		WIN_MOUSE_BUTTONS,
		LOC_MOVE,
		LOC_DRAG,
		LOC_WINENTER,
		LOC_WINEXIT,
		WIN_ASCII_EVENTS,
		WIN_LEFT_KEYS,
		WIN_RIGHT_KEYS,
		WIN_TOP_KEYS,
		NULL, NULL);
	notify_interpose_event_func(obj,
		(Notify_func) TextWindowPopupEventHandler, NOTIFY_SAFE);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `mainTextPane' in the specified instance.
 */
Xv_opaque
QuoteMaker_textWindowPopup_mainTextPane_create(QuoteMaker_textWindowPopup_objects *ip, Xv_opaque owner)
{
	extern Notify_value	TextPaneEventHandler(Xv_window, Event *, Notify_arg, Notify_event_type);
	Xv_opaque	obj;
	
	obj = xv_create(owner, TEXTSW,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		OPENWIN_SHOW_BORDERS, TRUE,
		TEXTSW_BROWSING, TRUE,
		TEXTSW_DISABLE_LOAD, TRUE,
		NULL);
	gcm_initialize_colors(obj, "white", "black");
	xv_set(textsw_first(obj), WIN_CONSUME_EVENTS,
		WIN_MOUSE_BUTTONS,
		LOC_MOVE,
		LOC_DRAG,
		LOC_WINENTER,
		LOC_WINEXIT,
		WIN_ASCII_EVENTS,
		WIN_LEFT_KEYS,
		WIN_RIGHT_KEYS,
		WIN_TOP_KEYS,
		NULL, NULL);
	notify_interpose_event_func(textsw_first(obj),
		(Notify_func) TextPaneEventHandler, NOTIFY_SAFE);
	return obj;
}

/*
 * Initialize an instance of object `QuoteWindowSpecificationsPopup'.
 */
QuoteMaker_QuoteWindowSpecificationsPopup_objects *
QuoteMaker_QuoteWindowSpecificationsPopup_objects_initialize(QuoteMaker_QuoteWindowSpecificationsPopup_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (QuoteMaker_QuoteWindowSpecificationsPopup_objects *) calloc(1, sizeof (QuoteMaker_QuoteWindowSpecificationsPopup_objects))))
		return (QuoteMaker_QuoteWindowSpecificationsPopup_objects *) NULL;
	if (!ip->QuoteWindowSpecificationsPopup)
		ip->QuoteWindowSpecificationsPopup = QuoteMaker_QuoteWindowSpecificationsPopup_QuoteWindowSpecificationsPopup_create(ip, owner);
	if (!ip->controls7)
		ip->controls7 = QuoteMaker_QuoteWindowSpecificationsPopup_controls7_create(ip, ip->QuoteWindowSpecificationsPopup);
	if (!ip->EditNumberColonMessage)
		ip->EditNumberColonMessage = QuoteMaker_QuoteWindowSpecificationsPopup_EditNumberColonMessage_create(ip, ip->controls7);
	if (!ip->EditNumberMessage)
		ip->EditNumberMessage = QuoteMaker_QuoteWindowSpecificationsPopup_EditNumberMessage_create(ip, ip->controls7);
	if (!ip->controls5)
		ip->controls5 = QuoteMaker_QuoteWindowSpecificationsPopup_controls5_create(ip, ip->QuoteWindowSpecificationsPopup);
	if (!ip->LocationLabelMessage)
		ip->LocationLabelMessage = QuoteMaker_QuoteWindowSpecificationsPopup_LocationLabelMessage_create(ip, ip->controls5);
	if (!ip->LocationMessage)
		ip->LocationMessage = QuoteMaker_QuoteWindowSpecificationsPopup_LocationMessage_create(ip, ip->controls5);
	if (!ip->SizeLabelMessage)
		ip->SizeLabelMessage = QuoteMaker_QuoteWindowSpecificationsPopup_SizeLabelMessage_create(ip, ip->controls5);
	if (!ip->SizeMessage)
		ip->SizeMessage = QuoteMaker_QuoteWindowSpecificationsPopup_SizeMessage_create(ip, ip->controls5);
	if (!ip->controls8)
		ip->controls8 = QuoteMaker_QuoteWindowSpecificationsPopup_controls8_create(ip, ip->QuoteWindowSpecificationsPopup);
	if (!ip->FontFamilyHeaderMessage)
		ip->FontFamilyHeaderMessage = QuoteMaker_QuoteWindowSpecificationsPopup_FontFamilyHeaderMessage_create(ip, ip->controls8);
	if (!ip->FontStyleHeaderMessage)
		ip->FontStyleHeaderMessage = QuoteMaker_QuoteWindowSpecificationsPopup_FontStyleHeaderMessage_create(ip, ip->controls8);
	if (!ip->FontFamilyList)
		ip->FontFamilyList = QuoteMaker_QuoteWindowSpecificationsPopup_FontFamilyList_create(ip, ip->controls8);
	if (!ip->FontStyleList)
		ip->FontStyleList = QuoteMaker_QuoteWindowSpecificationsPopup_FontStyleList_create(ip, ip->controls8);
	if (!ip->FontSizeTextField)
		ip->FontSizeTextField = QuoteMaker_QuoteWindowSpecificationsPopup_FontSizeTextField_create(ip, ip->controls8);
	if (!ip->controls6)
		ip->controls6 = QuoteMaker_QuoteWindowSpecificationsPopup_controls6_create(ip, ip->QuoteWindowSpecificationsPopup);
	if (!ip->QTWSpecsDoneButton)
		ip->QTWSpecsDoneButton = QuoteMaker_QuoteWindowSpecificationsPopup_QTWSpecsDoneButton_create(ip, ip->controls6);
	return ip;
}

/*
 * Create object `QuoteWindowSpecificationsPopup' in the specified instance.
 */
Xv_opaque
QuoteMaker_QuoteWindowSpecificationsPopup_QuoteWindowSpecificationsPopup_create(QuoteMaker_QuoteWindowSpecificationsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 400,
		XV_HEIGHT, 402,
		XV_LABEL, "Quote Window Specifications Panel",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	gcm_initialize_colors(obj, "Light Gray", NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `controls7' in the specified instance.
 */
Xv_opaque
QuoteMaker_QuoteWindowSpecificationsPopup_controls7_create(QuoteMaker_QuoteWindowSpecificationsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 12,
		XV_Y, 12,
		XV_WIDTH, 376,
		XV_HEIGHT, 48,
		WIN_BORDER, TRUE,
		NULL);
	gcm_initialize_colors(obj, "Light Gray", NULL);
	return obj;
}

/*
 * Create object `EditNumberColonMessage' in the specified instance.
 */
Xv_opaque
QuoteMaker_QuoteWindowSpecificationsPopup_EditNumberColonMessage_create(QuoteMaker_QuoteWindowSpecificationsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 36,
		XV_Y, 17,
		PANEL_LABEL_STRING, "Edit Number :",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `EditNumberMessage' in the specified instance.
 */
Xv_opaque
QuoteMaker_QuoteWindowSpecificationsPopup_EditNumberMessage_create(QuoteMaker_QuoteWindowSpecificationsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 156,
		XV_Y, 17,
		PANEL_LABEL_STRING, "None",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `controls5' in the specified instance.
 */
Xv_opaque
QuoteMaker_QuoteWindowSpecificationsPopup_controls5_create(QuoteMaker_QuoteWindowSpecificationsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 12,
		XV_Y, 73,
		XV_WIDTH, 376,
		XV_HEIGHT, 47,
		WIN_BORDER, TRUE,
		NULL);
	gcm_initialize_colors(obj, "Light Gray", NULL);
	return obj;
}

/*
 * Create object `LocationLabelMessage' in the specified instance.
 */
Xv_opaque
QuoteMaker_QuoteWindowSpecificationsPopup_LocationLabelMessage_create(QuoteMaker_QuoteWindowSpecificationsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 36,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Location :",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `LocationMessage' in the specified instance.
 */
Xv_opaque
QuoteMaker_QuoteWindowSpecificationsPopup_LocationMessage_create(QuoteMaker_QuoteWindowSpecificationsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 112,
		XV_Y, 16,
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `SizeLabelMessage' in the specified instance.
 */
Xv_opaque
QuoteMaker_QuoteWindowSpecificationsPopup_SizeLabelMessage_create(QuoteMaker_QuoteWindowSpecificationsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 216,
		XV_Y, 16,
		PANEL_LABEL_STRING, "Size :",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `SizeMessage' in the specified instance.
 */
Xv_opaque
QuoteMaker_QuoteWindowSpecificationsPopup_SizeMessage_create(QuoteMaker_QuoteWindowSpecificationsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 260,
		XV_Y, 16,
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `controls8' in the specified instance.
 */
Xv_opaque
QuoteMaker_QuoteWindowSpecificationsPopup_controls8_create(QuoteMaker_QuoteWindowSpecificationsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 12,
		XV_Y, 134,
		XV_WIDTH, 376,
		XV_HEIGHT, 193,
		WIN_BORDER, TRUE,
		NULL);
	gcm_initialize_colors(obj, "Light Gray", NULL);
	return obj;
}

/*
 * Create object `FontFamilyHeaderMessage' in the specified instance.
 */
Xv_opaque
QuoteMaker_QuoteWindowSpecificationsPopup_FontFamilyHeaderMessage_create(QuoteMaker_QuoteWindowSpecificationsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 60,
		XV_Y, 14,
		PANEL_LABEL_STRING, "Font Family",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `FontStyleHeaderMessage' in the specified instance.
 */
Xv_opaque
QuoteMaker_QuoteWindowSpecificationsPopup_FontStyleHeaderMessage_create(QuoteMaker_QuoteWindowSpecificationsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 240,
		XV_Y, 14,
		PANEL_LABEL_STRING, "Font Style",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `FontFamilyList' in the specified instance.
 */
Xv_opaque
QuoteMaker_QuoteWindowSpecificationsPopup_FontFamilyList_create(QuoteMaker_QuoteWindowSpecificationsPopup_objects *ip, Xv_opaque owner)
{
	extern int		FontFamilyNotifyHandler(Panel_item, char *, Xv_opaque, Panel_list_op, Event *, int);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_LIST,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 35,
		PANEL_LIST_WIDTH, 135,
		PANEL_LIST_DISPLAY_ROWS, 5,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, TRUE,
		PANEL_CHOOSE_ONE, TRUE,
		PANEL_CHOOSE_NONE, FALSE,
		PANEL_NOTIFY_PROC, FontFamilyNotifyHandler,
		NULL);
	return obj;
}

/*
 * Create object `FontStyleList' in the specified instance.
 */
Xv_opaque
QuoteMaker_QuoteWindowSpecificationsPopup_FontStyleList_create(QuoteMaker_QuoteWindowSpecificationsPopup_objects *ip, Xv_opaque owner)
{
	extern int		FontStyleNotifyHandler(Panel_item, char *, Xv_opaque, Panel_list_op, Event *, int);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_LIST,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 195,
		XV_Y, 35,
		PANEL_LIST_WIDTH, 135,
		PANEL_LIST_DISPLAY_ROWS, 5,
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, TRUE,
		PANEL_CHOOSE_ONE, TRUE,
		PANEL_CHOOSE_NONE, FALSE,
		PANEL_NOTIFY_PROC, FontStyleNotifyHandler,
		NULL);
	return obj;
}

/*
 * Create object `FontSizeTextField' in the specified instance.
 */
Xv_opaque
QuoteMaker_QuoteWindowSpecificationsPopup_FontSizeTextField_create(QuoteMaker_QuoteWindowSpecificationsPopup_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	FontSizeNotifyHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 106,
		XV_Y, 160,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_LABEL_STRING, "Font Size :",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 100,
		PANEL_MIN_VALUE, 0,
		PANEL_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, FontSizeNotifyHandler,
		NULL);
	return obj;
}

/*
 * Create object `controls6' in the specified instance.
 */
Xv_opaque
QuoteMaker_QuoteWindowSpecificationsPopup_controls6_create(QuoteMaker_QuoteWindowSpecificationsPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 12,
		XV_Y, 341,
		XV_WIDTH, 376,
		XV_HEIGHT, 45,
		WIN_BORDER, TRUE,
		NULL);
	gcm_initialize_colors(obj, "Light Gray", NULL);
	return obj;
}

/*
 * Create object `QTWSpecsDoneButton' in the specified instance.
 */
Xv_opaque
QuoteMaker_QuoteWindowSpecificationsPopup_QTWSpecsDoneButton_create(QuoteMaker_QuoteWindowSpecificationsPopup_objects *ip, Xv_opaque owner)
{
	extern void		QTWSpecsDoneButtonHandler(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 153,
		XV_Y, 12,
		PANEL_LABEL_STRING, "   Done   ",
		PANEL_NOTIFY_PROC, QTWSpecsDoneButtonHandler,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `quotedTextBaseWindow'.
 */
QuoteMaker_quotedTextBaseWindow_objects *
QuoteMaker_quotedTextBaseWindow_objects_initialize(QuoteMaker_quotedTextBaseWindow_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (QuoteMaker_quotedTextBaseWindow_objects *) calloc(1, sizeof (QuoteMaker_quotedTextBaseWindow_objects))))
		return (QuoteMaker_quotedTextBaseWindow_objects *) NULL;
	if (!ip->quotedTextBaseWindow)
		ip->quotedTextBaseWindow = QuoteMaker_quotedTextBaseWindow_quotedTextBaseWindow_create(ip, owner);
	if (!ip->quotedTextPane)
		ip->quotedTextPane = QuoteMaker_quotedTextBaseWindow_quotedTextPane_create(ip, ip->quotedTextBaseWindow);
	return ip;
}

/*
 * Create object `quotedTextBaseWindow' in the specified instance.
 */
Xv_opaque
QuoteMaker_quotedTextBaseWindow_quotedTextBaseWindow_create(QuoteMaker_quotedTextBaseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque		quotedTextBaseWindow_image;
	static unsigned short	quotedTextBaseWindow_bits[] = {
#include "./icons/QuotedTextWindow.icon"
	};
	
	quotedTextBaseWindow_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, quotedTextBaseWindow_bits,
		XV_WIDTH, 64,
		XV_HEIGHT, 64,
		NULL);
	obj = xv_create(owner, FRAME,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 717,
		XV_HEIGHT, 211,
		XV_LABEL, "Quoted Text Window",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, TRUE,
		FRAME_ICON, xv_create(XV_NULL, ICON,
			ICON_IMAGE, quotedTextBaseWindow_image,
			NULL),
		NULL);
	return obj;
}

/*
 * Create object `quotedTextPane' in the specified instance.
 */
Xv_opaque
QuoteMaker_quotedTextBaseWindow_quotedTextPane_create(QuoteMaker_quotedTextBaseWindow_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, TEXTSW,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		OPENWIN_SHOW_BORDERS, TRUE,
		NULL);
	gcm_initialize_colors(obj, "white", "black");
	return obj;
}

