/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/drapeau/PortManager/RCS/Diagnostics.c,v 0.11 91/09/18 13:07:41 drapeau Exp Locker: drapeau $ */
/* $Log:	Diagnostics.c,v $
 * Revision 0.11  91/09/18  13:07:41  drapeau
 * No changes.
 * 
 * Revision 0.10  91/09/09  18:24:33  drapeau
 * First version of the diagnostics routines, used by all other modules in this
 * program.
 *  */

static char	portMgrDiagRcsid[] = "$Header: /Source/Media/drapeau/PortManager/RCS/Diagnostics.c,v 0.11 91/09/18 13:07:41 drapeau Exp Locker: drapeau $";

#include <stdio.h>
#include <getopt.h>

static int	diagnosticsOn = 0;				    /* Flag to determine whether to print diagnostic messages */
char		diagMessage[1024];				    /* Space in which to print a diagnostic message */

void PrintDiagnostic(char* diagMessage)
{
  if (diagnosticsOn != 0)
    printf("%s", diagMessage);
  return;
}								    /* end function PrintDiagnostic */

void EnableDiagnostics()
{
  diagnosticsOn = 1;
  return;
}								    /* end function EnableDiagnostics */


/********************************************************************
 *	GetCommandLineOptions
 *
 *
 *	This function parses the command line and retrieves all the known
 *	options and their arguments.  The only option currently recognized by
 *	this function is "-diagnostics" (also known as "-d").
 */

void GetCommandLineOptions(int argc, char** argv)
{
  int			optionChar;  
  int			optionIndex = 0;
  static struct option	longOptions[] =
  {
    {"diagnostics", 0, 0, 'd'},
    {0, 0, 0, 0}
  };
  
  while (1)							    /* Start parsing all known options */
  {
    optionChar = getopt_long_only (argc, argv, "d:",
				   longOptions, &optionIndex);
    if (optionChar == EOF)					    /* Done with all known options */
    {
      break;
    }
    switch (optionChar)
    {
     case 'd':							    /* Turn on diagnostic messages if asked for */
      EnableDiagnostics();
      break;
     default:
      break;
    }								    /* end switch */
  }								    /* end while */
}								    /* end function GetCommandLineOptions */
