/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/drapeau/NetworkProtocol/RCS/Receiver.h,v 1.17 92/05/29 12:40:37 drapeau Exp $ */
/* $Log:	Receiver.h,v $
 * Revision 1.17  92/05/29  12:40:37  drapeau
 * Changed the name of the "Selection" structure to "MAESelection",
 * to avoid name conflicts with other software packages and toolkits
 * that might also define a "Selection" structure.
 * 
 * Revision 1.16  91/09/26  23:23:35  drapeau
 * Modified definition of CreateSocketOnPort() so that it takes a pointer to
 * integer.
 * 
 * Revision 1.15  91/09/18  12:43:59  drapeau
 * - Modified the definition of ReceiverGetPortFromName() to return a list of matching Ports, rather
 *   than a single Port.
 * - Changed the name of the major include file from LinkProtocol.h to MAEstro.h, in keeping with the
 *   project name.
 * 
 * Revision 1.14  91/09/03  16:57:41  drapeau
 * Modified the definition of ReceiverGetPortFromName() so that it
 * returns a Port* instead of a void*.
 * 
 * Revision 1.13  91/06/19  14:08:20  drapeau
 * Added support for five new messages:
 *  - PauseSelection
 *  - ResumeSelection
 *  - HideApplication
 *  - ShowApplication
 *  - GetAppIcon
 * Also, replaced the "PerformPartialSelection" message with
 * "HaltSelection" message.
 * 
 * Revision 1.12  91/06/17  18:17:21  drapeau
 * Added copyright notice.
 * 
 * Revision 1.11  1991/02/28  07:17:41  drapeau
 * No code changes; this version uses a new version numbering scheme and a new
 * version of RCS.
 *
 * Revision 1.1  90/10/24  18:26:11  drapeau
 * Initial revision
 *  */

#ifndef _Receiver_
#define _Receiver_

static char ReceiverHeaderRcsid[] = "$Header: /Source/Media/drapeau/NetworkProtocol/RCS/Receiver.h,v 1.17 92/05/29 12:40:37 drapeau Exp $";

#include <MAEstro.h>
#include <Sender.h>

typedef struct _Receiver
{
  Port		receivePort;
  int		receiveSocket;
  int		createErrorCode;
  SVCXPRT*	transport;
} Receiver;


Receiver*	NewReceiver(Sender* portMgrSender, char* appName, int receivingPort);
void		DestroyReceiver(Sender* portMgrSender, Receiver* receiver);
void		ReceiverListenForMessages();
int		ReceiverGetReceiverSocket(Receiver* receiver);
void		ReceiverOpenDocument(char** docName);
char**		ReceiverGetCurrentDocName(void* unusedArg);
MAESelection*	ReceiverGetSelection(void* unusedArg);
void		ReceiverSetSelection(MAESelection* selection);
void		ReceiverPerformSelection(void* unusedArg);
void		ReceiverConnectWithPortMgr(Port* app);
PortArray*	ReceiverGetOpenApps(void* unusedArg);
PortArray*	ReceiverGetPortFromName(Port* appPort);
void		ReceiverDispatchMessage(struct svc_req* requestPtr, SVCXPRT* transport);
void		ReceiverDisconnectFromPortMgr(Port* appPort);
void		ReceiverPing(void* unusedArg);
void		ReceiverHaltSelection(void* unusedArg);
void		ReceiverPauseSelection(void* unusedArg);
void		ReceiverResumeSelection(void* unusedArg);
void		ReceiverHideApplication(void* unusedArg);
void		ReceiverShowApplication(void* unusedArg);
IconData*	ReceiverGetAppIcon(void* unusedArg);
void		BuildDispatchTable(DispatchTable* table);
int		CreateSocketOnPort(int* portNumber);

extern DispatchTable ReceiverDispatchTable;

#endif
