/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
/* $Header: /Source/Media/bryant/DisplayTool/RCS/network.c,v 1.1 92/10/29 13:57:56 drapeau Exp $ */
/* $Log:	network.c,v $
 * Revision 1.1  92/10/29  13:57:56  drapeau
 * Initial revision
 *  */
static char dtNetwork[] = "$Header: /Source/Media/bryant/DisplayTool/RCS/network.c,v 1.1 92/10/29 13:57:56 drapeau Exp $";

#include "DisplayTool.h"
#include "externs.h"


void 
  OpenDoc(char **filename)
{
  char temp[MaxLength];

  if ((strcmp(*filename, currentFilename) != 0 &&		    /* Check that filename is not 'untitled' or that... */
       strstr(*filename, "untitled") == NULL &&			    /* ...it hasn't been loaded already */
       strlen(*filename) > 0) || changes)
    {
      strcpy(currentFilename, *filename);
      sprintf(temp, "DisplayTool Document :  \"%s\"", *filename);
      xv_set(baseWindow->baseWindow, XV_LABEL, temp, NULL);
      performing = 1;
      OpenHandler(*filename, 1);
      performing = 0;
      beginDoubleBuffer = 1;
    }
}

void 
  SetSelection(MAESelection *selection)
{
  PrintDTDiagnostics("\n\nEntering SetSelection.\n");
  previousSlide = selectedSlide;
  selectedSlide = selection->start;
  performing = 1;
  DisplayImages(selection->start);
  PrepareMultipleWindowsForDisplay(selectedSlide);
  performing = 0;
}

void 
  PerformSelection(void)
{
  int	i;
  
  sprintf(diagString, "PerformSelection, performing slide %d\n", selectedSlide);
  PrintDTDiagnostics(diagString);
  performing = 1;
  if (strncmp(slide[selectedSlide]->duration, "Indefinite", 10))
    notify_set_itimer_func((Notify_client)baseWindow->baseWindow, IncrementCounter, 
			   ITIMER_REAL, &timer, NULL);
  KillOldPopupsOnly();
  if (previousSlide != selectedSlide)
  {
    sprintf(diagString, "In PerformSelection, about to free memory for slide %d (current slide is %d).\n",
	    previousSlide, selectedSlide);
    PrintDTDiagnostics(diagString);
    FreeMemoryForSlide(previousSlide);
  }
  DisplayMultipleWindows(selectedSlide);
  for (i = 0; i < popupTot; i++)				    /* Copy information from newly-created Popups & Canvases */
  {
    oldPopups[i] = globalPopup[i];
    oldCanvases[i] = globalCanvas[i];
  }
  oldPopupTot = popupTot;
  performing = 0;
}								    /* end function PerformSelection */



char **
  GetDoc(void *unusedArg)
{
  if (strlen(currentFilename) == 0 || realpath(currentFilename, canonFilename) == NULL) 
    strcpy(canonFilename, "untitled");
  return (&canonFilename);
}

MAESelection *
  GetSelection(void *unusedArg)
{
  static MAESelection select;
  if (selectedSlide >= 0 && selectedSlide<MaxNumSlides)
    {
      select.offset = 0;
      sprintf(select.label, slide[selectedSlide]->label);
      select.start = selectedSlide;
      select.end = selectedSlide;
      if (strncmp(slide[selectedSlide]->duration, "Indefinite", 10))
	select.duration = 1000*atoi(slide[selectedSlide]->duration);   
      else 
	select.duration = 0;
    }
  else 
    {
      select.duration = -1;
      select.start = -1;
      select.end = -1;
      select.offset = 0;
      sprintf(select.label, "No Label");
    }
  return (&select);
}

void 
  HaltSelection(void)
{
  pauseMode = 0;
  KillPopups();
  performing = 0;
}

void 
  PauseSelection(void)
{
  pauseMode = 1;
  return;
}

void 
  ResumeSelection(void)
{
  pauseMode = 0;
  return;
}


void 
  HideApplication(void)
{
  xv_set(baseWindow->baseWindow, FRAME_CLOSED, TRUE, NULL);
  XFlush(display);
}

void 
  ShowApplication(void)
{
  xv_set(baseWindow->baseWindow, FRAME_CLOSED, FALSE, NULL); 
  XRaiseWindow(display, (Window)xv_get(baseWindow->baseWindow, XV_XID));
  XFlush(display);
}

IconData *
  GetAppIcon(void)
{
  static int first = True;
  static unsigned short baseWindow_bits[] = {
#include "DisplayTool.icon"
  };
  if (first)
    {
      iconData.iconData = (char *)malloc(sizeof(baseWindow_bits));
      bcopy(baseWindow_bits, iconData.iconData, sizeof(baseWindow_bits));
      if (iconData.iconData)
	iconData.dataLength = sizeof(baseWindow_bits);
      first = False;
    }
  return(&iconData);
}								    /* end function GetAppIcon */
