#if !defined(PICSTAT_H)
#define PICSTAT_H


#include "proto.h"


typedef struct picstat
  {
    long p_fsize;
    int  p_sizex;
    int  p_sizey;
    int  p_colrez;
    int  p_ncol;
    int  p_coltype;
    int  p_nframes;
    int  p_speed;
    char p_type[7];
    char *p_cols;
  } PICSTAT;


#define CT_BW       'B'
#define CT_COLOR    'C'
#define CT_UNKNOWN  '?'

int flistat __P((char *name, struct picstat *buf, int mode));
int gifstat __P((char *name, struct picstat *buf, int mode));
int iffstat __P((char *name, struct picstat *buf, int mode));
int jpegstat __P((char *name, struct picstat *buf, int mode));


#endif /* !defined(PICSTAT_H) */
