/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/*
 * flip.c - flip images
 *
 * Author:      Raul Rivero
 *              Mathematics Dept.
 *              University of Oviedo
 * Date:        Mon Jan 6 1992
 * Copyright (c) 1992, Raul Rivero
 *
 */

#include <lug.h>
#include <lugfnts.h>

extern int LUGverbose;

flip_image(inbitmap, outbitmap)
bitmap_hdr *inbitmap;
bitmap_hdr *outbitmap;
{
  if ( inbitmap->magic != LUGUSED )
    error( 19 );

  VPRINTF(stderr, "Flipping image\n");

  /* Fill our header */
  outbitmap->magic = LUGUSED;
  outbitmap->xsize = inbitmap->xsize;
  outbitmap->ysize = inbitmap->ysize;
  outbitmap->depth = inbitmap->depth;
  outbitmap->colors = inbitmap->colors;

  outbitmap->r = flip( inbitmap->r, outbitmap->xsize, outbitmap->ysize );
  if ( outbitmap->depth > 8 ) {
    /* 24 planes */
    outbitmap->g = flip( inbitmap->g, outbitmap->xsize, outbitmap->ysize );
    outbitmap->b = flip( inbitmap->b, outbitmap->xsize, outbitmap->ysize );
  }else outbitmap->cmap = inbitmap->cmap;
}

byte *flip(buffer, xsize, ysize)
byte *buffer;
int xsize, ysize;
{
  register int i, j;
  int twolines;
  byte *image, *ptr;

  ptr = image = (byte *) Malloc( xsize * ysize );
  twolines = 2 * xsize;
  buffer += xsize * ysize - xsize;

  for ( i = 0; i < ysize; i++) {
    for ( j = 0; j < xsize; j++ ) {
      *ptr++ = *buffer++;
    }
    buffer -= twolines;
  }

  return image;
}
