/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/*
 * 4d.c - Show bitmap on Iris 4D ( or IBM Risc 6000 ) using GL Library.
 *
 * Author:      Raul Rivero
 *              Mathematics Dept.
 *              University of Oviedo
 * Date:        Sat Jan 4 1992
 * Copyright (c) 1992, Raul Rivero
 *
 */

#include <lug.h>
#include <lugfnts.h>


/*
 * Look here !!!
 * =============
 *
 * This code is valid only if we have defined the iGL
 * macro ( read the root Makefile for more information ).
 *
 */

#ifdef iGL

#include <gl.h>
#include <gl/device.h>

/*
 * Dependence machine ( full screen ).
 */
#define XDISPLAY                1280
#define YDISPLAY                1024
#define GAMMA                   0

show_bitmap( name, image, ditherflag )
char *name;
bitmap_hdr *image;
int ditherflag;         /* only for compatibility */
{
  if ( !fork() ) {
    show_window_bitmap( name, image, ditherflag );
  }
}

show_window_bitmap( name, image, ditherflag )
char *name;
bitmap_hdr *image;
int ditherflag;         /* only for compatibility */
{
  int fildes;
  int xsize, ysize;
  int totalsize;
  int *image_block;
  byte *ptr;
  int event;
  short aux;
  int ready = 1;

  /*
   * Flip the image ( origin point in GL's lrect buffer
   * are down ).
   */
  ptr = flip( image->r, image->xsize, image->ysize );
  free( image->r );
  image->r = ptr;
  ptr = flip( image->g, image->xsize, image->ysize );
  free( image->g );
  image->g = ptr;
  ptr = flip( image->b, image->xsize, image->ysize );
  free( image->b );
  image->b = ptr;

  /*
   * More easy use ...
   */
  xsize = image->xsize;
  ysize = image->ysize;
  totalsize = xsize * ysize;

  /*
   * Allocate space for lrect buffer and create it.
   */
  image_block = (int *) Malloc( totalsize * sizeof(int) );
  compress_data( image->r, image->g, image->b, image_block, totalsize );

  freebitmap( image );

  /*
   * Create the window and set enviroment parameters.
   */
  prefsize( xsize, ysize );
  /* We use a fork so ... ( in background ! ) */
#ifndef AIX
  foreground();
#endif
  fildes = winopen( name );
  wintitle( name );
  icontitle( name );
  maxsize( xsize, ysize );
  winconstraints();
  RGBmode();
  gconfig();

  /*
   * Write the image.
   */
  lrectwrite( 0, 0, xsize-1, ysize-1, image_block );

  /*
   * We active four events:
   *    Redraw       :  ( you get it ? )
   *    Mouse Right  :  exit  ( also with ESC key )
   */
  qdevice( REDRAW );
  qdevice( RIGHTMOUSE );
  qdevice( WINQUIT );
  qdevice( ESCKEY );
  unqdevice( INPUTCHANGE );

  while ( 1 ) {
    event = qread( &aux );
    if ( ready ) {
      switch ( event ) {
        case ESCKEY:
        case RIGHTMOUSE :               /* EXIT */
                gexit();
                free( image_block );
                exit( 0 );
                break;

        case REDRAW :                   /* REDRAW */
                winset( fildes );
                reshapeviewport();
                lrectwrite( 0, 0, xsize-1, ysize-1, image_block );
                break;
      } /* switch */
    } /* if */
  } /* while */
}

compress_data( r, g, b, out, size )
byte *r, *g, *b;
int *out;
int size;
{
  byte *end;

  end = r + size;
  while ( r < end ) {
    *out++ = ( (GAMMA << 24) | (*b << 16) | (*g << 8) | (*r) );
    r++, g++, b++;
  }
}


#endif  /* iGL */
