#!/usr/bin/perl -w
#
# CVS Logging script
# Copyright (C) 2000 by J.E. Hoffmann <je-h@gmx.net>
# All rights reserved.
#
# This program is  free  software;  you can redistribute it and/or modify it
# under the terms of the GNU  General  Public  License  as  published by the
# Free  Software  Foundation;  either version 2 of the License,  or (at your
# option) any later version.
#
# This  program  is  distributed in  the  hope that it will  be useful,  but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  General  Public  License
# for more details.
#
# You should have received a copy of the GNU  General  Public  License along
# with this program;  if not, write to the  Free Software Foundation,  Inc.,
# 675 Mass Ave, Cambridge, MA 02139, USA.
#
# $Id: cvslog.pl,v 1.2 2000/10/19 18:22:20 jeh Exp $
#

use File::Basename;

$mailer = '/usr/lib/sendmail';
$cvsweb = "http://cvs.sourceforge.net/cgi-bin/cvsweb.cgi";

sub changelogDiff {
    my @old=split("\n", $_[0]);
    my @new=split("\n", $_[1]);
    my $line;

    while (@new && @old) {
	$line=pop(@new);
	if (!($line eq pop(@old))) {
	    push(@new,$line);
	    last;
	}
    }
    while (@new) {
	$line=pop(@new);
	if ($line !~ /^\s*$/) {
	    push(@new,$line);
	    last;
	}
    }
    return(join("\n",@new));
}

sub changelogCvs {
    my $repository=$_[0];
    my $revold=$_[1];
    my $revnew=$_[2];
    my $old="";
    my $new="";
    
    if ($revnew eq 'NONE') {
	return("");
    }
    $new=`cvs -Q checkout -p -r $revnew $repository/ChangeLog`;
    if (!($revold eq 'NONE')) {
	$old=`cvs -Q checkout -p -r $revold $repository/ChangeLog`;
    }
    return(changelogDiff($old,$new));
}

sub logMessage {
    my @message;
    my $line;

    @message=();
    while ($line=<STDIN>) {
	last if ($line =~ /^Log Message:/);
    }
    while ($line=<STDIN>) {
	chomp($line);
	push(@message, $line);
    }
    while (@message) {
	$line=pop(@message);
	if ($line !~ /^\s*$/) {
	    push(@message, $line);
	    last;
	}
    }
    return(@message);
}


if ($#ARGV!=2) {
    die "***ERROR*** Syntax: cvslog.pl cvsdir email-address loginfo-%{sVv}}";
}
$cvsdir=$ARGV[0];
$recipient=$ARGV[1];
$files=$ARGV[2];
$files =~ s/\s-\s//;
$files =~ s/New directory//;
@files=split(' ', $files);
$module=shift(@files);
$module =~ /([^\/]+)/;
$repository=$1;
$cvsaddr= "&cvsroot=$cvsdir";

@message=logMessage();
@changelog=();
foreach $item (@files) {
    ($file, $revold, $revnew) = split(',', $item);
    if ($file eq 'ChangeLog') {
	@changelog=split('\n',changelogCvs($repository, $revold, $revnew));
    }
}

open(MAIL, "|$mailer $recipient") or die "Cannot open $mailer: $! ";
print MAIL "From: noreply\@sourceforge.net\n";
print MAIL "To: $recipient\n";
print MAIL "Subject: CVS commit: $module\n";
print MAIL "Content-Type: text/html;\n";
print MAIL "<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">\n";
print MAIL "<body>\n";
print MAIL "<html>\n";

if ($#message>=0) {
    print MAIL "<h2>Log Message:</h2><dl>\n";
    foreach (@message) {
	print MAIL "<dd>$_\n";
    }
    print MAIL "</dl>\n";
}

if ($#changelog>=0) {
    my $start=1;
    print MAIL "<h2>ChangeLog:</h2><dl><pre>\n";
    foreach (@changelog) {
	s/</&lt;/;
	s/>/&gt;/;
	s/&lt;([^@^>]*@[^@^>]*)&gt;/&lt;<a href="mailto:$1">$1<\/a>&gt;/;
	if (/^\d+\-\d+\-\d+/) {
	    print MAIL "<b>$_</b>\n";
	}
	else {
	    print MAIL "$_\n";
	}
    }
    print MAIL "</pre></dl>\n";
}

print MAIL "<h2>Modified Files:</h2><dl><dd><table>\n";
foreach $item (@files) {
    my ($file, $revold, $revnew) = split(',', $item);
    print MAIL "<tr>\n";
    print MAIL "<td>$file</td>\n";
    if ($revnew eq 'NONE') {
	print MAIL "<td>$revnew</td>\n";
    }
    else {
	print MAIL "<td>\n";
	print MAIL "[<a href=\"$cvsweb/$module/$file?rev=$revnew&content-type=text/x-cvsweb-markup$cvsaddr\">$revnew</a>]\n";
	print MAIL "</td>\n";
    }
    if ($revold eq 'NONE') {
	print MAIL "<td>$revold</td>\n";
    }
    else {
	print MAIL "<td>\n";
	print MAIL "[<a href=\"$cvsweb/$module/$file?rev=$revold&content-type=text/x-cvsweb-markup$cvsaddr\">$revold</a>]\n";
	print MAIL "</td>\n";
    }
    if (($revnew eq 'NONE') || ($revold eq 'NONE')) {
	print MAIL "<td>&nbsp;</td>\n";
    }
    else {
	print MAIL "<td>\n";
	print MAIL "[<a href=\"$cvsweb/$module/$file?r1=$revold&r2=$revnew$cvsaddr\">diff</a>]\n";
	print MAIL "</td>\n";
    }
    print MAIL "</tr>\n";
} 
print MAIL "</table><dl>\n";
print MAIL "</body>\n";
print MAIL "</html>\n";
close MAIL;




