#include <stdio.h>
#include <ctype.h>
#include <varargs.h>

/* Convert string s to upper case in place */
to_upper(s)
register char *s;
{
    while (*s) {
	if (islower(*s))
	    *s = toupper(*s);
	s++;
    }
}

/* Convert string s to lower case in place */
to_lower(s)
register char *s;
{
    while (*s) {
	if (isupper(*s))
	    *s = tolower(*s);
	s++;
    }
}

/*
    Print a usage line followed by a block of text, then exit with
	error status.
*/
userhelp(progname,usage,example)
char *progname, *usage;
char **example;
{
    fprintf(stderr,usage,progname);
    while (*example)
	fprintf(stderr,*example++);

    exit(-1);
}

#if 0
/* BSD stuff not in Sys V */

bcopy(from,to,length)
register char *from, *to;
register int length;
{
    while (length-- > 0)
	*to++ = *from++;
}

#endif

/* Printf to standard error */
/* VARARGS */
gr_error(va_alist)
va_dcl
{
    va_list args;
    char *fmt;

    va_start(args);
	fmt = va_arg(args, char *);
	vfprintf(stderr, fmt, args);
    va_end(args);
}

/* Printf to standard error, then exit with error status */
gr_bomb(va_alist)
va_dcl
{
    va_list args;
    char *fmt;

    va_start(args);
	fmt = va_arg(args, char *);
	vfprintf(stderr, fmt, args);
    va_end(args);
    exit(-1);
}

/* Printf to standard error, then close rastertech and exit with error status */
rt_bomb(va_alist)
va_dcl
{
    va_list args;
    char *fmt;

    /*wrmask(0xFF,0x1F);*/
    /*quit();*/

    va_start(args);
	fmt = va_arg(args, char *);
	vfprintf(stderr, fmt, args);
    va_end(args);

    exit (-1);
}
