#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "pixlib.h"

LFF_HDR Imagehdr;

char Usage[] = "%s [--] input-file output-file\n";
char *Example[] = {
    "\tdetile converts a tiled lucasfilm file to a nontiled version.\n",
    "\n\tExample: detile tiled.lff untiled.lff\n",
    NullPtr(char)
};

main (argc, argv)
int	argc;
char   *argv[];
{
    int  i, mode, getpixfun(), status;
    char *lffname = NULL, *outname = NULL;
    RGBPIXEL *image;

    for (i = 1; i < argc; i++) {
	if (!strcmp(argv[i],"--"))
	    userhelp(argv[0],Usage,Example);
	else {
	    if (lffname == NULL)
		lffname = argv[i];
	    else if (outname == NULL)
		outname = argv[i];
	    else
		userhelp(argv[0],Usage,Example);
	}
    }

    status = open_lff(lffname,&Imagehdr);
    if (status != LFF_OK)
	gr_bomb("Can't open %s, open_lff returns: %s\n",lffname,pixerrmess(status));

    /* Allocate memory for the image in core */
    i = Imagehdr.hdr_height * Imagehdr.hdr_width * sizeof(RGBPIXEL);
    image = (RGBPIXEL *)malloc(i);
    if (image == (RGBPIXEL *)NULL)
	gr_bomb("Failed to allocate %d bytes for incore buffer\n",i);

    /* Scan each tile in order and save in the incore buffer */
    {
	int i, j, vtiles,htiles;

	vtiles = Imagehdr.hdr_height / Imagehdr.hdr_tileheight;
	htiles = Imagehdr.hdr_width / Imagehdr.hdr_tilewidth;
	for (i = 0; i < vtiles; i++) {
	    int yoff = i * Imagehdr.hdr_tileheight;

	    for (j = 0; j < htiles; j++) {
		int y, xoff = j * Imagehdr.hdr_tilewidth;

		if (lff_seek_tile(i,j) != LFF_OK)
		    gr_bomb("Error reading tile %d, row %d, column %d\n",
			i*htiles+j,i,j);
		for (y = yoff; y < yoff+Imagehdr.hdr_tileheight; y++) {
		    int newy;
		    RGBPIXEL *ptr = &image[Imagehdr.hdr_width * y + xoff];

		    status = lff_read_line(ptr,&newy);
		    if (status != LFF_OK)
			gr_bomb("lff_read_line(y=%d) returns: %s\n",
			    newy,pixerrmess(status));
		}
	    }
	}
    }

    /* Now write the image out to the new file */

    /*
	Verify the .lff file does not exist
    */
    {
	struct stat buf;
	if (stat(outname,&buf) == 0)
	    gr_bomb("Output file %s already exists\n",outname);
    }

    pixinit(image,Imagehdr.hdr_height,Imagehdr.hdr_width);
    status = write_lff(
	outname,
	Imagehdr.hdr_height,
	Imagehdr.hdr_width,
	1,1,
	Imagehdr.hdr_format,
	STORAGE_DUMP,		/* Change later to reflect switch specified */
	0,0,
	LFF_VERSION,
	0,
	getpixfun);
    if (status != LFF_OK)
	gr_bomb("Error writing output file %s: %s\n",outname,pixerrmess(status));
}

static RGBPIXEL *Image;
static int Height, Width;

pixinit(image,height,width)
RGBPIXEL *image;
int height, width;
{
    Image = image;
    Height = height;
    Width = width;
}

/*
    Function called by write_lff, which returns the next line from the
	.pix file. This version for tiled pictures.
*/
int getpixfun(row,col,length,pixels)
int row, col, length;
RGBPIXEL pixels[];
{
    RGBPIXEL *pixsrc;

    pixsrc = &Image[row * Width + col];

    bcopy( (char *)pixsrc,(char *)pixels,length * sizeof(RGBPIXEL) );
    return length;
}

