/*% cc -O -o rle rle.c
*/
#include <stdio.h>
#include <ctype.h>
#include "pixlib.h"

#define LINELEN 512
RGBPIXEL line[LINELEN];
int run[LINELEN][2];

main()
{
    char buf[120];
    int lptr = 0, length, runs;

    while (fgets(buf,120,stdin)) {
	if (*buf == 'e') {
	    int i;

	    length = rle_encode(line,NULL,LINELEN,&runs);
	    printf("%d runs\n",runs);
	    for (i = 0; i < runs; i++)
		printf("    [cnt = %3d, value = %4d]\n",run[i][0],run[i][1]);
	} else if (*buf == 'd') {
	    int i;

	    for (i = 0; i < LINELEN; i++) {
		if (i % 16 == 0)
		    printf("\n%4d:\t",i);
		printf("%4d",line[i]);
	    }
	    putchar('\n');
	} else {
	    int i, i1, i2, i3;
	    int cnt = sscanf(buf,"%d %d %d",&i1,&i2,&i3);

	    if (cnt == 2) { /* Encode [cnt,value] from lptr */
		for (i = 0; i < i1 && lptr + i < LINELEN; i++)
		    line[lptr + i] = i2;
		lptr += i1;
	    } else if (cnt == 3) {
		lptr = i1;
		for (i = 0; i < i2 && lptr + i < LINELEN; i++)
		    line[lptr + i] = i3;
	    } else
		printf("Either d, e, cnt value, or pos cnt value\n");
	}
    }
}

int rle_encode(buffer,encoded,length,runs)
RGBPIXEL *buffer;
RPIXEL *encoded;
int length, *runs;
{
    RPIXEL count,	    /* Run-length count */
	   *bufptr;	    /* Run count & pointer into encoded line */
    RGBPIXEL lastpixel;     /* Last pixel read */
    int i;		    /* Index into buffer[] */

    lastpixel = *buffer++;  /* Set up for encoding - first pixel */
    *runs = 0;		    /* No runs so far */
    count = 0;		    /* 1 pixel in first run */
    /* bufptr = encoded;       /* Start encoding at beginning of buffer */

    printf("encode: length = %d, buffer[0] = %d\n",length,lastpixel);

    for (i = 1; i < length; i++,buffer++) {
	/* If the pixel value changes, or 256 pixels have been
	    encoded, place a count-value run in the buffer
	*/
	if (*buffer != lastpixel) {
	    printf("encoding a run with count = %d, value = %d\n",
		count,lastpixel);
	    run[*runs][0] = count;
	    run[*runs][1] = lastpixel;
	    /*
	    bufptr = do_run(bufptr,count,lastpixel);
	    */
	    count = 0;
	    (*runs)++;
	    lastpixel = *buffer;

	    printf("    count = 0, runs = %d, lastpixel = %d\n",
		count,*runs,lastpixel);
	} else
	    count++;

	if (count == 255 || i == length - 1) {
	    printf("encoding an overrun with i = %d, count = %d, value = %d\n",
		i,count,lastpixel);
	    run[*runs][0] = count;
	    run[*runs][1] = lastpixel;

	    /*
	    bufptr = do_run(bufptr,count,lastpixel);
	    */
	    (*runs)++;
	    lastpixel = *++buffer;
	    i++;
	    count = 0;
	    printf("    count = 0, runs = %d, lastpixel = %d, i = %d\n",
		count,*runs,lastpixel,i);
	}
    }

    /* If the loop exits with i == length, there was a max length +  1
	(257) pixels run at the end of	the  line,  requiring  another
	packet.
    */
    if (i == length) {
	printf("encoding the final run with i = %d, count = %d, value = %d\n",
	    i,count,lastpixel);
	run[*runs][0] = count;
	run[*runs][1] = lastpixel;
	/*
	bufptr = do_run(bufptr,count,lastpixel);
	*/
	(*runs)++;
	printf("    runs = %d\n",*runs);
    }

    return 0;
}
