.fp 1 R
.fp 2 I
.fp 3 B
.so date.trf
.TH LFFXFORM 1L "\*(td" "Caltech CS Graphics Group" "Graphics Group Programmer's Manual"
.SH NAME
lffxform - transform lucasfilm format images
.SH SYNOPSIS
.B lffxform
source-file destination-file [options]
.SH DESCRIPTION
.I Lffxform
transforms an input lucasfilm file to an output file, performing
conversions as specified below. If a particular conversion is not specfied,
that aspect of the output file is retained from the input. If no conversions
are specified, \fIlffxform\fR amounts to a \fBvery\fR slow version of \fBcp(1)\fR.
Conversions which may be specified are:
.TP
.B \-rle
The output file will be run-length encoded, making a (probably) smaller
image file at the penalty of decreased speed of reading the image.
.TP
.B \-dump
The output file will be dumped, making a (probably) larger image file
which can be read faster.
.TP
.BI \-tiles " vtiles htiles"
The output file will be broken into the specified number of subtiles (both
vtiles and htiles must be greater than 0, and must currently go evenly
into the picture size).
.TP
.BI \-title " title string"
The specified string will be placed in the title (comment) field of the
output image header.
.TP
.BI \-xoff " x offset"
The specified x offset of the image will be placed in the output image header.
.TP
.BI \-yoff " y offset"
The specified y offset of the image will be placed in the output image header.
.TP
.BI \-vers " version number"
The specified version number will be placed in the output image header.
.TP
.BI \-alpha " alpha mode"
The specified alpha mode (0 = matted-to-black, 1 = unassociated) will
be placed in the output image header.
.TP
.B \-force
The output file will be overwritten if it exists. Normally, if the specified
output file already exists, \fIlffxform\fR will refuse to overwrite it and fail.
.PP
.SH AUTHOR
Jonathan Leech (jon@cit-vax)
.SH DIAGNOSTICS
Reasonably self explanatory. Most refer to a badly formatted input
lucasfilm file, or incorrectly specified conversion parameters.
.SH SEE ALSO
lffhdr(1L), lffdl(1L), pixerrmess(3L)
.br
Technical Memo #46, ``\fBThe Format of Stored Pictures\fR'', by Thomas Porter,
Computer Division, Lucasfilm, Ltd.
