#ifndef FALSE
#define FALSE 0
#define TRUE  1
#endif

#ifdef uts /* No bsd types.h */
#ifndef CITTYPES
typedef unsigned char u_char;
typedef unsigned short u_short;
#define CITTYPES
#endif
#endif

char cin();

#define COLD_DELAY 6	/* Delay time after cold start, in seconds */

extern int Macro_level, /* Current nesting level of output macros */
	   Read_func,	/* Current read function */
	   Graphics_mode,
	   In_graphics; /* Flag if raster is in graphics mode */

extern char *Rtbufptr; /* Pointer into write buffer */
extern int  Rtbytecnt; /* Byte count of buffer so far */
extern int  Buf_size;

#define mysend1(byte) (*Rtbufptr++ = byte,++Rtbytecnt >= Buf_size?emptyb():0)
#define mysend2(word) (mysend1(word>>8),mysend1(word))

/* Modes of output to the device */
#define RTMODE_DMA    0
#define RTMODE_BINARY 1
#define RTMODE_HEX    2

/* Modes of pixel processor */
#define PIXFUN_INS	0   /* Insert new image data */
#define PIXFUN_SUBI	1   /* Subtract image from new */
#define PIXFUN_SUBN	2   /* Subtract new from image */
#define PIXFUN_ADD	3   /* Add new to image */
#define PIXFUN_XOR	4   /* XOR image & new */
#define PIXFUN_OR	5   /* OR image & new */
#define PIXFUN_AND	6   /* AND image & new */
#define PIXFUN_PRESET	7   /* Write all ones into image memory */
#define PIXFUN_COND	8   /* Inhibit writing all pixels with val 0,0,0 */

/* Modes of depth buffer */
#define ZFUN_NOP	0   /* Draw without any comparison */
#define ZFUN_GT 	1   /* Draw pixels with depth > screen */
#define ZFUN_LT 	2   /* Draw pixels with depth < screen */
#define ZFUN_EQ 	3   /* depth = screen */
#define ZFUN_GE 	4   /* depth >= screen */
#define ZFUN_LE 	5   /* depth <= screen */
#define ZFUN_NE 	6   /* depth != screen */
#define ZFUN_EQWIDE	7   /* depth ~= screen (within ZRANGE tolerance) */
#define ZFUN_NEWIDE	8   /* depth !~= screen (within ZRANGE tolerance) */

/* Error codes, see 'Model One/25 Programming Guide', page 79 */
#define RT_ANGLE	1	/* Illegal angle */
#define RT_VREG 	2	/* Illegal value register */
#define RT_RADIUS	3	/* Illegal radius */
#define RT_FLAG 	4	/* Illegal flag */
#define RT_BUTIDX	5	/* Illegal button table index */
#define RT_MACNUM	6	/* Illegal macro number */
#define RT_CREG 	7	/* Illegal coordinate register */
#define RT_COORD	8	/* Illegal coordinate */
#define RT_DISP 	9	/* Illegal displacement */
#define RT_EINVAL	10	/* Illegal value */
#define RT_LUTIDX	11	/* Illegal look-up-table index */
#define RT_LUTVAL	12	/* Illegal look-up-table entry value */
#define RT_FUNC 	13	/* Illegal function */
#define RT_MASK 	14	/* Illegal mask */
#define RT_STRINGLEN	15	/* Illegal string length */
#define RT_SCALE	16	/* Illegal scale */
#define RT_IXHAIR	17	/* Illegal crosshair number */
#define RT_IZOOM	18	/* Illegal scale (zoom) factor */
#define RT_NPOLY	19	/* Illegal number of polygons */
#define RT_IPIXFUN	20	/* Illegal pixel function */
#define RT_LUTROUTE	21	/* Illegal LUT routing */
#define RT_LUTNUM	22	/* Illegal LUT number */
#define RT_FRAMERATE	23	/* Illegal frame rate */
#define RT_LIGHTNUM	24	/* Illegal light number */
#define RT_FONT 	25	/* Illegal font */
#define RT_ARYDIM	26	/* Illegal array dimension */
#define RT_PAR_RANGE	27	/* Illegal parameter range */
#define RT_IOERR	28	/* I/O error */
#define RT_COUNT	29	/* Illegal count parameter */
#define RT_RLEN 	30	/* Run-lengths and window size disagree */

#define RT_SERIAL   0x1 	/* Mode bit if on a serial line */
#define RT_UNBUF    0x2 	/* Mode bit if unbuffered output */

#define RT_ACK	    0x06	/* Acknowledge for readback */
#define RT_NACK     0x15	/* Negative ACK for readback */

#define RTBUFLEN    256 	/* Length of default DMA buffer */

/* Predefined constants giving binary command values */
#define RT_ALPHAO   0xB4
#define RT_ARC	    0x11
#define RT_AREA1    0x13
#define RT_AREA2    0x14
#define RT_ASCII    0x9B
#define RT_BLANK    0x31
#define RT_BLINKC   0x23
#define RT_BLINKD   0x21
#define RT_BLINKE   0x20
#define RT_BLINKR   0x22
#define RT_BUTTBL   0xAA
#define RT_BUTTON   0xAB
#define RT_CADD     0xA2
#define RT_CIRCI    0x10
#define RT_CIRCLE   0x0E
#define RT_CIRCXY   0x0F
#define RT_CLEAR    0x87
#define RT_CLOAD    0xA0
#define RT_CMOVE    0xA1
#define RT_COLD     0xFD
#define RT_CORORG   0x37
#define RT_CSUB     0xA3
#define RT_DEBUG    0xA8
#define RT_DELAY    0xB6
#define RT_DFTCFG   (-1)
#define RT_DISCFG   (-1)
#define RT_DNLOAD   0xFB
#define RT_DRW2R    0x84
#define RT_DRW3R    0x83
#define RT_DRWABS   0x81
#define RT_DRWI     0x85
#define RT_DRWREL   0x82
#define RT_FILMSK   0x9F
#define RT_FIRSTP   0x2F
#define RT_FLOOD    0x07
#define RT_FLUSH    0x15
#define RT_GENLOCK  0x4C
#define RT_HOSTO    0xB5
#define RT_LUT8     0x1C
#define RT_LUTA     0x1B
#define RT_LUTB     0x1A
#define RT_LUTG     0x19
#define RT_LUTR     0x18
#define RT_LUTRMP   0x1D
#define RT_LUTRTE   0x1E
#define RT_MACDEF   0x8B
#define RT_MACEND   0x0C
#define RT_MACERA   0x8C
#define RT_MACRO    0x0B
#define RT_MODDIS   0x2C
#define RT_MODE1K   0x2D
#define RT_MOV2R    0x04
#define RT_MOV3R    0x03
#define RT_MOVABS   0x01
#define RT_MOVI     0x05
#define RT_MOVREL   0x02
#define RT_NULL     0x0     /* Also 0x0A, 0x0D, 0x80, 0x8A, 0x8D */
#define RT_OVRRD    0xBA
#define RT_OVRVAL   0xB9
#define RT_OVRZM    0xB8
#define RT_PEEK     0xBD
#define RT_PIXCLP   0x3C
#define RT_PIXEL8   0x29
#define RT_PIXELS   0x28
#define RT_PIXFUN   0x3B
#define RT_PIXMOV   0xBB
#define RT_PMCTL    0xBF
#define RT_POINT    0x88
#define RT_POKE     0xBE
#define RT_POLYGN   0x12
#define RT_PRMFIL   0x1F
#define RT_QUIT     0xFF
#define RT_RDKEYB   0xED
#define RT_RDMASK   0x9E
#define RT_RDMODE   0xD3
#define RT_RDPIXR   0xAF
#define RT_READBU   0x9A
#define RT_READCR   0x98
#define RT_READER   0x38
#define RT_READF    0x27
#define RT_READP    0x95
#define RT_READVR   0x99
#define RT_READW    0x96
#define RT_READWE   0x97
#define RT_RECREL   0x89
#define RT_RECTAN   0x8E
#define RT_RECTI    0x8F
#define RT_REPLAY   0xBC
#define RT_RUNLEN   0x2A
#define RT_RUNLN8   0x2B
#define RT_SCRORG   0x36
#define RT_SPCHAR   0xB2
#define RT_TEKEM    0x39
#define RT_TEXT1    0x90
#define RT_TEXT2    0x91
#define RT_TEXTC    0x92
#define RT_TEXTDN   0x26
#define RT_TEXTRE   0xB1
#define RT_VADD     0xA6
#define RT_VAL1K    0xB0
#define RT_VAL8     0x86
#define RT_VALUE    0x06
#define RT_VECPAT   0x2E
#define RT_VGWAIT   0x30
#define RT_VLOAD    0xA4
#define RT_VMOVE    0xA5
#define RT_VSUB     0xA7
#define RT_VTEXT1   0x93
#define RT_VTEXT2   0x94
#define RT_WAIT     0x3D
#define RT_WARM     0xFE
#define RT_WINDOW   0x3A
#define RT_WRMASK   0x9D
#define RT_XHAIR    0x9C
#define RT_ZOOM     0x34
#define RT_ZOOMIN   0x35

/* Depth buffer raster commands */
#define RT_SETALIAS 0xD4
#define RT_SETWIDTH 0xD5
#define RT_SHMODE   0x56
#define RT_ZCLEAR   0x50
#define RT_ZCLIP    0x57
#define RT_ZFUNCT   0x53
#define RT_ZGRID    0x55
#define RT_ZPATCH   0x52
#define RT_ZRANGE   0x54

/* Other raster commands */
#define RT_ENTERGRAPHICS 0x04
#define RT_LEAVEGRAPHICS 0xFF
