/*******************************************************************************
+
+  LEDA  3.0
+
+
+  set.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_SET_H
#define LEDA_SET_H

//------------------------------------------------------------------------------
// set             
//------------------------------------------------------------------------------

#include <LEDA/basic.h>
#include <LEDA/impl/rs_tree.h>


template<class type>

class _CLASSTYPE set : public rs_tree {

rst_item iterator;

int  int_type()              const { return INT_TYPE(type); }
int  cmp(GenPtr x, GenPtr y) const
                           { return compare(ACCESS(type,x),ACCESS(type,y)); }
void clear_key(GenPtr& x)   const { Clear(ACCESS(type,x));   }
void copy_key(GenPtr& x)    const { x = Copy(ACCESS(type,x));}

public:
virtual void insert(type y)       { rs_tree::insert(Convert(y),0); }
virtual void del(type y)          { rs_tree::del(Convert(y)); }
virtual bool member(type y) const { return (rs_tree::lookup(Convert(y))!=nil); }
virtual type choose()       const { return ACCESS(type,rs_tree::key(rs_tree::min())); }

virtual void init_iterator()      { iterator = rs_tree::first_item(); }

virtual bool next_element(type& y) 
{ if (iterator==0) return false;
  else { y = ACCESS(type,rs_tree::key(iterator));
         iterator=rs_tree::next_item(iterator);
         return true; } 
 }

 set& operator=(const set& S) { rs_tree::operator=(S); return *this; }

 set() {}
 set(const set& S) : rs_tree(S) {}

~set() { clear(); }
} ;

#endif

