/*******************************************************************************
+
+  LEDA  3.0
+
+
+  node_matrix.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_NODE_MATRIX_H
#define LEDA_NODE_MATRIX_H

#include <LEDA/graph.h>

//------------------------------------------------------------------------------
// node matrices
//------------------------------------------------------------------------------

typedef graph_array(node)* node_array_ptr;


class Node_Matrix {
graph* g;
node_array<node_array_ptr> M;
virtual void init_entry(GenPtr&)  { }
virtual void copy_entry(GenPtr&)  const { }
virtual void clear_entry(GenPtr&) const { }
virtual void print_entry(GenPtr&) const { }
public:
 graph_array(node)& row(node v);
 GenPtr& entry(node, node);
 GenPtr  inf(node, node) const;
 void clear();
 void init(const graph&, int, GenPtr);
 void init(const graph&, GenPtr);
 void init(const graph&);
 void init(const Node_Matrix&);
 Node_Matrix()  {}
virtual ~Node_Matrix()  { clear(); }
};




template<class type>

class _CLASSTYPE node_matrix: public Node_Matrix {

type X;

void copy_entry(GenPtr& x) const { x=Copy(ACCESS(type,x)); }
void clear_entry(GenPtr& x)const { Clear(ACCESS(type,x));  }
void init_entry(GenPtr& x)       { Init(X); x = Copy(X);   }
void print_entry(GenPtr& x)const { Print(ACCESS(type,x),cout); }
public:
node_array<type>& operator[](node v)
{ return *(node_array<type>*)&row(v); }

type& operator()(node v, node w) { return ACCESS(type,entry(v,w));}
/*
type  operator()(node v, node w) const { return type(Node_Matrix::inf(v,w)); }
*/
void  init(const graph& G, int n, type i) { Node_Matrix::init(G,n,Convert(i)); }
void  init(const graph& G, type i)     { Node_Matrix::init(G,Convert(i)); }
void  init(const graph& G)             { Node_Matrix::init(G); }
void  init(const node_matrix& M)       { Node_Matrix::init(M); }

node_matrix() {}
node_matrix(const graph& G)                 { init(G);   }
node_matrix(const graph& G, int n, type x)  { init(G,n,x); }
node_matrix(const graph& G, type x)         { init(G,x); }

node_matrix(const node_matrix& M)           { init(M); }

node_matrix& operator=(const node_matrix& M){ init(M); return *this;}

~node_matrix()                 { clear();   }
};


#endif
