/*******************************************************************************
+
+  LEDA  3.0
+
+
+  b_stack.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_BSTACK_H
#define LEDA_BSTACK_H

//------------------------------------------------------------------------------
// bounded stacks 
//------------------------------------------------------------------------------

#include <LEDA/basic.h>



template<class type> 

class _CLASSTYPE b_stack
{
	type* v;
	int sz;	
        int t;
public:

b_stack(int n)
{ if (n<1) error_handler(99,"b_stack: bad size");
  sz = n;
  t = -1;
  v = new type[sz];
  if (v==0) error_handler(99,"b_stack: out of memory");
 }

virtual ~b_stack() { delete v; }

int   size()  const { return t+1; }
int   empty() const { return (t<0) ? true : false; }

void push(type& a)
{ t++;
  if (t==sz) error_handler(99,"b_stack overflow");
  v[t] = a;
}

type pop()
{ if (t<0) error_handler(99,"b_stack underflow");
  return v[t--];
}

type top() const 
{ if (t<0) error_handler(99,"b_stack empty");
  return v[t];
}

void clear() { t = -1; }
};

#endif
