/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */
#include "unmcopyright.h"
#include "xvinclude.h"
#include "xvforms.h"
#include "form_info.h"
/*
 * Advice for the user of this code:
 *
 * Note global declaration of 'display'! You may want to
 * to move this elsewhere... perhaps into a .h file...
 *
 * Also Note:  this driver for the forms is for use 
 * with the code generated by 'ghostwriter'. The main
 * program generated by 'ghostwriter' has global declarations
 * for 'av', 'ac', and 'program', which will be necessary
 * in order to compile your program.
 *
 * If you are not using a main() generated by 'ghostwriter',
 * you will have to make these changes for this code to work:
 *
 *   1)  Change the name of the following routine to 'main(argc, argv)'.
 *   2)  Globally declare the following:
 *       char  **av,
 *             *program,
 *             *calloc(); 
 *       int   ac; 
 *
 *   3) At the beginning of the main, set:
 *       program = VStrcpy(argv[0]);
 *       ac = argc;  av = argv; 
 *
 * If you are using a main() generated by 'ghostwriter',
 * you should include a call to 'run_Master' there.
 * Don't forget to delete 'program' out of the parameter list!
 * 
 * Finally, you should IMMEDIATELY re-name this file
 * so that you will not accidentally over-write it
 * after you have modified it to your satisfaction!
 * 
 * p.s. You should probably delete this long comment 
 *      after reading/understanding it, too!
 *
 */


Display *display;

/********************************************************
*
*  Routine Name:  run_Master
*       Purpose:  drives the master form
*         Input:  argc - number of arguments on command line
*		  argv  - arguments from command line
*        Output:  action of the application program
*     Called By:  the main application program
*   Automatically Generated By:  conductor -i example.form -l 1 -b
*
********************************************************/


run_Master(argc, argv, program)
int 	argc;
char	*argv[];
char	*program;
{
	xvf_form  *form;
	Master Master_info;
	char *form_filestring;
	char *form_pathname;

	/*
	 * initialize the display & the forms - 
	 * NOTE: assuming a global 'Display *display'
	 */
	display = xvf_initialize(ac, av, program);
	if (display == NULL)
	{
	     fprintf(stderr, "Could not open connection to server");
	     exit(0);
	}

	/*
	 * Substitute below the correct filename and directory path
	 * of the User Interface Description file to be used
	 */
	form_filestring = xvf_strcpy("your_filename.form");
	form_pathname   = xvf_strcpy("your_filename_directory");
	form_filestring = vfullpath(form_filestring, form_pathname, NULL);

	/*
	 * Create the forms 
	 */
	if (!(form = xvf_create_form(form_filestring, av, ac, SIMPLE, NULL,
				     -1, -1)))
	   exit(0);

	/*
	 * Initialize the auto-generated information structure
	 */
	_xvf_init_Master(form,  &Master_info);

	/*
	 * Map the forms
	 */
	xvf_change_active(form, true);

	do
	{
	     /*
	      * run the forms
	      */
	     form = xvf_run_form();
	     if (form == NULL) break;

	     /*
	      * get information from the master
	      */
	     _xvf_get_Master(form, &Master_info);

	     /*
	      * user clicked on master  action button 'master_action'
	      */
	     if (Master_info.master_action)
	     {
		/* PUT YOUR CODE HERE ! */
	     }

	     /*
	      * action came from the 'Subform1' subform
	      */
	     else if (Master_info.Subform1_selected)
	     {
		  run_Subform1(form, Master_info.Subform1);
	     }

	     /*
	      * action came from the 'Subform2' subform
	      */
	     else if (Master_info.Subform2_selected)
	     {
		  run_Subform2(form, Master_info.Subform2);
	     }


	xvf_clear_selections(form->db, form->line_num);
	} while (!Master_info.quit);    /* end user interface loop */

}    /* end run_Master */



/********************************************************
*
*  Routine Name:  run_Subform1
*
*       Purpose:  drives the subform 'Subform1'
*
*         Input:  form - pointer to the form tree 
*		  Subform1_info  - information structure for subform 'Subform1'
*        Output:  action of the application program
*
*     Called By:  run_Master()
*
*   Automatically Generated By:  conductor -i example.form -l 1 -b
*
********************************************************/


run_Subform1(form, Subform1_info)

xvf_form *form;
Master_Subform1 *Subform1_info;
{

	/*
	 * user clicked on subform action button 'operation'
	 */
	if (Subform1_info->operation)
	{
		/* PUT YOUR CODE HERE ! */
	}

	/*
	 * action came from the 'input' pane
	 */
	else if (Subform1_info->input_selected)
	    run_input(form, Subform1_info->input);

	/*
	 * action came from the 'output' pane
	 */
	else if (Subform1_info->output_selected)
	    run_output(form, Subform1_info->output);


}   /* end run_Subform1 */





/********************************************************
*
*  Routine Name:  run_input
*
*       Purpose:  drives the pane 'input'
*
*         Input:  form - pointer to the form tree 
*		  input_info  - information structure for pane 'input'
*        Output:  action of the application program
*
*     Called By:  run_Subform1()
*
*   Automatically Generated By:  conductor -i example.form -l 1 -b
*
********************************************************/


run_input(form, input_info)

xvf_form *form;
Subform1_input *input_info;
{

	/*
	 * user clicked on pane action button 'get_input'
	 */
	if (input_info->get_input)
	{
		/* PUT YOUR CODE HERE ! */
	}



}




/********************************************************
*
*  Routine Name:  run_output
*
*       Purpose:  drives the pane 'output'
*
*         Input:  form - pointer to the form tree 
*		  output_info  - information structure for pane 'output'
*        Output:  action of the application program
*
*     Called By:  run_Subform1()
*
*   Automatically Generated By:  conductor -i example.form -l 1 -b
*
********************************************************/


run_output(form, output_info)

xvf_form *form;
Subform1_output *output_info;
{

	/*
	 * user clicked on 'live' output file selection 'outfile'
	 */
	if (output_info->outfile_selected)
	{
		/* PUT YOUR CODE HERE ! */
	}

	/*
	 * user clicked on pane action button 'save_output'
	 */
	else if (output_info->save_output)
	{
		/* PUT YOUR CODE HERE ! */
	}



}




/********************************************************
*
*  Routine Name:  run_Subform2
*
*       Purpose:  drives the subform 'Subform2'
*
*         Input:  form - pointer to the form tree 
*		  Subform2_info  - information structure for subform 'Subform2'
*        Output:  action of the application program
*
*     Called By:  run_Master()
*
*   Automatically Generated By:  conductor -i example.form -l 1 -b
*
********************************************************/


run_Subform2(form, Subform2_info)

xvf_form *form;
Master_Subform2 *Subform2_info;
{

	/*
	 * action came from the 'transforms' pane
	 */
	if (Subform2_info->transforms_selected)
	    run_transforms(form, Subform2_info->transforms);


}   /* end run_Subform2 */





/********************************************************
*
*  Routine Name:  run_transforms
*
*       Purpose:  drives the pane 'transforms'
*
*         Input:  form - pointer to the form tree 
*		  transforms_info  - information structure for pane 'transforms'
*        Output:  action of the application program
*
*     Called By:  run_Subform2()
*
*   Automatically Generated By:  conductor -i example.form -l 1 -b
*
********************************************************/


run_transforms(form, transforms_info)

xvf_form *form;
Subform2_transforms *transforms_info;
{

	/*
	 * user clicked on optional string selection 'string1'
	 */
	if (transforms_info->string1_selected)
	{
		/* PUT YOUR CODE HERE ! */
	}

	/*
	 * user clicked on optional string selection 'string2'
	 */
	if (transforms_info->string2_selected)
	{
		/* PUT YOUR CODE HERE ! */
	}

	/*
	 * user clicked on optional string selection 'string3'
	 */
	if (transforms_info->string3_selected)
	{
		/* PUT YOUR CODE HERE ! */
	}

	/*
	 * user clicked on optional integer selection 'int4'
	 */
	if (transforms_info->int4_selected)
	{
		/* PUT YOUR CODE HERE ! */
	}

	/*
	 * user clicked on pane action button 'do_something'
	 */
	if (transforms_info->do_something)
	{
		/* PUT YOUR CODE HERE ! */
	}



}


