.\" @(#)wrestrip.3t	1.3 5/15/90
.\"
.\" Copyright (c) 1990 by Sam Leffler.
.\" All rights reserved.
.\"
.\" This file is provided for unrestricted use provided that this
.\" legend is included on all tape media and as a part of the
.\" software program in whole or part.  Users may copy, modify or
.\" distribute this file at will.
.\"
.TH TIFFWriteEncodedStrip 3T "May 2, 1990"
.SH NAME
TIFFWritedEncodedStrip \- compress and write a strip of data to an open
.SM TIFF
file
.SH SYNOPSIS
.B "#include <tiffio.h>"
.br
.B "int TIFFWriteEncodedStrip(TIFF* tif, u_int strip, u_char* buf, u_int size)"
.SH DESCRIPTION
Compress
.I size
bytes of raw data from
.I buf
and
.B append
the result to the end of the specified strip.
.IR TIFFWriteEncodedStrip ()
returns \-1 if an error was encountered; otherwise it returns
the value of
.IR size .
Note that the value of
.I strip
is a ``raw strip number.''
That is, the caller must take into account whether or not the
data are organized in separate places (\c
.IR PlanarConfiguration =2).
.PP
The library attempts to hide bit- and byte-ordering differences
between the image and the native machine by converting data
from the native machine order.
Bit reversal is always done if the
.I FillOrder
tag is opposite to the native machine bit order.
Byte swapping of 16- and 32-bit samples is automatically
done when
.IR Compression =1
(``no compression''), but otherwise is left to the
compression algorithms (which should generate compressed
data in the native byte ordering of the machine).
.SH DIAGNOSTICS
All error messages are directed to the
.IR TIFFError (3T)
routine.
.PP
\fB%s: Must set "ImageWidth" before writing data\fP.
The image's width has not be set before the first write.
See
.IR TIFFSetField (3T)
for information on how to do this.
.PP
\fB%s: Must set "PlanarConfiguration" before writing data\fP.
The organization of data has not be defined before the first write.
See
.IR TIFFSetField (3T)
for information on how to do this.
.SH "SEE ALSO"
.IR intro (3T),
.IR TIFFOpen (3T),
.IR TIFFWriteScanline (3T),
.IR TIFFWriteRawStrip (3T)
