.\" @(#)setdir.3t	1.2 5/2/90
.\"
.\" Copyright (c) 1990 by Sam Leffler.
.\" All rights reserved.
.\"
.\" This file is provided for unrestricted use provided that this
.\" legend is included on all tape media and as a part of the
.\" software program in whole or part.  Users may copy, modify or
.\" distribute this file at will.
.\"
.TH TIFFSetDirectory 3T "May 2, 1990"
.SH NAME
TIFFSetDirectory \- set the current directory for an open
.SM TIFF
file
.SH SYNOPSIS
.B "#include <tiffio.h>"
.br
.B "int TIFFSetDirectory(TIFF* tif, int dirnum)"
.SH DESCRIPTION
First
.I seek
to a specific directory in file and then read the directory's contents with
.IR TIFFReadDirectory ().
The parameter
.I dirnum
specifies the subfile/directory as an integer number, with
the first directory numbered zero.
.SH DIAGNOSTICS
All error messages are directed to the
.IR TIFFError (3T)
routine.
.PP
.BR "%s: Error fetching directory count" .
An error was encountered while reading the ``directory count'' field.
.PP
.BR "%s: Error fetching directory link" .
An error was encountered while reading the ``link value'' that
points to the next directory in a file.
.SH "SEE ALSO"
.IR intro (3T),
.IR TIFFOpen (3T),
.IR TIFFReadDirectory (3T),
.IR TIFFWriteDirectory (3T)
