.\" @(#)readline.3t	1.3 5/15/90
.\"
.\" Copyright (c) 1990 by Sam Leffler.
.\" All rights reserved.
.\"
.\" This file is provided for unrestricted use provided that this
.\" legend is included on all tape media and as a part of the
.\" software program in whole or part.  Users may copy, modify or
.\" distribute this file at will.
.\"
.TH TIFFReadScanline 3T "May 9, 1990"
.SH NAME
TIFFReadScanline \- read and decode a scanline from an open
.SM TIFF
file
.SH SYNOPSIS
.B "#include <tiffio.h>"
.br
.B "int TIFFReadScanline(TIFF* tif, u_char* buf, u_int row, u_int sample)"
.SH DESCRIPTION
Return the data for the specified row in the data buffer
.IR buf .
The data are returned decompressed and, typically, in the native byte-
and bit-ordering, but is otherwise packed (see further below).
The buffer must be large enough to hold an entire scanline of data.
Applications should call the routine
.IR TIFFScanlineSize ()
to find out the size (in bytes) of a scanline buffer.
The
.I row
parameter is always used by
.IR TIFFReadScanline ();
the
.I sample
parameter is used only if data are organized in separate planes (\c
.IR PlanarConfiguration =2).
.IR TIFFReadScanline
returns \-1 if it detects an error; otherwise 1 is returned.
.SH NOTES
The library attempts to hide bit- and byte-ordering differences
between the image and the native machine by converting data
to the native machine order.
Bit reversal is always done if the
.I FillOrder
tag is opposite to the native machine bit order.
Byte swapping of 16- and 32-bit samples is automatically
done when
.IR Compression =1
(``no compression''), but otherwise is left to the
decompression algorithms (which should generate decompressed
data in the native byte ordering of the machine).
.PP
In C++ the
.I sample
parameter defaults to 0.
.SH DIAGNOSTICS
All error messages are directed to the
.IR TIFFError (3T)
routine.
.PP
.BR "Compression algorithm does not support random access" .
Data was requested in a non-sequential order from a file that
uses a compression algorithm and that has
.I RowsPerStrip
greater than one.
That is, data in the image is stored in a compressed form,
and with multiple rows packed into a strip.
In this case, the library does not support random access to the data.
The data should either be accessed sequentially, or the file
should be converted so that each strip is made up of one row
of data.
.SH "SEE ALSO"
.IR intro (3T),
.IR TIFFOpen (3T),
.IR TIFFReadEncodedStrip (3T),
.IR TIFFReadRawStrip (3T)
