/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */
#include "unmcopyright.h"
#include "example2.h"

/********************************************************
*
*  Routine Name:  run_sub
*
*       Purpose:  drives the subform 'sub'
*
*         Input:  form - pointer to the form tree 
*		  sub_info  - information structure for subform 'sub'
*        Output:  action of the application program
*
*     Called By:  run_example2()
*
*   Automatically Generated By:  conductor -i example2.pane -l 1 -b
*
********************************************************/


run_sub(form, sub_info)

xvf_form *form;
master_sub *sub_info;
{

	/*
	 * action came from the 'pane' pane
	 */
	if (sub_info->pane_selected)
	    run_pane(form, sub_info->pane);


}   /* end run_sub */





/********************************************************
*
*  Routine Name:  run_pane
*
*       Purpose:  drives the pane 'pane'
*
*         Input:  form - pointer to the form tree 
*		  pane_info  - information structure for pane 'pane'
*        Output:  action of the application program
*
*     Called By:  run_sub()
*
*   Automatically Generated By:  conductor -i example2.pane -l 1 -b
*
********************************************************/


run_pane(form, pane_info)

xvf_form *form;
sub_pane *pane_info;
{

	char *filename;
	struct xvimage *image;
	char temp[MaxLength];

	/* 
	 * make sure they've provided a filename 
         */
	if (pane_info->i == NULL)
        {
             xvf_error_wait("Error! No filename specified.", 
			    "run_pane", NULL);
                 return;
        }
	filename = vfullpath(pane_info->i, NULL, NULL);

	/*
         *  read in the new image
         */
        if (!(image = readimage(filename)))
        {
           /* error in readimage */
	   sprintf(temp, "Unable to read image from file %s.", filename);
           xvf_error_wait(temp, "run_file", NULL);
	   return;
	}
	/*
	 *  update with the new image
	 */
	xvd_update_image(xvdisplay, image);
	xvd_set_colormap(workspace, xvdisplay->colormap, True);
	free(filename);
}
