: # use perl
        eval 'exec perl -S $0 "$@"'
                if $runnning_under_some_shell;

# Khoros: $Id$
# $Log$

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

#========================================================================
#
#  Program Name: kunpack - will unpack a pack file created by kpack
#
#       Purpose: The script will unpack a pack file created by kpack.
#		 It will determine the contents of the pack file and
#		 prompt the user for which toolboxes or objects to
#		 unpack and which files to delete if applicable.
#
#     Arguments: dir   - directory containing pack file
#		 file  - pack file
#		 force - do not prompt unless installing new toolbox
#			 or object
#
#   Exit Status: 1 if failed, 0 on success
#
#      Comments: This routine uses kunpack to verify to integrity of the object.
#    Written By: John M. Salas and Steve Kubica
#          Date: Apr 11, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#========================================================================
@khoros_toolbox = ('KHOROS_TOOLBOX');
if (! eval("\$toolboxes = \$ENV{\"KHOROS_TOOLBOX\"}"))
{
   die "The KHOROS_TOOLBOX environment variable must be set.\n";
}

$notfound = 1;
@toolbox_list = split(':', $toolboxes);
foreach $toolbox_file (sort(@toolbox_list))
{
   if ( ! open(TBS,"<$toolbox_file"))
   {
      print "Can not open $toolbox_file.  Please check to make sure your\n";
      die   "KHOROS_TOOLBOX environment variable points to existing files.\n";
   }

   while(<TBS>)
   {
      chop($_);
      @line = split(':',$_);
      if ($line[0] eq "SUPPORT")
      {
         if ( $notfound )
         {
            $support_path = $line[1];
            $notfound = 0;
         }
         else
         {
            print "The SUPPORT toolbox is defined twice.  Please check your\n";
            print "KHOROS_TOOLBOX environment variable and the file(s)\n";
            print "pointed to by it and make sure that all toolboxes are\n";
            die   "only defined once.\n";
         }
      }
   }
}

if ( $notfound )
{
   print "The SUPPORT toolbox is not defined in any of the files pointed to\n";
   die   "by the environment variable KHOROS_TOOLBOX.\n";
}

@INC = ("$support_path/repos/perl", @INC);
require "khoros.pl";
require "stat.pl";

#
# list of directories which we can expect to see in the toplevel of a toolbox
#
%tbdirs = (     'bin',          'executables',
                'data',         'sample data files',
                'examples',     'example programs',
                'help',         'help files',
                'include',      'public includes',
                'lib',          'library files',
                'mach',         'multiple architecture shadow trees',
                'manual',       'toolbox manual(s)',
                'objects',      'objects live in here',
                'repos',        'toolbox file repository',
                'testsuite',    'testsuites for objects in this toolbox'
        );

$whatis         = 'khoros kpack program';
@kunpack_args  = (
  '[dir]',     'dir',  'directory containing unpack pack file [.]',
  '[file]',    'file', 'input file to use [transfer.pack]',
  '[force]',   '',     'do not prompt unless new toolbox or object being installed',
);

#
# Initialize Khoros perl lib
#
&khoros'initialize("SUPPORT",$whatis,@kunpack_args);

# parse command line args
&khoros'parse_args(@ARGV);

$opt_dir   = $khoros'seenswitch{"dir"};
$opt_file  = $khoros'seenswitch{"file"};
$opt_force = $khoros'seenswitch{"force"};

#
# Get tmp directory to store temporary checksum files and tar files
#
$tmpdir = $ENV{'TMPDIR'};
if ($tmpdir eq '')
{
   $tmpdir = "/usr/tmp";
}

#
# Save current working directory
#
$cwd = `pwd`;
chop($cwd);

#
#
#
if ($opt_dir)
{
   $dir = $khoros'argval{"dir"};
   if (index($dir,'/') != 0 && index($dir,'~') != 0)
   {
      $dir = "$cwd/$dir";
   }
}
else
{
   $dir = "$cwd";
}
#
# If the output file is specified get it and if it is relative to cwd
# pre-append $cwd to it else it is already an absolute.  If not specified
# set it to 'transfer.pack' located in the $cwd directory.
#
if ($opt_file)
{
   $file = $khoros'argval{"file"};
   if (index($file,'/') != 0 && index($file,'~') != 0)
   {
      $file = "$dir/$file";
   }
}
else
{
   $file = "$dir/transfer.pack";
}

{
#
# Untar the pack file.
#
   chdir("$dir");
   system("mkdir unpack.$$");
   chdir("unpack.$$");
   system("tar xf $file");

#
# Open the INDEX file, exit if it can not be opened
#
   if ( ! -f "$dir/unpack.$$/INDEX" )
   {
      print "Can not open INDEX file, is the file specified a pack file created by kpack?\n";
      print "Please check, exiting.\n";
      chdir("$dir");
      system("rm -rf unpack.$$");
      exit(1);
   }

#
# Finds all the toolboxes to delete.
#
   @toolboxes = &findtbsto("delete","$dir/unpack.$$/INDEX");

   unless ($toolboxes[0] eq "no toolboxes")
   {
      DTOOLBOX: foreach $tb (sort(@toolboxes))
      {
         chop($tbpath = `kecho -tb $tb -echo path`);
         unless ( -d $tbpath )
         {
	    print "Toolbox $tb does not exist no need to delete, huh!\n";
	    next DTOOLBOX;
         }

	 if ( ! $opt_force )
	 {
            print "\n";
            print "Toolbox $tb to be delete, go ahead (y/n) [y]? ";
            $ans = <STDIN>;
            chop($ans);
            if ($ans eq 'N' || $ans eq 'n')
            {
               print "\n";
               print "\t\tGoing to next toolbox.\n";
               print "\n";
               next DTOOLBOX;
            }

            print "\n";
            print "Do you want to save toolbox $tb before deleting (y/n) [y]? ";
            $ans = <STDIN>;
            chop($ans);
            if ($ans ne 'N' && $ans ne 'n' && ! &savetb("$tb"))
            {
               print "Saved failed to you want to delete $tb anyway (y/n) [n]? ";
               $ans = <STDIN>;
               chop($ans);
               if ($ans eq 'N' || $ans eq 'n')
               {
                  print "\n";
                  print "\t\tGoing to next toolbox.\n";
                  print "\n";
                  next DTOOLBOX;
               }
            }
         }

         print "Deleting toolbox $tb.\n";
         system("krm -tb $tb -force");
      }
   }

#
# Finds all the toolboxes that have objects to delete from them.
#
   @toolboxes = &findtbobjto("delete","$dir/unpack.$$/INDEX");

   unless ($toolboxes[0] eq "no toolboxes")
   {
      DOTOOLBOX: foreach $tb (sort(@toolboxes))
      {
         chop($tbpath = `kecho -tb $tb -echo path`);
         unless ( -d $tbpath )
         {
	    print "Toolbox $tb does not exist no need to delete objects from it, huh!\n";
	    next DOTOOLBOX;
         }

	 @objects = &findobjto("delete","$tb","$dir/unpack.$$/INDEX");

         OBJECTSD: foreach $object (sort(@objects))
         {
            chop($objpath = `kecho -tb $tb -oname $object -echo path`);
            if ( $? )
	    {
	       print "Object $object in toolbox $tb does not exist no need to delete, huh!\n";
	       next OBJECTSD;
	    }

	    if ( ! $opt_force )
	    {
               print "\n";
               print "Object $object in toolbox $tb to be delete, go ahead (y/n) [y]? ";
               $ans = <STDIN>;
               chop($ans);
               if ($ans eq 'N' || $ans eq 'n')
               {
	          print "\n";
	          print "\t\tGoing to next object.\n";
	          print "\n";
	          next OBJECTSD;
               }

               print "Save object $object in toolbox $tb before deleting (y/n) [y]? ";
               $ans = <STDIN>;
               chop($ans);
               if ($ans ne 'N' && $ans ne 'n' && ! &saveobj("$tb","$object"))
               {
                  print "Saved failed to you want to delete $object anyway (y/n) [n]? ";
                  $ans = <STDIN>;
                  chop($ans);
                  if ($ans eq 'N' || $ans eq 'n')
                  {
                     print "\n";
                     print "\t\tGoing to next object.\n";
                     print "\n";
                     next OBJECTSD;
                  }
               }
            }

            print "Deleting object $object from toolbox $tb.\n";
            system("krm -tb $tb -oname $object -force");
	 }
      }
   }

#
# Finds all the toolboxes to add.
#
   @toolboxes = &findtbsto("add","$dir/unpack.$$/INDEX");

   unless ($toolboxes[0] eq "no toolboxes")
   {
      ATOOLBOX: foreach $tb (sort(@toolboxes))
      {
         chop($tbpath = `kecho -tb $tb -echo path`);
	 $savedir = `pwd`;
         unless ( -d $tbpath )
         {
	    print "Toolbox does not exist, install it (y/n) [y]? ";
            $ans = <STDIN>;
            chop($ans);
            if ($ans eq 'N' || $ans eq 'n')
            {
	       print "\n";
	       print "\t\tGoing to next toolbox.\n";
	       print "\n";
	       next ATOOLBOX;
            }

	    $repeat = 1;
	    while ($repeat)
	    {
#
# Should be entering directory above $tb
#
	       print "Enter path to toolbox directory [no default]? ";
               $newtbdir = <STDIN>;
               chop($newtbdir);
               if ($newtbdir eq '')
               {
	          print "\n";
	          print "\t\tPlease enter a path to the toolbox, no default.\n";
	          print "\n";
	       }
	       else
	       {
	          unless ( -d $newtbdir )
	          {
	             print "\n";
	             print "Directory $newtbdir does not exist, create it (y/n) [y]? ";
            	     $ans = <STDIN>;
            	     chop($ans);

		     if ($ans eq 'N' || $ans eq 'n')
		     {
	                print "Do you want to enter new directory (y/n) [y]? ";
            	        $ans = <STDIN>;
            	        chop($ans);
		        if ($ans eq 'N' || $ans eq 'n')
		        {
	                   print "\n";
		           print "\t\tGoing to next toolbox.\n";
	                   print "\n";
		           next ATOOLBOX;
		        }
	                print "\n";
		        print "\t\tTry another directory.\n";
	                print "\n";
		     }
		     elsif (! mkdir("$newtbdir", 0777))
      	             {
		        print "Can not create pack directory $newtbdir: $!\n";
	                print "\n";
	                print "Do you want to enter new directory (y/n) [y]? ";
            	        $ans = <STDIN>;
            	        chop($ans);
		        if ($ans eq 'N' || $ans eq 'n')
		        {
	                   print "\n";
		           print "\t\tGoing to next toolbox.\n";
	                   print "\n";
		           next ATOOLBOX;
		        }
      	             }
	          }
	          
	          if ( -d $newtbdir )
	          {
	             $repeat = 0;
	          }
	       }
	    }
	    $oldtb = 0;
	    chdir("$newtbdir");
	    $tbpath = "$newtbdir/$tb";
         }
         else
         {
	    if ( ! $opt_force )
	    {
               print "\n";
               print "Toolbox $tb to be installed, go ahead (y/n) [y]? ";
               $ans = <STDIN>;
               chop($ans);
               if ($ans eq 'N' || $ans eq 'n')
               {
                  print "\n";
                  print "\t\tGoing to next toolbox.\n";
                  print "\n";
                  next ATOOLBOX;
               }

	       print "\n";
               print "Do you want to save toolbox $tb before overwriting (y/n) [y]? ";
               $ans = <STDIN>;
               chop($ans);
	       if ($ans ne 'N' && $ans ne 'n' && ! &savetb("$tb"))
	       {
	          print "Saved failed to you want to install $tb anyway (y/n) [n]? ";
                  $ans = <STDIN>;
                  chop($ans);
	          if ($ans eq 'N' || $ans eq 'n')
	          {
	             print "\n";
	             print "\t\tGoing to next toolbox.\n";
	             print "\n";
	             next ATOOLBOX;
	          }
	       }
	    }
	    $oldtb = 1;
	    chdir("$tbpath/..");
#
# Delete the old toolbox and add the new.
#
	    print "Removing old toolbox files for $tb.\n";
	    system("rm -rf $tbpath");
         }

	 print "Unpacking $tb in $tbpath.\n";
	 system("zcat $dir/unpack.$$/$tb.tar.Z | tar xf - $tb");
	 if ( ! $oldtb )
	 {
	    system("kgentb -tb $tb -path $newtbdir/$tb -add");
	 }
	 chdir("$savedir");
      }
   }

#
# Finds all the toolboxes that have objects to add to them.
#
   @toolboxes = &findtbobjto("add","$dir/unpack.$$/INDEX");

   unless ($toolboxes[0] eq "no toolboxes")
   {
      AOTOOLBOX: foreach $tb (sort(@toolboxes))
      {
         chop($tbpath = `kecho -tb $tb -echo path`);
         unless ( -d $tbpath )
         {
	    print "\n";
	    print "\t\tToolbox does not exist.\n";
	    print "\t\tCan not add any objects for $tb from the pack.\n";
	    print "\t\tGoing to next toolbox.\n";
	    print "\n";
	    next AOTOOLBOX;
         }

	 $savedir = `pwd`;
	 chdir("$tbpath/..");
	 $tbdir = &determinetbdir("$tbpath");
	 @objects = &findobjto("add","$tb","$dir/unpack.$$/INDEX");

         OBJECTSA: foreach $object (sort(@objects))
         {
	    if ( ! $opt_force )
	    {
               print "\n";
               print "Object $object in toolbox $tb to be installed, go ahead (y/n) [y]? ";
               $ans = <STDIN>;
               chop($ans);
               if ($ans eq 'N' || $ans eq 'n')
               {
	          print "\n";
	          print "\t\tGoing to next object.\n";
	          print "\n";
	          next OBJECTSA;
               }
            }

            chop($objpath = `kecho -tb $tb -oname $object -echo path`);

            if ( $? )
	    {
	       $oldobject = 0;
	       $type = &determineobjtype("$tb","$object","$dir/unpack.$$/INDEX");
	       if ($type eq "no toolboxes")
	       {
		  print "This should never happen, but it did.\n";
		  print "INDEX file might have gotten corrupted.\n";
		  print "Going to try next object\n";
		  next OBJECTSA;
	       }

	       print "Adding object $object into toolbox $tb.\n";
	       if ( $type eq "script" )
	       {
	          system("kgenobj -tb $tb -oname $object -type $type -lang sh");
	       }
	       elsif ( $type eq "xvroutine" )
	       {
	          system("kgenobj -tb $tb -oname $object -type $type");
	       }
	       else
	       {
	          system("kgenobj -tb $tb -oname $object -type $type");
	       }

               chop($objpath = `kecho -tb $tb -oname $object -echo path`);
	    }
	    else
	    {
	       if ( ! $opt_force )
	       {
                  print "Save object $object in toolbox $tb before overwriting (y/n) [y]? ";
                  $ans = <STDIN>;
                  chop($ans);
	          if ($ans ne 'N' && $ans ne 'n' && ! &saveobj("$tb","$object"))
	          {
	             print "Saved failed to you want to install $object anyway (y/n) [n]? ";
                     $ans = <STDIN>;
                     chop($ans);
	             if ($ans eq 'N' || $ans eq 'n')
	             {
	                print "\n";
	                print "\t\tGoing to next object.\n";
	                print "\n";
	                next OBJECTSA;
	             }
	          }
	       }
	       $oldobject = 1;
#
# The object exist and needs to be deleted before the new one installed.
# Just tell the user you are deleting it if kunpack did not just create it.
#
	       print "Removing old object $object from toolbox $tb.\n";
	    }

	    $objdir = &determineobjdir("$tbdir","$objpath");

	    system("rm -rf $objpath");

	    if ( index ($objdir, "library") >= $[ )
	    {
	        system("rm -rf $tbpath/include/$object");
	    }

	    if ( $oldobject )
	    {
	       print "Adding object $object into toolbox $tb.\n";
	    }
	    system("zcat $dir/unpack.$$/$tb.tar.Z | tar xf - $tbdir/$objdir");

	    if ( index ($objdir, "library") >= $[ )
	    {
	       system("zcat $dir/unpack.$$/$tb.tar.Z | tar xf - $tbdir/include/$object");
	    }
         }
	 chdir("$savedir");
      }
   }

#
# Finds all the toolboxes that have objects that have files to replace in them.
#
   @toolboxes = &findtbobjto("replace","$dir/unpack.$$/INDEX");

   unless ($toolboxes[0] eq "no toolboxes")
   {
      ROTOOLBOX: foreach $tb (sort(@toolboxes))
      {
         chop($tbpath = `kecho -tb $tb -echo path`);
         unless ( -d $tbpath )
         {
	    print "\n";
	    print "\t\tToolbox does not exist.\n";
	    print "\t\tCan not replace any objects for $tb from the pack.\n";
	    print "\t\tGoing to next toolbox.\n";
	    print "\n";
	    next ROTOOLBOX;
         }

	 chdir("$tbpath/..");
	 @objects = &findobjto("replace","$tb","$dir/unpack.$$/INDEX");

         OBJECTSR: foreach $object (sort(@objects))
         {
            chop($objpath = `kecho -tb $tb -oname $object -echo path`);

            if ( $? )
	    {
	       print "Object $object does not exist in toolbox $tb, can not replace files.\n";
	       next OBJECTSR;
	    }

	    if ( ! $opt_force )
	    {
               print "\n";
               print "Object $object in toolbox $tb to have files replaced, go ahead (y/n) [y]? ";
               $ans = <STDIN>;
               chop($ans);
               if ($ans eq 'N' || $ans eq 'n')
               {
	          print "\n";
	          print "\t\tGoing to next object.\n";
	          print "\n";
	          next OBJECTSR;
               }

	       $savebefore = 1;
	       print "Do you wish to backup files before replacing them (y/n) [y]? ";
               $ans = <STDIN>;
               chop($ans);
	       if ($ans eq 'N' || $ans eq 'n')
	       {
	          $savebefore = 0;
	       }
	       else
	       {
	          $repeat = 1;
	          while ( $repeat )
	          {
	             print "\n";
	             print "Enter tar file to save files in, give complete path? ";
	             $savefile = <STDIN>;
	             chop($savefile);
	             if ( &checksavefilepath($savefile) )
	             {
	                $repeat = 0;
	             }
		     else
		     {
		        print "Can not create $savefile.\n";
	                print "\n";
	                print "Do you want to enter new file (y/n) [y]? ";
            	        $ans = <STDIN>;
            	        chop($ans);
		        if ($ans eq 'N' || $ans eq 'n')
		        {
	                   print "\n";
		           print "\t\tGoing to next object.\n";
	                   print "\n";
		           next OBJECTSR;
		        }
		     }
	          }
	       }
	    }

	    @objectfiles = &determineobjfiles("$tb","$object","$dir/unpack.$$/INDEX");

	    foreach $f (@objectfiles)
	    {
	       print "Adding file $f in object $object for $tb.\n";
	       if ( ! $opt_force && -f $f && $savebefore )
	       {
		  if ( -f $savefile )
		  {
		     system("tar -uf $savefile $f");
		  }
		  else
		  {
		     system("tar -cf $savefile $f");
		  }
	       }
	       system("zcat $dir/unpack.$$/$tb.tar.Z | tar xf - $f");
	    }
	 }
      }
   }

   chdir("$dir");
   system("rm -rf unpack.$$");
}
chdir("$cwd");
exit($exit_status);

#------------------------------------------------------------------------
#
#  Routine Name: findtbsto - finds the toolboxes in a INDEX file and returns a list of the names
#
#       Purpose: This routine take the filename passed in an finds the
#                toolboxes contained within and returns a list of them.
#                It ignores multiple occurences of the toolbox.
#
#         Input: filename - file containing pack index
#
#       Returns: list of toolboxes in index file
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 11, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub findtbsto{

   local($operation) = @_[0];
   local($filename)  = @_[1];
   local(%list);
   local(@line);
   local(@toolboxes);

   if ( $operation ne "delete" && $operation ne "add" )
   {
      print "Unknown operation $operation\n";
      return ("no toolboxes");
   }

   if ( ! open(FILE,"<$filename") )
   {
      print "Can not open file that contains index: $filename\n";
      return ("no toolboxes");
   }

   while(<FILE>)
   {
      @line = split(':',$_);
      if ( ! defined($list{$line[0]}) && $line[2] eq "$operation" &&
	   $line[1] eq "" )
      {
         push(@toolboxes,"$line[0]");
         $list{$line[0]} = 1;
      }
   }
 
   close(FILE);
   return(@toolboxes);
}

#------------------------------------------------------------------------
#
#  Routine Name: findtbobjto -
#
#       Purpose:
#
#         Input: filename - file containing pack index
#
#       Returns: list of toolboxes in index file
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 12, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub findtbobjto {

   local($operation) = @_[0];
   local($filename)  = @_[1];
   local(%list);
   local(@line);
   local(@toolboxes);

   if ( $operation ne "delete" && $operation ne "add" &&
	$operation ne "replace" )
   {
      print "Unknown operation $operation\n";
      return ("no toolboxes");
   }

   if ( ! open(FILE,"<$filename") )
   {
      print "Can not open file that contains index: $filename\n";
      return ("no toolboxes");
   }

   while(<FILE>)
   {
      @line = split(':',$_);
      if ( ! defined($list{$line[0]}) && $line[2] eq "$operation" &&
	   $line[1] ne "" )
      {
         push(@toolboxes,"$line[0]");
         $list{$line[0]} = 1;
      }
   }

   close(FILE);
   return(@toolboxes);
}

#------------------------------------------------------------------------
#
#  Routine Name: findobjto -
#
#       Purpose:
#
#         Input: filename - file containing pack index
#
#       Returns: list of toolboxes in index file
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 12, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub findobjto {

   local($operation) = @_[0];
   local($tb)        = @_[1];
   local($filename)  = @_[2];
   local(%list);
   local(@line);
   local(@objects);

   if ( $operation ne "delete" && $operation ne "add" &&
	$operation ne "replace" )
   {
      print "Unknown operation $operation\n";
      return ("no toolboxes");
   }

   if ( ! open(FILE,"<$filename") )
   {
      print "Can not open file that contains index: $filename\n";
      return ("no toolboxes");
   }

   while(<FILE>)
   {
      @line = split(':',$_);
      if ( ! defined($list{$line[1]}) && $line[2] eq $operation &&
	   $line[1] ne "" && $line[0] eq "$tb" )
      {
         push(@objects,"$line[1]");
         $list{$line[1]} = 1;
      }
   }

   close(FILE);
   return(@objects);
}

#------------------------------------------------------------------------
#
#  Routine Name: checksavefilepath -
#
#       Purpose:
#
#         Input: tb - toolbox to save
#
#       Returns: 1 on success or 0 otherwise
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 12, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub checksavefilepath {
   local($path) = @_;
   local(@list);
   local($dir);

   @list = split('/',$path);

   pop(@list);

   $dir = join("/",@list);

   if ( -d $dir && -w $dir )
   {
      return(1);
   }

   return(0);
}

#------------------------------------------------------------------------
#
#  Routine Name: savetb -
#
#       Purpose:
#
#         Input: tb - toolbox to save
#
#       Returns: 1 on success or 0 otherwise
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 12, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub savetb {
   local($tb)     = @_;
   local($repeat) = 1;
   local($tbpath);
   local($tbdir);
   local($savedir);

   while ( $repeat )
   {
      print "\n";
      print "Enter tar file to save toolbox $tb in, give complete path? ";
      $savefile = <STDIN>;
      chop($savefile);
      if ( &checksavefilepath($savefile) )
      {
         $repeat = 0;
      }
      else
      {
	 print "Can not create $savefile.\n";
         print "\n";
         print "Do you want to enter new file (y/n) [y]? ";
	 $ans = <STDIN>;
         chop($ans);
	 if ($ans eq 'N' || $ans eq 'n')
	 {
	    return (0);
	 }
      }
   }

   chop($tbpath = `kecho -tb $tb -echo path`);
   unless ( -d $tbpath )
   {
      print "\n";
      print "\t\tToolbox $tb does not exist.\n";
      print "\n";
      return (0);
   }

   $savedir = `pwd`;

   $tbdir = &determinetbdir("$tbpath");
   chdir("$tbpath/..");
   if ( -f $savefile )
   {
      system("tar -uf $savefile $tbdir");
   }
   else
   {
      system("tar -cf $savefile $tbdir");
   }

   if ( $? )
   {
      print "\n";
      print "\t\tToolbox $tb failed to be tar'ed up.\n";
      print "\n";
      chdir("$savedir");
      return (0);
   }

   chdir("$savedir");
   return (1);
}

#------------------------------------------------------------------------
#
#  Routine Name: saveobj -
#
#       Purpose:
#
#         Input: tb - toolbox to save
#
#       Returns: 1 on success or 0 otherwise
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 12, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub saveobj {
   local($tb)     = @_[0];
   local($object) = @_[1];
   local($repeat) = 1;
   local($tbpath);
   local($tbdir);
   local($objpath);
   local($objdir);
   local($savedir);

   while ( $repeat )
   {
      print "\n";
      print "Enter tar file to save object $object of toolbox $tb in, give complete path? ";
      $savefile = <STDIN>;
      chop($savefile);
      if ( &checksavefilepath($savefile) )
      {
         $repeat = 0;
      }
      else
      {
	 print "Can not create $savefile.\n";
         print "\n";
         print "Do you want to enter new file (y/n) [y]? ";
	 $ans = <STDIN>;
         chop($ans);
	 if ($ans eq 'N' || $ans eq 'n')
	 {
	    return (0);
	 }
      }
   }

   chop($tbpath = `kecho -tb $tb -echo path`);
   unless ( -d $tbpath )
   {
      print "\n";
      print "\t\tToolbox $tb does not exist.\n";
      print "\n";
      return (0);
   }

   chop($objpath = `kecho -tb $tb -oname $object -echo path`);
   unless ( -d $objpath )
   {
      print "\n";
      print "\t\tObject $object in toolbox $tb does not exist.\n";
      print "\n";
      return (0);
   }

   $savedir = `pwd`;

   chdir("$tbpath/..");
   $tbdir  = &determinetbdir("$tbpath");
   $objdir = &determineobjdir("$tbdir","$objpath");

   if ( -f $savefile )
   {
      system("tar -uf $savefile $tbdir/$objdir");
   }
   else
   {
      system("tar -cf $savefile $tbdir/$objdir");
   }

   if ( index ($objdir, "library") >= $[ )
   {
      system("tar -uf $savefile $tbdir/include/$object");
   }

   if ( $? )
   {
      print "\n";
      print "\t\tObject $object in toolbox $tb failed to be tar'ed up.\n";
      print "\n";
      chdir("$savedir");
      return (0);
   }

   chdir("$savedir");
   return (1);
}

#------------------------------------------------------------------------
#
#  Routine Name: determinetbdir - 
#
#       Purpose:
#
#         Input: filename - file containing pack index
#
#       Returns: nothing
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 14, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub determinetbdir {
   local($tbpath) = @_[0];
   local(@enddir);

   @enddir = split('/',$tbpath);
   
   return("$enddir[$#enddir]");
}

#------------------------------------------------------------------------
#
#  Routine Name: determineobjdir - 
#
#       Purpose:
#
#         Input: filename - file containing pack index
#
#       Returns: nothing
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 14, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub determineobjdir {
   local($tbdir)   = @_[0];
   local($objdir)  = @_[1];
   local($i)	   = 0;
   local($dir);
   local(@returndir);

   @dir = split('/',$objdir);

   while ( "$dir[$i]" ne "$tbdir" )
   {
      $i++;
   }

   $i++;
   while ( $i <= $#dir )
   {
      push(@returndir,$dir[$i]);
      $i++;
   }

   return(join("/",@returndir));
}

#------------------------------------------------------------------------
#
#  Routine Name: determineobjtype - 
#
#       Purpose:
#
#         Input: filename - file containing pack index
#
#       Returns: nothing
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 14, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub determineobjtype {
   local($tb)       = @_[0];
   local($object)   = @_[1];
   local($filename) = @_[2];
   local(@line);

   if ( ! open(FILE,"<$filename") )
   {
      print "Can not open file that contains index: $filename\n";
      return ("no toolboxes");
   }

   while(<FILE>)
   {
      @line = split(':',$_);
      if ( $line[2] eq "add" && $line[1] eq "$object" && $line[0] eq "$tb" )
      {
	 chop($line[3]);
	 close(FILE);
         return("$line[3]");
      }
   }

   close(FILE);
   return("no toolboxes");
}

#------------------------------------------------------------------------
#
#  Routine Name: determineobjfiles - 
#
#       Purpose:
#
#         Input: filename - file containing pack index
#
#       Returns: nothing
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 14, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub determineobjfiles {
   local($tb)       = @_[0];
   local($object)   = @_[1];
   local($filename) = @_[2];
   local(%list);
   local(@line);
   local(@objectfiles);

   if ( ! open(FILE,"<$filename") )
   {
      print "Can not open file that contains index: $filename\n";
      return ("no toolboxes");
   }

   while(<FILE>)
   {
      @line = split(':',$_);
      if ( ! defined($list{$line[3]}) && $line[2] eq "replace" &&
	   $line[1] eq "$object" && $line[0] eq "$tb" )
      {
	 chop($line[3]);
         push(@objectfiles,"$line[3]");
         $list{$line[3]} = 1;
      }
   }

   close(FILE);
   return(@objectfiles);
}

