: # use perl
        eval 'exec perl -S $0 "$@"'
                if $runnning_under_some_shell;

# Khoros: $Id$
# $Log$

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.



#========================================================================
#
#  Program Name: kmkcontents - Make a manual volume table of contents
#
#       Purpose: This perl script generates a table of contents for
#                a set of volumes.  For instance, if a given toolbox
#                has 4 volumes, kmkcontents will make a table of
#		 contents listing each volume.
#
#     Arguments: argument1 - explanation
#                argument2 - explanation
#                argument3 - explanation
#
#   Exit Status: True (1) on success, False (0) otherwise
#
#      Comments: Explanation of algorithm if applicable
#    Written By: Neil Bowers
#          Date: 
#      Verified:
#  Side Effects:
# Modifications:
#
#========================================================================

@khoros_toolbox = ('KHOROS_TOOLBOX');
if (! eval("\$toolboxes = \$ENV{\"KHOROS_TOOLBOX\"}"))
{
   die "The KHOROS_TOOLBOX environment variable must be set.\n";
}

$notfound = 1;
@toolbox_list = split(':', $toolboxes);
foreach $toolbox_file (sort(@toolbox_list))
{
   if ( ! open(TBS,"<$toolbox_file"))
   {
      print "Can not open $toolbox_file.  Please check to make sure your\n";
      die   "KHOROS_TOOLBOX environment variable points to existing files.\n";
   }

   while(<TBS>)
   {
      chop($_);
      @line = split(':',$_);
      if ($line[0] eq "SUPPORT")
      {
         if ( $notfound )
         {
            $support_path = $line[1];
            $notfound = 0;
         }
         else
         {
            print "The SUPPORT toolbox is defined twice.  Please check your\n";
            print "KHOROS_TOOLBOX environment variable and the file(s)\n";
            print "pointed to by it and make sure that all toolboxes are\n";
            die   "only defined once.\n";
         }
      }
   }
}

if ( $notfound )
{
   print "The SUPPORT toolbox is not defined in any of the files pointed to\n";
   die   "by the environment variable KHOROS_TOOLBOX.\n";
}

@INC = ("$support_path/repos/perl", @INC);
require "khoros.pl";

$whatis = 'create a manual table of contents for all volumes';

@kmkcontents_args = (
	'tb',   'toolbox',      'name of toolbox',
        'vols', 'volumes',      'volumes to make'
);

# initialize Khoros perl lib
&khoros'initialize("SUPPORT",$whatis,@kmkcontents_args);

&khoros'parse_args(@ARGV);	        # parse command line args
@toolbox = @ARGV[1];			# get the toolbox name
$start_of_vols = 3;			# mark the begining of volume list
$end_of_vols   = $#ARGV;		# mark the end of volume list

# Build the volume list
$i = 0;
foreach $j ($start_of_vols .. $end_of_vols) {
   @volume_list[$i] = @ARGV[$j];
   $i++;
}

@doc_path = &khoros'toolbox_path("SUPPORT");      # get doc toolbox path
@tb_path = &khoros'toolbox_path(@toolbox);	# get path to toolbox

$manual_home = "@tb_path/manual";		# set path to toolbox manual


# build list of volumes
opendir(MANUALDIR,$manual_home) || die "Unable to access manual directory.\n";


closedir(MANUALDIR);

# copy template contents.man file to manual/contents directory if
# it does not already exist
$contents_template_man = "@doc_path/objects/script/kmkcontents/misc/templates/contents.man";

if ( !-e "$manual_home/contents/contents.man" ) {
   print STDERR "\ncopying $contents_template_man to $manual_home/contents\n\n";
   system("cp $contents_template_man $manual_home/contents");
}

foreach $volume (@volume_list) {

	print "Volume: $volume\n";

	# directory containing volume
	$vol_dir = "$manual_home/$volume";

	# get list of sections in the volume
	opendir(VOL_DIR,$vol_dir) || die "Unable to open $vol_dir.\n";
	@allfiles = readdir(VOL_DIR);

	@section_list = sort grep(/^([A-Z]|[A-Z][A-Z][0-9A-Z])\.[0-9A-Z]\./,@allfiles);

	closedir(VOL_DIR);

	$got_vol_name = 0;

	open(CONTENTS,"> $manual_home/contents/$volume.sec");

	foreach $section (@section_list) {
		opendir(SEC_DIR,"$vol_dir/$section") || do {
			print STDERR "Failed to open section $section\n";
			next;
		};
		@file_list = grep(/\.man$/,readdir(SEC_DIR));
		closedir(SEC_DIR);
		$man_file_name = $file_list[0];
		open(MANFILE,"< $vol_dir/$section/$man_file_name");
		while (<MANFILE>) {
			/^.chapter\s+"?([^"]+)"?\s+"([^"]+)"\s+(\w+)\s+"([^"]+)"\s+"([^"]*)"\s+"([^"]*)"/ && do {
				unless ($got_vol_name) {
					print CONTENTS ".bp\n";
					print CONTENTS ".ps 18\n";
					print CONTENTS ".ce\n";
					print CONTENTS "\\fB$2\\fP\n";
					print CONTENTS "\\ \n";
					print CONTENTS ".sp 2\n";
					print CONTENTS ".ps 16\n";
					print CONTENTS ".paragraph\n";
					$got_vol_name = 1;
				}

				# Chapter stuff
				print CONTENTS ".IP \"\\fBChapter $3.\\fP\" 15\n";
				print CONTENTS "$4\n";
				print CONTENTS ".in +0.25i\n";
				print CONTENTS "\\fI$5 $6\\fP\n";
				print CONTENTS ".in -0.25i\n";
				print CONTENTS ".sp\n";
			};
			/^.appendix\s+"?([^"]+)"?\s+"([^"]+)"\s+"(\w+)"\s+"([^"]+)"\s+"([^"]*)"\s+"([^"]*)"/ && do {
				# Appendix Chapter stuff
				print CONTENTS ".IP \"\\fBAppendix $3.\\fP\" 15\n";
				print CONTENTS "$4\n";
				print CONTENTS ".in +0.25i\n";
				print CONTENTS "\\fI$5 $6\\fP\n";
				print CONTENTS ".in -0.25i\n";
				print CONTENTS ".sp\n";
			};
		}
		close(MANFILE);
	}
				print CONTENTS ".IP \"\\fBGlossary\\fP\" 15\n";
				print CONTENTS ".sp\n";
				print CONTENTS ".IP \"\\fBIndex\\fP\" 15\n";

	close(CONTENTS);
}
