: # use perl
        eval 'exec perl -S $0 "$@"'
                if $runnning_under_some_shell;

# Khoros: $Id$
# $Log$

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

#========================================================================
#
#  Program Name: kcrsum - creates a checksum file for object(s)
#
#       Purpose: The script will create a checksum file for every
#		 objects specified.  It will have the format:
# ! 
# ! {path to file relitive to toolbox}/{filename}:{SYSV checksum}:{# of 512 blocks}:{size in bytes}
# ! 
#
#		 If nothing specified on the command line than all
#		 toolboxes found in the files specified by KHOROS_TOOLBOX
#		 and all the objects within are checked.  You can specify
#		 multiple toolboxes by doing:
# !
# !                   % kcrsum -tb toolbox1,toolbox2
# !
#                You can specify multiple objects by doing, but the object
#                will have to be in every toolbox:
# !
# !                   % kcrsum -oname object1,object2
# !
#                If you combine the two options the objects specified must
#                be in every toolbox specified.
# !
# !                   % kcrsum -tb toolbox1,toolbox2 -oname object1,object2
# !
#
#		 If -version is specified than the checksum for the files
#                in the object are stored in that version.  The checksum
#		 for the object under that version by default is located
#		 in
#	 {toolbox}/objects/{object type}/{object}/db/{version}/{object}.cksum.
#		 Where {toolbox} is the path to the toolboxes' top directory,
#		 {object type} is library, script, kroutine, etc. and {object}
#		 is the object name.
#
#                If -dir is specified than the default checksum directory
#                is changed from {toolbox}/objects/{object type}/{object}/db
#		 to the directory specified.
#
#     Arguments: tb      - toolbox(es) to checksum
#                oname   - object(s) to checksum
#                version - version of checksum
#                dir     - directory to place checksum files in
#
#   Exit Status: 1 if failed, 0 on success
#
#      Comments:
#    Written By: John M. Salas, Neil Bowers, Steve Kubica and Mark Young
#          Date: Apr 1, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#========================================================================
@khoros_toolbox = ('KHOROS_TOOLBOX');
if (! eval("\$toolboxes = \$ENV{\"KHOROS_TOOLBOX\"}"))
{
   die "The KHOROS_TOOLBOX environment variable must be set.\n";
}

$notfound = 1;
@toolbox_list = split(':', $toolboxes);
foreach $toolbox_file (sort(@toolbox_list))
{
   if ( ! open(TBS,"<$toolbox_file"))
   {
      print "Can not open $toolbox_file.  Please check to make sure your\n";
      die   "KHOROS_TOOLBOX environment variable points to existing files.\n";
   }

   while(<TBS>)
   {
      chop($_);
      @line = split(':',$_);
      if ($line[0] eq "SUPPORT")
      {
         if ( $notfound )
         {
            $support_path = $line[1];
            $notfound = 0;
         }
         else
         {
            print "The SUPPORT toolbox is defined twice.  Please check your\n";
            print "KHOROS_TOOLBOX environment variable and the file(s)\n";
            print "pointed to by it and make sure that all toolboxes are\n";
            die   "only defined once.\n";
         }
      }
   }
}

if ( $notfound )
{
   print "The SUPPORT toolbox is not defined in any of the files pointed to\n";
   die   "by the environment variable KHOROS_TOOLBOX.\n";
}

@INC = ("$support_path/repos/perl", @INC);
require "khoros.pl";
require "stat.pl";

#
# list of directories which we can expect to see in the toplevel of a toolbox
#
%tbdirs = (     'bin',          'executables',
                'data',         'sample data files',
                'examples',     'example programs',
                'help',         'help files',
                'include',      'public includes',
                'lib',          'library files',
                'mach',         'multiple architecture shadow trees',
                'manual',       'toolbox manual(s)',
                'objects',      'objects live in here',
                'repos',        'toolbox file repository',
                'testsuite',    'testsuites for objects in this toolbox'
        );

$whatis         = 'creates a checksum file for object(s)';
@kcrsum_args  = (
   '[tb]',      'toolbox1[,toolbox2] ', 'name of toolbox(es) [all defined in KHOROS_TOOLBOX]',
   '[oname]',   'oname1[,oname2] ',     'name of object(s) [all in the toolbox]',
   '[version]', 'version', 'the version name of checksum [none]',
   '[dir]',     'dir',     'directory to place checksum files in [{toolbox}/objects/{object type}/{object}/db]',
);

#
# Initialize Khoros perl lib
#
&khoros'initialize("SUPPORT",$whatis,@kcrsum_args);

# parse command line args
&khoros'parse_args(@ARGV);

#
# Get the commandline.
#
$opt_t = $khoros'seenswitch{"tb"};
$opt_o = $khoros'seenswitch{"oname"};
$opt_v = $khoros'seenswitch{"version"};
$opt_d = $khoros'seenswitch{"dir"};

if ( $opt_v )
{
  $version = $khoros'argval{"version"};
}

#
# Set $dir to specified value or
# default {toolbox}/objects/{object type}/{object}/db.
#
if ( $opt_d )
{
  $dir = $khoros'argval{"dir"};
}
#
# Get the -tb option.  This option allows multiple toolboxes to be specified
# by doing -tb toolbox1,toolbox2.  If not specified all the toolboxes are
# checked.
#
if ($opt_t)
{
   $_ = &khoros'get_tb_name;
   tr/,/\ /;
   @toolbox = split(' ', $_);
   for ( $i = 0 ; $i <= $#toolbox ; $i++ )
   {
      chop($tbpath = `kecho -tb $toolbox[$i] -echo path`);
      if ( $? )
      {
         print "toolbox $toolbox[$i] does not exist\n";
	 exit(1);
      }
   }
}
else
{
   @toolbox = split(' ',`kecho -echo toolboxes`);
}


#
# Create checksum for each toolbox specified
#
TOOLBOX: foreach $tb (sort(@toolbox))
{
   print "$tb\n";

#
# Verify that toolbox exists in database
#
   chop($tbpath = `kecho -tb $tb -echo path`);
   unless ( -d $tbpath )
   {
      print "toolbox directory does not exist\n";
      next TOOLBOX;
   }
   else
   {
      chdir("$tbpath");
   }

#
# Get the -oname option.  This option allows multiple objects to be specified
# by doing -oname object1,object2.  If not specified all the objects in the
# toolbox are checked.
#
   if ($opt_o)
   {
      $_ = $khoros'argval{"oname"};
      tr/,/\ /;
      @objects = split(' ', $_);
      for ( $i = 0 ; $i <= $#objects ; $i++ )
      {
         chop($objectpath = `kecho -tb $tb -oname $objects[$i] -echo path`);
         if ( $? )
         {
            print "object $objects[$i] does not exist in $tb\n";
	    exit(1);
         }
      }
   }
   else
   {
      @objectsck = sort(split(' ',`kecho -tb $tb -echo objects`));
      @objects = sort(&ckobjects("$tbpath/objects"));
      if ( $#objectsck != $#objects ) 
      {
          print "\t>>> The objects in $tb do not match the database.\n\n";
          print "\t>>> Here is what kecho returns:\n\n";
          print "\t>>> @objectsck\n\n";
          print "\t>>> Here are the directories in the toolbox:\n\n";
          print "\t>>> @objects\n\n";
          print "\t>>> Please fix!\n";
          $exit_status = 1;
          next TOOLBOX;
      }
   }

#
# Check to see if checksum directory exists, if not create.
#
   if ( $opt_d )
   {
      if ( ! -d "$dir" )
      {
         if ( ! mkdir("$dir", 0777) )
         {
             print "Can not create checksum directory $dir: $!\n";
             exit (1);
         }
      }

      if ( $opt_v && ! -d "$dir/$version" )
      {
         if ( ! mkdir("$dir/$version", 0777) )
         {
             print "Can not create version checksum directory $tb/$dir/$version: $!\n";
             exit (1);
         }
      }
   }
#
# Check each object specified
#
   foreach $object (@objects)
   {
      print "     $object\n";

#
# Verify that object exists in database
#
      chop($objectpath = `kecho -tb $tb -oname $object -echo path`);
      if ( $? )
      {
         print "object $object does not exist in $tb\n";
	 exit(1);
      }

      $tbdir  = &determinetbdir("$tbpath");
      $objdir = &determineobjdir("$tbdir","$objectpath");
#
# Set the $dir variable if -dir not specified.
#
      if ( ! $opt_d )
      {
	 $dir    = "$objdir/db";

         if ( $opt_v && ! -d "$dir/$version" )
         {
            if ( ! mkdir("$dir/$version", 0777) )
            {
                print "Can not create version checksum directory $tb/$dir/$version: $!\n";
                exit (1);
            }
         }
      }

#
# Create checksum output file.
#
      if ( $opt_v && ! open(SUMOUT,">$dir/$version/$object.cksum") )
      {
         print "Can not open object checksum file $tb/$dir/$version/$object.cksum\n";
         exit (1);
      }
      elsif ( ! $opt_v && ! open(SUMOUT,">$dir/$object.cksum") )
      {
         print "Can not open object checksum file $tb/$dir/$object.cksum\n";
         exit (1);
      }

      @filesck = &sortfiles($objdir,split(' ',`kecho -tb $tb -oname $object -echo allfiles`));

#
# Calculate checksum for each file.
#
      for ( $i = 0 ; $i <= $#filesck ; $i++ )
      {
	 next if ( $filesck[$i] eq "$objdir/db/$object.cksum" );

	 if ( ! open(FILE,"<$filesck[$i]") )
         {
             print "Can not open object file $filesck[$i] for checking\n";
	     close(SUMOUT);
             exit (1);
         }
#
# Get checksum SYSV style.
#
	 $checksum = 0;
	 while (<FILE>)
	 {
	    $checksum += unpack("%32C*",$_);
	 }
	 $checksum = $checksum % 65535;
#
# Get blocks and size.
#
	 @stats = stat(FILE);
	 $st_size = @stats[$ST_SIZE];
	 $blocks = int($st_size / 512);
	 $blocks++ if ( $blocks );

         print SUMOUT "$filesck[$i]:$checksum:$blocks:$st_size\n";
	 close(FILE);
      }
      close(SUMOUT);
   }
}
exit($exit_status);

#------------------------------------------------------------------------
#
#  Routine Name: sortfiles - will parse the files passed on and remove the toolbox name
#
#       Purpose: To parse the files passed in and remove the toolbox name.
# !
# !              $KHOROS/objects/scripts/... will become objects/scripts/...
# !
#
#         Input: files - array of files to parse
#
#       Returns: list of parsed files
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Mar 10, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub sortfiles {

   local(@objdir) = shift;
   local(@files) = @_;
   local(@list);
   local($file);

   foreach $file (@files)
   {
      @parsed = split('/',$file);
      shift(@parsed);
      next if ( $parsed[$#parsed] eq 'Makefile' );
      $file = join("/",@parsed);
      push(@list,$file);
   }

#
#  Since kecho does not return the $object/Imakefile, put it on the list.
#
   push(@list,"$objdir/Imakefile");

   return sort(@list);
}


#------------------------------------------------------------------------
#
#  Routine Name: ckobjects - will return all objects found below directory passed in
#
#       Purpose: To check for directories that contain objects below the
#                directory passed in by the calling routine.  ., .., any
#                normal file, special files Makefile and Imakefile and the
#                directory bootstrap are ignored.
#
#         Input: tbpath - directory containing object directories
#
#       Returns: list of objects
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Mar 10, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub ckobjects {

      local($tbpath) = @_;
      local(@objects);

      opendir(OBJECTSDIR,"$tbpath") || die "can not open $tbpath\n";
      foreach $name ( sort readdir(OBJECTSDIR))
      {
         if ( $name ne "."         && $name ne ".."       &&
              $name ne "bootstrap" && -d "$tbpath/$name"  &&
              $name ne "Imakefile" && $name ne "Makefile" )
         {
            push(@objects, &recordobjects("$tbpath/$name"));
         }
      }
      closedir(OBJECTSDIR);
      return @objects;
}

#------------------------------------------------------------------------
#
#  Routine Name: recordobjects - will create an array of every directory in the directory passed in
#
#       Purpose: To create a list of every directory under the one passed
#                in by the calling routine.  Each directory is an object
#                of the toolbox.  ., .., any normal file and special files
#                like Makefile and Imakefile are ignored.
#
#         Input: typepath - directory to search for directories (objects)
#
#       Returns: list of directories (objects)
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Mar 10, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub recordobjects {

      local($typepath) = @_;
      local(@directories);

      opendir(TYPEDIR,$typepath) || die "can not open $typepath\n";
      foreach $name ( sort readdir(TYPEDIR))
      {
         next if ( $name eq '.' );
         next if ( $name eq '..' );
         next if ( $name eq 'Imakefile' );
         next if ( $name eq 'Makefile' );
         if ( -d "$typepath/$name" )
         {
            push(@directories,$name);
         }
      }
      closedir(TYPEDIR);
      return @directories;
}

#------------------------------------------------------------------------
#
#  Routine Name: determinetbdir -
#
#       Purpose:
#
#         Input: filename - file containing pack index
#
#       Returns: nothing
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 14, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub determinetbdir {
   local($tbpath) = @_[0];
   local(@enddir);

   @enddir = split('/',$tbpath);

   return("$enddir[$#enddir]");
}

#------------------------------------------------------------------------
#
#  Routine Name: determineobjdir -
#
#       Purpose:
#
#         Input: filename - file containing pack index
#
#       Returns: nothing
#
#        Status: Private Routine
#    Written By: John M Salas
#          Date: Apr 14, 1994
#      Verified:
#  Side Effects:
# Modifications:
#
#------------------------------------------------------------------------

sub determineobjdir {
   local($tbdir)   = @_[0];
   local($objdir)  = @_[1];
   local($i)       = 0;
   local($dir);
   local(@returndir);

   @dir = split('/',$objdir);

   while ( "$dir[$i]" ne "$tbdir" )
   {
      $i++;
   }

   $i++;
   while ( $i <= $#dir )
   {
      push(@returndir,$dir[$i]);
      $i++;
   }

   return(join("/",@returndir));
}


