 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for ksync
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "ksync.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - synchronize object database and any caches
|
|       Purpose: main program for ksync
|
|         Input:
|		char *clui_info->tb_string; {toolbox name}
|		int   clui_info->tb_flag; {TRUE if -tb specified}
|
|		char *clui_info->oname_string; {name of object in toolbox}
|		int   clui_info->oname_flag; {TRUE if -oname specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject		toolbox;
	kobject		object;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "SUPPORT");
	kexit_handler(ksync_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "SUPPORT", "ksync",
		ksync_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	ksync_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	toolbox = kcms_open_toolbox(clui_info->tb_string);
	if (toolbox == NULL)
	{
		kerror(NULL,"main()",
			"Failed to open toolbox `%s'",
			clui_info->tb_string);
		kexit(KEXIT_FAILURE);
	}

	object = kcms_open_cmobj(toolbox,clui_info->oname_string);
	if (object == NULL)
	{
		kcms_close(toolbox);
		kerror(NULL,"main()",
			"Failed to open object `%s' in toolbox `%s'",
			clui_info->oname_string,
			clui_info->tb_string);
		kexit(KEXIT_FAILURE);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	kcms_set_attribute(object,KCMS_CMOBJ_UPDATE_DB,
			(KCMS_UPDATE_SYNC | KCMS_UPDATE_CACHE));
/* -main_library_call_end */

/* -main_after_lib_call */
	kcms_close(object);
	kcms_close(toolbox);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: ksync_usage_additions
| 
|       Purpose: Prints usage additions in ksync_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ksync
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void ksync_usage_additions(void)
{
	kfprintf(kstderr, "\tsynchronize object database and any caches\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: ksync_free_args
| 
|       Purpose: Frees CLUI struct allocated in ksync_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname ksync
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
ksync_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->tb_string);
	kfree(clui_info->oname_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
