 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kgentbindex
   >>>> 
   >>>>    Written By: 
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kgentbindex_h_
#define _kgentbindex_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <support.h>

/* -include_includes */
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
#define		ASCIICAP_A	65
#define		ASCIICAP_Z	90
/* -include_defines_end */

#define PANEPATH "$SUPPORT/objects/kroutine/kgentbindex/uis/kgentbindex.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*----- required ME group ----*/
/*
 *  Generates Index for all toolbox manuals (optional flag)
 */
int	 alltb_flag;  	/* Generates Index for all toolbox manuals FLAG */

/*
 *  Generate a manual index for a single toolbox (optional string)
 */
char	*tb_string;	/* Generate a manual index for a single toolbox STRING */
int	 tb_flag;   	/* Generate a manual index for a single toolbox FLAG */

/*-- required ME group end ---*/

} clui_info_struct;

/* -include_typedefs */
typedef struct _ChapterInfo
{
	char			*chapter_name;
	char			*chapter_path;
	struct _ChapterInfo	*next;
	struct _ChapterInfo	*prev;
} ChapterInfo;

typedef struct _VolumeInfo
{
	char			*volume_name;
	char			*volume_path;
	int			num_chapters;
	ChapterInfo		*ChapterInfoPtr;
	struct _VolumeInfo	*next;
	struct _VolumeInfo	*prev;		
} VolumeInfo;

typedef struct _ToolboxInfo
{
	char			*toolbox_name;
	char			*toolbox_path;
	int			num_manual_vols;
	VolumeInfo		*VolInfoPtr;
	struct _ToolboxInfo	*next;
	struct _ToolboxInfo	*prev;
} ToolboxInfo;
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kgentbindex_get_args PROTO((kform *));
void kgentbindex_usage_additions PROTO((void));
void kgentbindex_free_args PROTO((int, kaddr));

/* -include_routines */
int  process_cmd_line   PROTO((void));
int  process_all_tbs    PROTO((void));
char **get_list_of_tbs  PROTO((int *));
char **get_manual_vols  PROTO((int *, char *));
char **get_volume_chapters PROTO((int *, char *));
/* -include_routines_end */

#endif
