 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kgenman.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kgenman_get_args
| 
|       Purpose: Gets command line args for kgenman
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgenman
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgenman_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kgenman is out of sync with arguments specified in kgenman's *.pane file; please rerun ghostwriter on kgenman.";


	/*
	 * allocate the kgenman structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_string(pane, "tb",
			  &(clui_info->tb_string),
			  &(clui_info->tb_flag))))
	{
	    kerror(NULL, "kgenman_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "lib",
			  &(clui_info->lib_string),
			  &(clui_info->lib_flag))))
	{
	    kerror(NULL, "kgenman_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "section",
			  &(clui_info->section_string),
			  &(clui_info->section_flag))))
	{
	    kerror(NULL, "kgenman_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "dir",
			  &(clui_info->dir_string),
			  &(clui_info->dir_flag))))
	{
	    kerror(NULL, "kgenman_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "install",
			  &(clui_info->install_flag))))
	{
	    kerror(NULL, "kgenman_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "list",
			  &(clui_info->list_flag))))
	{
	    kerror(NULL, "kgenman_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "all",
			  &(clui_info->all_flag))))
	{
	    kerror(NULL, "kgenman_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "i",
			  &(clui_info->i_string),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "kgenman_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



