 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kgenman
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kgenman.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - generate man page(s) for a software object
|
|       Purpose: main program for kgenman
|
|         Input:
|		char *clui_info->tb_string; {toolbox the library belongs to}
|		int   clui_info->tb_flag; {TRUE if -tb specified}
|
|		char *clui_info->lib_string; {library to generate man pages for}
|		int   clui_info->lib_flag; {TRUE if -lib specified}
|
|		Required M.E. group:
|		    char *clui_info->dir_string; {generate and install in the directory specified}
|		    int   clui_info->dir_flag; {TRUE if -dir specified}
|
|		    int clui_info->install_flag; {TRUE if -install specified}
|
|		    int clui_info->list_flag; {TRUE if -list specified}
|
|		Required M.E. group:
|		    int clui_info->all_flag; {TRUE if -all specified}
|
|		    char *clui_info->i_string; {input source code file}
|		    int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->section_string; {Man section to put the man page into}
|		int   clui_info->section_flag; {TRUE if -section specified}
|
|        Output:
|       Returns:
|
|    Written By: Steven Jorgensen
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
    kobject toolbox;
    kobject library;
    header_info *header;
    char install_path[KLENGTH];
    char *path;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "SUPPORT");
	kexit_handler(kgenman_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "SUPPORT", "kgenman",
		kgenman_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kgenman_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
    if (clui_info->tb_string == NULL)
      {
	errno = KNULL_PARAMETER;
	kerror(NULL, NULL, "Toolbox parameter is NULL.  This is illegal\n");    
	kexit(KEXIT_FAILURE);
      }

    if (clui_info->lib_string == NULL)
      {
	errno = KNULL_PARAMETER;
	kerror(NULL, NULL, "Libraray parameter is NULL.  This is illegal\n");    
	kexit(KEXIT_FAILURE);
      }

    if (clui_info->section_string != NULL)
      kinfo(KSTANDARD,
	"This feature is not implemented. This parameter will be ignored\n");

    if (clui_info->dir_flag == TRUE &&
	kaccess(clui_info->dir_string, W_OK) != 0)
      {
	errno = KINVALID_PARAMETER;
	kerror(NULL, NULL, "Cannot access directory '%s'",
	(clui_info->dir_string == NULL) ? "(NULL)" : clui_info->dir_string);
	kexit(KEXIT_FAILURE);
      }

    if ((toolbox = kcms_open_toolbox(clui_info->tb_string)) == NULL)
      {
	kerror(NULL,"main()","Unable to open toolbox object '%s'\n",
	                  clui_info->tb_string);
        kexit(KEXIT_FAILURE);
      }

    if ((library = kcms_open_cmobj(toolbox, clui_info->lib_string)) == NULL)
      {
	kerror(NULL,"main()","Unable to open object '%s'",
		clui_info->lib_string);
	kcms_close(toolbox);
	kexit(KEXIT_FAILURE);
      }

    if (clui_info->i_flag == TRUE)
      if (kcms_set_attribute(library, KCMS_CMOBJ_FILENAME,
			     clui_info->i_string) == FALSE)
	{
	  kerror(NULL,"main()",
		"The file '%s' is not a part of the object '%s'",
			   clui_info->i_string, clui_info->lib_string);
	  kexit(KEXIT_FAILURE);
	}

    if (clui_info->install_flag == TRUE)
      {
	(void) kcms_get_attribute(library, KCMS_CMOBJ_OPATH, &path);
	ksprintf(install_path,"%s/cat", path);
	if (kmkdir(install_path, 0777) != 0 && errno != EEXIST)
	  {
	    kcms_close(toolbox);
	    kerror(NULL, NULL, "Cannot create install directory '%s'\n",
		   install_path);
	    kexit(KEXIT_FAILURE);
	  }
	ksprintf(install_path,"%s/man", path);
	if (kmkdir(install_path, 0777) != 0 && errno != EEXIST)
	  {
	    kcms_close(toolbox);
	    kerror(NULL, NULL, "Cannot create install directory '%s'\n",
		   install_path);
	    kexit(KEXIT_FAILURE);
	  }
      }
    else
      kstrcpy(install_path, clui_info->dir_string);
/* -main_before_lib_call_end */

/* -main_library_call */
    while (kcms_get_attribute(library, KCMS_CMOBJ_HEADERINFO, &header) != FALSE)
      {
	if (clui_info->list_flag)
	  kinfo(KFORCE, "%s", header->name);
	else if (kgen_generate_manpage(library, header, install_path) == FALSE)
	  kinfo(KSTANDARD, "An Error occurred while installing the man page for '%s' in '%s/%s'.  Continuing with the next man page.\n", header->name, install_path, header->name);
        else
	  kinfo(KSTANDARD, "Finished Generating a man page for the function '%s' in '%s/%s'\n", header->name, install_path, header->name);
      }
/* -main_library_call_end */

/* -main_after_lib_call */
    kcms_close(library);
    kcms_close(toolbox);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kgenman_usage_additions
| 
|       Purpose: Prints usage additions in kgenman_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgenman
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgenman_usage_additions(void)
{
	kfprintf(kstderr, "\tgenerate man page(s) for a software object\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kgenman_free_args
| 
|       Purpose: Frees CLUI struct allocated in kgenman_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgenman
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kgenman_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->tb_string);
	kfree(clui_info->lib_string);
	kfree(clui_info->dir_string);
	kfree(clui_info->section_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
