 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Diff Objects
   >>>>
   >>>>   Static:
   >>>>  Private:
   >>>>             generate_diffobj()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "kdiffobj.h"


/*-----------------------------------------------------------
|
|  Routine Name: generate_files - generate the files to be diffed
|
|       Purpose: This routine does the actual work of creating the
|		 list of files to be diffed.
|
|         Input: program   - the object to generate the list of files for
|        Output: num	   - the number of files in the list
|       Returns: the list on success, NULL otherwise
|
|    Written By: Mark Young
|          Date: Sep 18, 1993
| Modifications:
|
------------------------------------------------------------*/

static char **generate_files(
   kobject program,
   int     *num)
{
	kobject fileobj;
	klist *list = NULL;
	int   type, numfiles = 0;
	char  *path, **files = NULL;


	kcms_get_attribute(program, KCMS_CMOBJ_ALL_FILES, &list);
	while (list != NULL)
	{
	   fileobj = klist_clientdata(list);
	   kcms_get_attribute(fileobj, KCMS_FOBJ_TYPE, &type);
	   if (type != KCMS_FOBJ_TYPE_DBM &&
	       type != KCMS_FOBJ_TYPE_MAN &&
	       type != KCMS_FOBJ_TYPE_CONFIG &&
	       type != KCMS_FOBJ_TYPE_HELP)
	   {
	      path = NULL;
	      kcms_get_attribute(fileobj, KCMS_FOBJ_FULLNAME, &path);
	      if (path != NULL)
		 files = karray_add(files, kstrdup(path), numfiles++);
	   }
	   list = klist_next(list);
	}
	files = karray_sort(files, numfiles, TRUE);
	*num = numfiles;
	return(files);
}


/*-----------------------------------------------------------
|
|  Routine Name: generate_imakefile - generate diff object
|
|       Purpose: This routine performs the actually diffing of the objects.
|		 This is done by getting the list of files returned from
|		 generate files.  The list are then 
|
|         Input: tbname - the toolbox name
|                oname  - the object name in which we are to re-gen the
|			  Imakefile
|		 dir_flag - if this is not an object, but a directory imakefile
|        Output: 
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Sep 10, 1993
| Modifications:
|
------------------------------------------------------------*/

int generate_diffobj(
   char *tbname1,
   char *tbname2,
   char *oname)
{
	kobject tb1 = NULL, tb2 = NULL, obj1 = NULL, obj2 = NULL;
	int	i, status, value, indx1, indx2, num1, num2, num = 0;
	char    **files1, **files2, **list1 = NULL, **list2 = NULL,
		**list = NULL, *tmp, temp1[KLENGTH], temp2[KLENGTH],
		*tmp1, *tmp2, temp[KLENGTH], **sub1 = NULL, **sub2 = NULL;


	if ((tb1 = kcms_open_toolbox(tbname1)) == NULL ||
	    (tb2 = kcms_open_toolbox(tbname2)) == NULL)
	{
	   kinfo(KSTANDARD, "Warning: Cannot open toolbox object '%s'\n",
			(!tb1) ? tbname1 : tbname2);
	   kexit(1);
	}

	if ((obj1 = kcms_open_cmobj(tb1, oname)) == NULL ||
	    (obj2 = kcms_open_cmobj(tb2, oname)) == NULL)
	{
	   kinfo(KSTANDARD, "Warning: Cannot open program object '%s' for \
toolbox '%s'\n", oname, (!obj1) ? tbname1 : tbname2);
	   kexit(1);
	}

	files1 = generate_files(obj1, &num1);
	files2 = generate_files(obj2, &num2);
	if (!files1 || !files2)
	{
	   kinfo(KSTANDARD, "\nDiff'ing '%s' for toolboxes '%s' and '%s'\n\n \
\tNo files found for toolbox '%s'", oname, tbname1, tbname2,
		!files1 ? tbname1 : tbname2);
	   return(FALSE);
	}

	/*
	 *  Build the substitution list so that when comparing two files, we
	 *  don't find difference on the toolbox name.  What we need to do is
	 *  exclude the following differences:
	 *
	 *	"toolboxname"
	 */
	ksprintf(temp1, "\"%s\"", tbname1); ksprintf(temp2, "\"%s\"", tbname2);
	sub1 = karray_add(sub1, kstrdup(temp1), 0);
	sub2 = karray_add(sub2, kstrdup(temp2), 0);
	sub1 = karray_add(sub1, kstring_lower(temp1, NULL), 1);
	sub2 = karray_add(sub2, kstring_lower(temp2, NULL), 1);
	sub1 = karray_add(sub1, kstring_upper(temp1, NULL), 2);
	sub2 = karray_add(sub2, kstring_upper(temp2, NULL), 2);
	ksprintf(temp1, "$%s/", tbname1); ksprintf(temp2, "$%s/", tbname2);
	sub1 = karray_add(sub1, kstring_lower(temp1, NULL), 3);
	sub2 = karray_add(sub2, kstring_lower(temp2, NULL), 3);
	sub1 = karray_add(sub1, kstring_upper(temp1, NULL), 4);
	sub2 = karray_add(sub2, kstring_upper(temp2, NULL), 4);

	indx1 = indx2 = 0;
	while (indx1 < num1 || indx2 < num2)
	{
	    /*
	     *  Set the tmp1 & tmp2 pointers to be empty.  We use these
	     *  pointers to hold the filenames in which we will perform
	     *  the comparisons.
	     */
	    tmp1 = tmp2 = "";

	    /*
	     *  If there are remaining files from the first object, then
	     *  initialize tmp1 & temp1 to point to it.
	     */
	    if (indx1 < num1)
	    {
	       tmp1 = kstrchr(files1[indx1], '/');
	       kbasename(files1[indx1], temp1);
	    }

	    /*
	     *  If there are remaining files from the second object, then
	     *  initialize tmp2 & temp2 to point to it.
	     */
	    if (indx2 < num2)
	    {
	       tmp2 = kstrchr(files2[indx2], '/');
	       kbasename(files2[indx2], temp2);
	    }

	    /*
	     *  See if we are looking at the same file.  If so then we can
	     *  check to see if the files are different.  If they are not
	     *  the same then we want to automatically put the file on the
	     *  appropriate list and indicate that it doesn't exist in the
	     *  other toolbox.
	     */
	    status = kstrcmp(tmp1, tmp2);
	    if (status == 0)
	    {
	       kinfo(KDEBUG,"Diff'ing files: '%s' '%s'", files1[indx1],
			   files2[indx2]);
	       if (!ksedfile(files1[indx1], files2[indx2], FALSE, KFILE_QUERY,
		       &status, sub1[0], sub2[0], sub1[1], sub2[1],
		       sub1[2], sub2[2], sub1[3], sub2[3], sub1[4], sub2[4],
		       NULL) ||
		   status == TRUE)
	       {
	          tmp = kstring_copy(temp1, NULL);
	          list1 = karray_add(list1, (kaddr) files1[indx1], num);
	          list2 = karray_add(list2, (kaddr) files2[indx2], num);
	          list = karray_add(list, (kaddr) tmp, num++);
	       }
	       indx1++; indx2++;
	    }
	    else if (kstrlen(tmp1) != 0 && (status < 0 || kstrlen(tmp2) == 0))
	    {
	       list1 = karray_add(list1, (kaddr) files1[indx1], num);
	       list2 = karray_insert(list2, (kaddr) NULL, num, KLIST_TAIL,TRUE);

	       ksprintf(temp,"\t%s (exists only in '%s')", temp1, tbname1);
	       tmp = kstring_copy(temp, NULL);
	       list = karray_add(list, (kaddr) tmp, num++);
	       indx1++;
	    }
	    else
	    {
	       list1 = karray_insert(list1, (kaddr) NULL, num, KLIST_TAIL,TRUE);
	       list2 = karray_add(list2, (kaddr) files2[indx2], num);

	       ksprintf(temp,"\t%s (exists only in '%s')", temp2, tbname2);
	       tmp = kstring_copy(temp, NULL);
	       list = karray_add(list, (kaddr) tmp, num++);
	       indx2++;
	    }
	}
	kcms_close(obj1); kcms_close(tb1);
	kcms_close(obj2); kcms_close(tb2);

	if (num == 0)
	{
	   kinfo(KSTANDARD, "\nDiff'ing '%s' for toolboxes '%s' and '%s'\n\n \
\tNo files found to be different", oname, tbname1, tbname2);
	   return(TRUE);
	}

	i = -1;
	value = 0;
	do
	{
	    ksystem("clear");
	    if (i == -1)
	    {
	       kinfo(KSTANDARD, "\nDiff'ing '%s' for toolboxes '%s' and '%s'\n",
		oname, tbname1, tbname2);

	       if (value >= num) value = 0;
	       kchoose(KFORCE, list, num, value+1, NULL, &i,
			"Toolbox: '%s' '%s'", tbname1, tbname2);
	    }
	    value = i;

	    if (i != 0)
	    {
	       if (list1[i-1] != NULL && list2[i-1])
	       {
		   kprintf("\nDiff'ing files: '%s' '%s'\n\n", list1[i-1],
			   list2[i-1]);
	           ksprintf(temp, "diff %s %s | more", list1[i-1], list2[i-1]);
	           ksystem(temp);
		}
		else
		{
		   if (!list1[i-1])
		      kprintf("%s is only available in toolbox '%s'\n",
				list2[i-1], tbname2);
		   else
		      kprintf("%s is only available in toolbox '%s'\n",
				list1[i-1], tbname1);
		}

	        /* CONSTCOND */
	        while (1)
	        {
	           kprintf("\n\nEnter a number of the next file to diff or:\n");
		   kprintf("<   file %s from %s to %s\n", list[i-1],
			tbname1, tbname2);
		   kprintf(">   file %s from %s to %s\n", list[i-1],
			tbname2, tbname1);
		   kprintf("r to REPEAT DIFF   <cr> for FILE LIST   q to \
QUIT...  ");
	           kgets(temp);
	           kstring_cleanup(temp, temp);

		   if (kstrlen(temp) == 0)
		   {
		      i = -1;
		      break;
		   }
	           else if (kstrcmp(temp, "q") == 0)
		   {
		      i = 0;
		      break;
		   }
	           else if (kstrcmp(temp, "r") == 0)
		   {
		      ksystem("clear");
		      kprintf("Diff'ing files: '%s' '%s'\n\n", list1[i-1],
				list2[i-1]);
		      ksprintf(temp, "diff %s %s | more",list1[i-1],list2[i-1]);
	              ksystem(temp);
		   }
	           else if (kstrcmp(temp, ">") == 0)
		   {
		     if (koverwrite(KFORCE, list1[i-1]) == TRUE)
		        ksedfile(list2[i-1], list1[i-1], FALSE, KFILE_OVERWRITE,
			    NULL, sub2[0], sub1[0], sub2[1], sub1[1],
		            sub2[2], sub1[2], sub2[3], sub1[3], sub1[4],
			    sub2[4], NULL);
		   }
	           else if (kstrcmp(temp, "<") == 0)
		   {
		     if (koverwrite(KFORCE, list2[i-1]) == TRUE)
		        ksedfile(list1[i-1], list2[i-1], FALSE, KFILE_OVERWRITE,
			    NULL, sub1[0], sub2[0], sub1[1], sub2[1],
		            sub1[2], sub2[2], sub1[3], sub2[3], sub1[4],
			    sub2[4], NULL);
		   }
	           else if (ksscanf(temp," %d", &value) == 1 && value >= 0
			    && value <= num)
		   {
		      i = value;
		      break;
		   }
	           else
		   {
		      kinfo(KSTANDARD,"\nInvalid selection... '%s'\n\n", temp);
		   }
	        }
	    }
	} while (i != 0);
	return(TRUE);
}
