eval 'exec perl -S $0 $*'
                if $runnning_under_some_shell;

#========================================================================
# Program Name: ksetpaneobj - no short description specified
# Purposed:	long description goes here
#
# RCS ID:	Khoros: $Id$
# RCS Log:	$Log$
#========================================================================

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.


if (! defined $ENV{'KHOROS_TOOLBOX'})
{
   die "The KHOROS_TOOLBOX environment variable must be set.\n";
}

$notfound = 1;
foreach $toolbox_file (sort split(/:/, $ENV{'KHOROS_TOOLBOX'}))
{
   open(TBS,"<$toolbox_file") || do
   {
      warn "Can not open $toolbox_file.  Please check to make sure your\n";
      die  "KHOROS_TOOLBOX environment variable points to existing files.\n";
   };

   while (<TBS>)
   {
      chop($_);
      @line = split(':',$_);
      if ($line[0] eq "SUPPORT")
      {
         if ( $notfound )
         {
            $support_path = $line[1];
            $notfound = 0;
         }
         else
         {
            warn "The SUPPORT toolbox is defined twice.  Please check your\n";
            warn "KHOROS_TOOLBOX environment variable and the file(s)\n";
            warn "pointed to by it and make sure that all toolboxes are\n";
            die  "only defined once.\n";
         }
      }
   }
}

if ( $notfound )
{
   print "The SUPPORT toolbox is not defined in any of the files pointed to\n";
   die   "by the environment variable KHOROS_TOOLBOX.\n";
}


@INC = ("$support_path/repos/perl", @INC);
require "khoros.pl";
require "kutils.pl";

$whatis = 'set associated object for pane object(s)';
@clui_args  = (
        '[tb]',     'toolbox',      'name of toolbox',
        '[oname]',  'object-name',  'name of software object'
);

# initialize Khoros perl lib
&khoros'initialize("MIGRATION",$whatis,@clui_args);

&khoros'parse_args(@ARGV);                   # parse the command-line

# ------------------------------------------------------------------------
# Put your code here
# ------------------------------------------------------------------------

if ($khoros'seenswitch{'tb'} && $khoros'seenswitch{'oname'})
{
   &SetPaneObject($khoros'argval{'tb'}, $khoros'argval{'oname'});
   exit 0;
}

@toolboxes = &khoros'get_toolbox_list();
foreach $toolbox (@toolboxes)
{
   print STDERR "Toolbox: $toolbox\n";
   chop($objlist = `kecho -tb $toolbox -type pane -echo objects`);
   foreach $object (split(/\s+/, $objlist))
   {
      &SetPaneObject($toolbox, $object);
   }
}

sub SetPaneObject
{
   local($toolbox, $object) = @_;
   local($TOOLBOX);
   local($tbpath);
   local($filepath);
   local(*PANE);


   print STDERR "    Object: $object\n";
   $TOOLBOX = "\U$toolbox";
   $tbpath  = $khoros'toolboxPath{$TOOLBOX};
   $filepath = "$tbpath/objects/pane/$object/uis/$object.pane";
   unless (-f $filepath)
   {
      warn "\tpane file for $TOOLBOX::$object not found ($filepath)\n";
      return;
   }

   open(PANE, "< $filepath") || do
   {
      warn "\tunable to read pane for $TOOLBOX::$object ($filepath)\n";
      return;
   };

   while (<PANE>)
   {
      if (/^\s*-R\s+\d\s+\d\s+\d\s+\S+\s+'[^']+'\s+'[^']+'\s+(.*)/)
      {
         $cmd = $1;
         if ($cmd =~ /\$([A-Z]+)BIN\/(\S+)\s*(.*)$/)
         {
            $atb = $1;
            $aoname = $2;
            $aargs = $3;
            print STDERR "\tAssociated Toolbox: $atb\n";
            print STDERR "\tAssociated Object:  $aoname\n";
            print STDERR "\tAssociated Args:    $aargs\n";
            system("kset -tb $toolbox -oname $object -atb $atb -aoname $aoname -aargs \"$aargs\" 2>&1 | sed -e 's/^/\t/'");
         }
         last;
      }
   }
   close PANE;
}
