#=========================================================================
# This file contains a table, where each line contains directions
# on how to execute commands to convert from an older version of Khoros
# to a newer version of Khoros.  The first column is the version you
# should be at currently before applying the migration program.  The section
# column is the version you should be at after applying the command.
# The third column is a list of objects to apply the migration program to
# '*' stands for run on all toolbox objects, '*::*' stands for run on all
# objects in all toolboxes, 'tb1,tb2::*' stands for run on all objects
# in toolboxes tb1 and tb2, '*::obj1,obj2' stands for run on all objects
# called obj1 and obj2 in any toolbox, 'tb1,tb2' stands for run on toolbox
# objects tb1 and tb2, and 'tb1,tb2::obj1,obj2' stands for run on objects
# obj1 and obj2 in both toolboxes tb1 and tb2.  The fourth column is
# the command to run, followed by the commandline arguments.  It will
# substitute the toolbox name for %tbname%, the object name for %oname%,
# and the object type for %type%.  Any line beginning with a '#' is ignored
# assumed to be a comment.
#=========================================================================
#-- Run these programs in order to upgrade fom 2.0.1 to 2.0.2
2.0.1	2.0.2	*		$MIGRATION/bin/kuptbdef -tb %tbname%
2.0.1	2.0.2	*		$MIGRATION/bin/ktbupdb -tb %tbname%
2.0.1	2.0.2	*		$MIGRATION/bin/kmigimake -tb %tbname%
2.0.1	2.0.2	*		$MIGRATION/bin/ksetpaneobj -tb %tbname%
