 /*
  * Khoros: $Id$
  */
 
#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif
 
 /*
  * $Log$
  */
 
/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "mkproto.h"

int inquote = 0;        /* in a quote?? */
int newline_seen = 1;   /* are we at the start of a line */
long linenum  = 1L;     /* line number in current file */
int glastc   = ' ';     /* last char. seen by getsym() */

/*
 * Routines for manipulating lists of words.
 */

Word *word_alloc(char *s)

{
	Word *w;

	w = (Word *) kmalloc(sizeof(Word) + kstrlen(s) + 1); /* ++jrb */
	kstrcpy(w->string, s);
	w->next = NULL;
	return w;
}

void word_free(Word *w)
{
	Word *oldw;
	while (w) {
		oldw = w;
		w = w->next;
		kfree(oldw);
	}
}

/* return the length of a list; empty words are not counted */
int
List_len(Word *w)
{
	int count = 0;

	while (w) {
		if (*w->string) count++;
		w = w->next;
	}
	return count;
}

/* Append two lists, and return the result */

Word *word_append(Word *w1, Word *w2)
{
	Word *r, *w;

	r = w = word_alloc("");

	while (w1) {
		w->next = word_alloc(w1->string);
		w = w->next;
		w1 = w1->next;
	}
	while (w2) {
		w->next = word_alloc(w2->string);
		w = w->next;
		w2 = w2->next;
	}

	return r;
}
	
/* see if the last entry in w2 is in w1 */

int
foundin(Word *w1, Word *w2)
{
	while (w2->next)
		w2 = w2->next;

	while (w1) {
		if (!kstrcmp(w1->string, w2->string))
			return 1;
		w1 = w1->next;
	}
	return 0;
}

/* add the string s to the given list of words */

void addword(Word *w, char *s)
{
	if (kstrlen(s) == 0)
	   return;

	while (w->next) w = w->next;
	w->next = word_alloc(s);
}

/* given a list representing a type and a variable name, extract just
 * the base type, e.g. "struct word *x" would yield "struct word"
 */

Word *typelist(Word *p)
{
	Word *w, *r;

	r = w = word_alloc("");
	while (p && p->next) {
		if (p->string[0] && !ISCSYM(p->string[0]))
			break;
		w->next = word_alloc(p->string);
		w = w->next;
		p = p->next;
	}
	return r;
}

/* typefixhack: promote formal parameters of type "char", "unsigned char",
   "short", or "unsigned short" to "int".
*/

void typefixhack(Word *w)
{
	Word *oldw = 0;

	while (w) {
		if (*w->string) {
			if ( (!kstrcmp(w->string, "char") ||
			      !kstrcmp(w->string, "short") )
			    && (List_len(w->next) < 2) )
			{
				if (oldw && !kstrcmp(oldw->string, "unsigned")) {
					oldw->next = w->next;
					kfree(w);
					w = oldw;
				}
				kstrcpy(w->string, "int");
			}
		}
		w = w->next;
	}
}

/* read a character: if it's a newline, increment the line count */

int ngetc(kfile *f)
{
	int c;

	c = kgetc(f);
	if (c == '\n') linenum++;

	return c;
}

/* read the next character from the file. If the character is '\' then
 * read and skip the next character. Any comment sequence is converted
 * to a blank.
 */

int fnextch(kfile *f)
{
	int c, lastc, incomment;

	c = ngetc(f);
	while (c == '\\') {
DEBUG("fnextch: in backslash loop\n");
		c = ngetc(f);	/* skip a character */
		c = ngetc(f);
	}
	if (c == '/' && !inquote) {
		c = ngetc(f);
		if (c == '*') {
			incomment = 1;
			c = ' ';
DEBUG("fnextch: comment seen\n");
			while (incomment) {
				lastc = c;
				c = ngetc(f);
				if (lastc == '*' && c == '/')
					incomment = 0;
				else if (c < 0)
					return c;
			}
			return fnextch(f);
		}
		else {
			if (c == '\n') linenum--;
			kungetc(c, f);
			return '/';
		}
	}
	return c;
}


/* Get the next "interesting" character. Comments are skipped, and strings
 * are converted to "0". Also, if a line starts with "#" it is skipped.
 */

int nextch(kfile *f)
{
	int c;

	c = fnextch(f);
	if (newline_seen && c == '#') {
		do {
			c = fnextch(f);
		} while (c >= 0 && c != '\n');
		if (c < 0)
			return c;
	}
	newline_seen = (c == '\n');

	if (c == '\'' || c == '\"') {
DEBUG("nextch: in a quote\n");
		inquote = c;
		while ( (c = fnextch(f)) >= 0 ) {
			if (c == inquote) {
				inquote = 0;
DEBUG("nextch: out of quote\n");
				return '0';
			}
		}
DEBUG("nextch: EOF in a quote\n");
	}
	return c;
}

/*
 * Get the next symbol from the file, skipping blanks.
 * Return 0 if OK, -1 for EOF.
 * Also collapses everything between { and }
 */

int
getsym(char *buf, kfile *f)
{
	register int c;
	int inbrack = 0;

DEBUG("in getsym\n");
	c = glastc;
	while ((c > 0) && isspace(c)) {
		c = nextch(f);
	}
DEBUG("getsym: spaces skipped\n");
	if (c < 0) {
DEBUG("EOF read in getsym\n");
		return -1;
	}
	if (c == '{') {
		inbrack = 1;
DEBUG("getsym: in bracket\n");
		while (inbrack) {
			c = nextch(f);
			if (c < 0) {
DEBUG("getsym: EOF seen in bracket loop\n");
				glastc = c;
				return c;
			}
			if (c == '{') inbrack++;
			else if (c == '}') inbrack--;
		}
		kstrcpy(buf, "{}");
		glastc = nextch(f);
DEBUG("getsym: out of in bracket loop\n");
		return 0;
	}
	if (!ISCSYM(c)) {
		*buf++ = (char) c;
		*buf = 0;
		glastc = nextch(f);
DEBUG("getsym: returning special symbol\n");
		return 0;
	}
	while (ISCSYM(c)) {
		*buf++ = c;
		c = nextch(f);
	}
	*buf = 0;
	glastc = c;
DEBUG("getsym: returning word\n");
	return 0;
}

/*
 * skipit: skip until a ";" or the end of a function declaration is seen
 */
int skipit(char *buf, kfile *f)
{
	int i;

	do {
DEBUG("in skipit loop\n");
		i = getsym(buf, f);
		if (i < 0) return i;
	} while (*buf != ';' && *buf != '{');

	return 0;
}

/*
 * Get a parameter list; when this is called the next symbol in line
 * should be the first thing in the list.
 */

Word *getparamlist(kfile *f)
{
	static Word *pname[MAXPARAM]; /* parameter names */
	Word	*tlist,		/* type name */
		*plist;		/* temporary */
	int  	np = 0;		/* number of parameters */
	int  	typed[MAXPARAM];  /* parameter has been given a type */
	int	tlistdone;	/* finished finding the type name */
	int	sawsomething;
	int  	i;
	int	inparen = 0;
	char buf[80];

DEBUG("in getparamlist\n");
	for (i = 0; i < MAXPARAM; i++)
		typed[i] = 0;

	plist = word_alloc("");

/* first, get the stuff inside brackets (if anything) */

	sawsomething = 0;	/* gets set nonzero when we see an arg */
	for (;;) {
		if (getsym(buf, f) < 0) return NULL;
		if (*buf == ')' && (--inparen < 0)) {
			if (sawsomething) {	/* if we've seen an arg */
				pname[np] = plist;
				plist = word_alloc("");
				np++;
			}
			break;
		}
		if (*buf == ';') {	/* something weird */
			return ABORTED;
		}
		sawsomething = 1;	/* there's something in the arg. list */
		if (*buf == ',' && inparen == 0) {
			pname[np] = plist;
			plist = word_alloc("");
			np++;
		}
		else {
			addword(plist, buf);
			if (*buf == '(') inparen++;
		}
	}

/* next, get the declarations after the function header */

	inparen = 0;

	tlist = word_alloc("");
	plist = word_alloc("");
	tlistdone = 0;
	sawsomething = 0;
	for(;;) {
		if (getsym(buf, f) < 0) return NULL;

/* handle a list like "int x,y,z" */
		if (*buf == ',' && !inparen) {
			if (!sawsomething)
				return NULL;
			for (i = 0; i < np; i++) {
				if (!typed[i] && foundin(plist, pname[i])) {
					typed[i] = 1;
					word_free(pname[i]);
					pname[i] = word_append(tlist, plist);
				/* promote types */
					typefixhack(pname[i]);
					break;
				}
			}
			if (!tlistdone) {
				tlist = typelist(plist);
				tlistdone = 1;
			}
			word_free(plist);
			plist = word_alloc("");
		}
/* handle the end of a list */
		else if (*buf == ';') {
			if (!sawsomething)
				return ABORTED;
			for (i = 0; i < np; i++) {
				if (!typed[i] && foundin(plist, pname[i])) {
					typed[i] = 1;
					word_free(pname[i]);
					pname[i] = word_append(tlist, plist);
					typefixhack(pname[i]);
					break;
				}
			}
			tlistdone = 0;
			word_free(tlist); word_free(plist);
			tlist = word_alloc("");
			plist = word_alloc("");
		}
/* handle the  beginning of the function */
		else if (!kstrcmp(buf, "{}")) break;
/* otherwise, throw the word into the list (except for "register") */
		else if (kstrcmp(buf, "register")) {
			sawsomething = 1;
			addword(plist, buf);
			if (*buf == '(') inparen++;
			if (*buf == ')') inparen--;
		}
	}

/* Now take the info we have and build a prototype list */

/* empty parameter list means "void" */
	if (np == 0)
		return word_alloc("void");

	plist = tlist = word_alloc("");
	for (i = 0; i < np; i++) {

/* If no type provided, make it an "int" */
		if ( (!(pname[i]->next) && kstrcmp(pname[i]->string, "kvalist")) ||
	   (!(pname[i]->next->next)&&kstrcmp(pname[i]->next->string, "void"))) {
			addword(tlist, "int");
		}
		while (tlist->next) tlist = tlist->next;
		tlist->next = pname[i];
		if (i < np - 1)
			addword(tlist, ", ");
	}
	return plist;
}

/*
 * emit a function declaration. The attributes and name of the function
 * are in wlist; the parameters are in plist.
 */
void emit(Word *wlist, Word *plist, long startline)
{
	Word *w;
	int count = 0;

DEBUG("emit called\n");
	if (clui_info->n_logic)
		kprintf("/*%8ld */ ", startline);

	for (w = wlist; w; w = w->next) {
		if (w->string[0])
			count ++;
	}

	if (count < 2)
		kprintf("int ");

	for (w = wlist; w; w = w->next) {
		kprintf("%s", w->string);
		if (ISCSYM(w->string[0]))
			kprintf(" ");
	}
	if (clui_info->p_logic)
		kprintf("PROTO((");
	else
		kprintf("( ");
	for (w = plist; w; w = w->next)
	{
		if (!clui_info->v_logic && (kstrcmp(w->string, "void") != 0) &&
		    (!w->next || !kstrcmp(w->next->string, ", ")))
		{
		   continue;
		}

		kprintf("%s", w->string);
		if (ISCSYM(w->string[0]) && w->next &&
		    (kstrcmp(w->next->string, ", ") != 0) &&
		    (clui_info->v_logic || (w->next->next && (kstrcmp(w->next->next->string, ", ") != 0))))
		{
		   kprintf(" ");
		}
	}
	if (clui_info->p_logic)
		kprintf("));\n");
	else
		kprintf(");\n");
}

/*
 * get all the function declarations
 */

void getdecl(kfile *f)
{
	Word *plist, *wlist = NULL;
	char buf[80];
	int sawsomething;
	long startline;		/* line where declaration started */
	int oktoprint;
again:
	word_free(wlist);
	wlist = word_alloc("");
	sawsomething = 0;
	oktoprint = 1;

	for(;;) {
DEBUG("main getdecl loop\n");
		if (getsym(buf,f) < 0) {
DEBUG("EOF in getdecl loop\n");
			 return;
		}
/* try to guess when a declaration is not an external function definition */
		if (!kstrcmp(buf, ",") || !kstrcmp(buf, "{}") ||
		    !kstrcmp(buf, "=") || !kstrcmp(buf, "typedef") ||
		    !kstrcmp(buf, "extern")) {
			skipit(buf, f);
			goto again;
		}
		if (!clui_info->s_logic && !kstrcmp(buf, "static")) {
			oktoprint = 0;
		}
/* for the benefit of compilers that allow "inline" declarations */
		if (!kstrcmp(buf, "inline") && !sawsomething)
			continue;
		if (!kstrcmp(buf, ";")) goto again;

/* A left parenthesis *might* indicate a function definition */
		if (!kstrcmp(buf, "(")) {
			startline = linenum;
			if (!sawsomething
			    || (plist = getparamlist(f)) == NULL) {
				skipit(buf, f);
				goto again;
			}
			if (plist == ABORTED)
				goto again;

/* It seems to have been what we wanted */
			if (oktoprint)
				emit(wlist, plist, startline);
			word_free(plist);
			goto again;
		}
		addword(wlist, buf);
		sawsomething = 1;
	}
}

