 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            
   >>>>
   >>>>  Private:
   >>>>             
   >>>>   Static:
   >>>>             
   >>>>   Public:
   >>>>             
   >>>>             
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "dbcnvrt.h"
#include "ksdbm.h"
#include "dbm.h"

#define VIFF_VERSION_TAG "Version"
#define VIFF_COOKIE_TAG  "ViffMagicCookie"
#define VIFF_VERSION_VAL "2.0b"
#define VIFF_COOKIE_VAL  "ThisIsAViff"

#define INCREMENT 10

static kdatum version_tag;
static kdatum version_val;
static kdatum cookie_tag;
static kdatum cookie_val;


/*-----------------------------------------------------------
|
|  Routine Name: (static) _init_service
|
|       Purpose: 
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Nov 15, 1993 12:39
| Modifications:
|
------------------------------------------------------------*/

static void
_init_service(void)
{
   if (version_tag.dptr != NULL)
      return;

   version_tag.dptr = kstring_copy(VIFF_VERSION_TAG, NULL);
   version_tag.dsize = kstrlen(version_tag.dptr) + 1;

   version_val.dptr = kstring_copy(VIFF_VERSION_VAL, NULL);
   version_val.dsize = kstrlen(version_val.dptr) + 1;

   cookie_tag.dptr = kstring_copy(VIFF_COOKIE_TAG, NULL);
   cookie_tag.dsize = kstrlen(cookie_tag.dptr) + 1;

   cookie_val.dptr = kstring_copy(VIFF_COOKIE_VAL, NULL);
   cookie_val.dsize = kstrlen(cookie_val.dptr) + 1;

   return;
}

/*-----------------------------------------------------------
|
|  Routine Name: (static) _sort_keys
|
|       Purpose: Maybe this is stupid, but if we encode
|                the keys correctly, then sorting them could
|                be very beneficial
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Nov 08, 1993 08:44
| Modifications:
|
------------------------------------------------------------*/

static int
_stupid(const void *a, const void *b)
{
   ksdatum *da = (ksdatum *) a,
     *db = (ksdatum *) b;

   return (kstrcmp((char *)da->dptr, (char *)db->dptr));
}

static int
_sort_keys(ksdatum * keys, int num)
{
   (void)qsort(keys, (size_t)num, sizeof(ksdatum), _stupid);
   return (TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: _get_all_keys
|
|       Purpose: This silly thing gets a list of all keys
|                in the object.
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Nov 08, 1993 07:57
| Modifications:
|
------------------------------------------------------------*/

static ksdatum *
_get_all_keys(ksdbm * db, int *num)
{
   ksdatum *tmp;
   int n = INCREMENT;

   tmp = kmalloc(n * sizeof(ksdatum));

   if (tmp == NULL)
      return (FALSE);

   *num = 0;
   tmp[*num] = ksdbm_firstkey(db);
   tmp[*num].dptr = kstrdup(tmp[*num].dptr);

   do
   {
      (*num)++;
      if (*num == n)
      {
         n += INCREMENT;
         tmp = (ksdatum *) krealloc(tmp, n * sizeof(ksdatum));

         if (tmp == NULL)
            return (FALSE);
      }
      tmp[*num] = ksdbm_nextkey(db);
      if (tmp[*num].dptr != NULL)
         tmp[*num].dptr = kstrdup(tmp[*num].dptr);
   }
   while (tmp[*num].dptr != NULL);

   tmp = (ksdatum *) krealloc(tmp, (*num) * sizeof(ksdatum));
   if (tmp == NULL)
      return (FALSE);

   _sort_keys(tmp, *num);

   return (tmp);
}

/*-----------------------------------------------------------
|
|  Routine Name: _put_attribute
|
|       Purpose: 
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Dec 05, 1993 20:41
| Modifications:
|
------------------------------------------------------------*/

static int
_put_attribute(
                 kdbm * db,
                 kdatum key,
                 int num,
                 int size,
                 int type,
                 kaddr data)
{
   kdbm_lseek(db, key, 0, SEEK_SET);

   kdbm_write(db, key, &num, 1, KINT);
   kdbm_write(db, key, &size, 1, KINT);
   kdbm_write(db, key, &type, 1, KINT);

   kdbm_write(db, key, data, num * size, type);

   return (TRUE);
}


/*-----------------------------------------------------------
|
|  Routine Name: _compose_key
|
|       Purpose: 
|                segment:
|                segment:attribute
|                       :attribute
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Nov 08, 1993 11:36
| Modifications:
|
------------------------------------------------------------*/

static int
_compose_key(
               char *segment,
               char *attribute,
               ksdatum * key)
{
   char tmp[KLENGTH];

   tmp[0] = '\0';

   key->dptr = kstring_3cat(segment, ":", attribute, NULL);

   key->dsize = kstrlen(key->dptr) + 1;

   return (TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: (static) _decompose_key
|
|       Purpose: 
|                segment:
|                segment:attribute
|                       :attribute
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Nov 08, 1993 11:41
| Modifications:
|
------------------------------------------------------------*/

static int
_decompose_key(
                 ksdatum key,
                 char **segment,
                 char **attribute)
{
   char *i1,
     *tmp;

   if (segment != NULL)
      *segment = NULL;

   if (attribute != NULL)
      *attribute = NULL;

   tmp = key.dptr;

   /*
    * rule 1:  if the first substring is > 0, then it is a segment
    */
   if ((i1 = kstrchr(tmp, ':')) == NULL)
      return (FALSE);

   if (i1 - tmp > 0)
   {
      *segment = kstring_ncopy(tmp, i1 - tmp, NULL);
      tmp = i1 + 1;
   }
   else
   {
      tmp = i1 + 1;
   }

   /*
    * rule 2:  everything that is left is an attribute
    */
   if (kstrlen(tmp) > 0)
      *attribute = kstring_copy(tmp, NULL);

   return (TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: _get_attribute
|
|       Purpose: 
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Nov 17, 1993 15:33
| Modifications:
|
------------------------------------------------------------*/

static int 
_get_attribute(
                 ksdbm * db,
                 ksdatum da,
                 int *num,
                 int *size,
                 int *type,
                 kaddr * data)
{
   int sz;

   ksdbm_read(db, da, num, 1, KINT);
   ksdbm_read(db, da, size, 1, KINT);
   ksdbm_read(db, da, type, 1, KINT);

   sz = (*num) * (*size);

   *data = kcalloc(1, (unsigned)(sz * kdata_size(*type)));

   ksdbm_read(db, da, *data, sz, *type);

   return (TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: fix_da_viff
|
|       Purpose: 
|
|         Input: 
|
|        Output: 
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Jeremy Worley
|          Date: Aug 28, 1994 11:42
| Modifications:
|
------------------------------------------------------------*/

int
fix_da_viff(ksdbm *sdb, kdbm *kdb)
{
   ksdatum *keys,
      tmp;
   int num_keys,
/*    kflags, */
      i,
      j,
      num_args,
      size,
      datatype;
/* kaddr data;
   int   rorder[5]; */

   /*
    * setup some cool stuff.
    */
   _init_service();
   
   /*
    * dump out the version info
    */
   kdbm_store(kdb, version_tag, version_val, KDBM_REPLACE);

   /*
    * dump out the magic cookie
    */
   kdbm_store(kdb, cookie_tag, cookie_val, KDBM_REPLACE);

   /*
    * get a list of keys in the sdbm file.  these will be the
    * attributes and segments.
    */
   keys = _get_all_keys(sdb, &num_keys);

   for (i = 0; i < num_keys; i++)
   {
      char *seg,
        *attr;
      int num;
      kaddr data;
      
      if (!_decompose_key(keys[i], &seg, &attr))
         continue;

      if (kstrlen(seg) != 0 && kstrlen(attr) == 0)
      {
/*         int   order[5]; */
         int   type;
         int   dim;

         _compose_key(seg, "dimension", &tmp);
         _get_attribute(sdb, tmp, &num_args, &size,
                        &datatype, &data);
         dim = *(int *)data;
         kfree(tmp.dptr);       /* compose_key allocs */
         kfree(data);           /* get attribute allocs, but this is a special case */

         _compose_key(seg, "data_type", &tmp);
         _get_attribute(sdb, tmp, &num_args, &size,
                        &datatype, &data);
         type = *(int *)data;
         kfree(tmp.dptr);       /* compose_key allocs */
         kfree(data);           /* get attribute allocs, but this is a special case */

         _compose_key(seg, "size", &tmp);
         _get_attribute(sdb, tmp, &num_args, &size,
                        &datatype, &data);
         for (j = 0, num = 1; j < dim; j++)
            num *= ((int *)data)[j];
         kfree(tmp.dptr);       /* compose_key allocs */
         kfree(data);           /* get attribute allocs, but this is a special case */

	 data = kcalloc(num,kdata_size(type));
	 
	 ksdbm_read(sdb, keys[i], data, num, type);
	 kdbm_write(kdb, ((kdatum *)keys)[i], data, num, type);
	 
	 kfree(data);
      }

      if (kstrlen(attr) != 0)
      {                         /* (attr != NULL)    SK & JMAS */
	 _get_attribute(sdb, keys[i], &num_args, &size,
			&datatype, &data);
	 _put_attribute(kdb, ((kdatum *)keys)[i], num_args, size,
			datatype, data);
      }
      
      kfree(seg);
      kfree(attr);
   }

   /*
    * the get_all_keys function allocates its space, so free it.
    */
   for (i = 0; i < num_keys; i++)
      kfree(keys[i].dptr);

   kfree(keys);

   /*
    * all done
    */
   return (TRUE);
}
