 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for mpow
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lmpow
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lmpow - compute positive integral power of a matrix
* 
*       Purpose: lmpow raises a square input matrix to a non-negative
*                integral power by multiplying the matrix with itself.
*                A power of zero yields the unit matrix.
*
*         Input: in_obj - input matrix object, must be square
 *               pow - non-negative integer power
*
*        Output: out_obj - output matrix object
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: Restrictions on data or input as applicable
*    Written By: Scott Wilson
*          Date: Apr 08, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int lmpow(kobject in_obj, int pow, kobject out_obj)
/* -library_def_end */

/* -library_code */
{
        char *lib = "kmatrix", *rtn = "lmpow";
        int type,itype,otype;
        int w,h,d,t,e;
        int i;
        klist *objlist=NULL;
        kobject tmp_obj;

        /* Make sure we have valid objects */
        if (in_obj == KOBJECT_INVALID)
          {
            kerror(lib, rtn, "Bogus input object");
            return(FALSE);
          }
        if (out_obj == KOBJECT_INVALID)
          {
            kerror(lib, rtn, "Bogus output object");
            return(FALSE);
          }
 
        if (pow <0)
          {
            kerror(lib, rtn, "Power cannot be negative");
            return(FALSE);
          }
 
        /* Reference the input object to avoid side effects, then add the
           references to the list of goodies to be autmatically free'd on
           error. */
        KCALL((in_obj = kpds_reference_object(in_obj)));
        objlist = klist_add(objlist,in_obj,"KOBJECT");
 
        /* See what size the data is */
        KCALL(kpds_get_attribute(in_obj,KPDS_VALUE_SIZE,&w,&h,&d,&t,&e));
        if (w != h)
          {
            (void)klist_free(objlist, (kfunc_void)lkcall_free);
            kerror(lib, rtn, "Input matrix must be square");
            return(FALSE);
          }

        /* Figure out if we should act real or complex */
        KCALL(kpds_get_attribute(in_obj,KPDS_VALUE_DATA_TYPE,&type));
        if (type == KCOMPLEX || type == KDCOMPLEX )
          {
            itype = KDCOMPLEX;
            otype = KDCOMPLEX;
          }
        else
          {
            itype = KDOUBLE;
            otype = KDOUBLE;
          }
 
        /* Constrain the input data to double real or double complex for read */
        KCALL(kpds_set_attribute(in_obj,KPDS_VALUE_DATA_TYPE, itype));
 
        /* Set the output object size and data type, and copy the value data */
        if (!kpds_query_value(out_obj)) KCALL(kpds_create_value(out_obj));
        KCALL(kpds_set_attributes(out_obj,
                             KPDS_VALUE_SIZE,w,h,d,t,e,
                             KPDS_VALUE_DATA_TYPE,otype,NULL));
        KCALL((out_obj = kpds_reference_object(out_obj)));
        objlist = klist_add(objlist,out_obj,"KOBJECT");

        /* Do the same to the temporary object */
        if ((tmp_obj = kpds_create_object()) == KOBJECT_INVALID)
          {
            (void)klist_free(objlist, (kfunc_void)lkcall_free);
            kerror(lib, rtn, "Unable to create temp object");
            return(FALSE);
          }
        if (!kpds_query_value(tmp_obj)) KCALL(kpds_create_value(tmp_obj));
        KCALL(kpds_set_attributes(tmp_obj,
                             KPDS_VALUE_SIZE,w,h,d,t,e,
                             KPDS_VALUE_DATA_TYPE,otype,NULL));
        objlist = klist_add(objlist,tmp_obj,"KOBJECT");

        /* Compute the rasied matrix */
        if (pow == 0) { KCALL(kpds_initialize_value(out_obj,1.0,0.0)); }
        else if (pow == 1) { KCALL(kpds_copy_value_data(in_obj,out_obj,TRUE)); }
        else
          {
            KCALL(kpds_copy_value_data(in_obj,tmp_obj,TRUE));
            /* Multiply the matrix by itself pow-1 times */
            for (i=0; i<pow-1; i++)
              {
                lmmul(tmp_obj,in_obj,out_obj);
                KCALL(kpds_copy_value_data(out_obj,tmp_obj,TRUE));
              }
          }
        
        (void)klist_free(objlist, (kfunc_void)lkcall_free);

	return TRUE;
}
/* -library_code_end */
