 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for mreplicate
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "mreplicate.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Replicate a Given Matrix as Submatrices of a Larger Matrix
|
|       Purpose: main program for mreplicate
|
|         Input:
|		char *clui_info->i_file; {Input mmatrix data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {Resulting matrix output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		int clui_info->r_int; {replica count along rows}
|		int clui_info->r_flag; {TRUE if -r specified}
|
|		int clui_info->c_int; {replica count along columns}
|		int clui_info->c_flag; {TRUE if -c specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
kobject in_obj = NULL;
kobject out_obj = NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "MATRIX");
	kexit_handler(mreplicate_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "MATRIX", "mreplicate",
		mreplicate_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	mreplicate_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((in_obj = kpds_open_input_object(clui_info->i_file))
                == KOBJECT_INVALID)
        {
           kerror("mreplicate","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

        if ((out_obj = kpds_open_output_object(clui_info->o_file))
                == KOBJECT_INVALID)
          {
            kerror("mreplicate","main", "Cannot open output object.");
            kexit(KEXIT_FAILURE);
          }
        if (!kpds_copy_object_attr(in_obj, out_obj))
          {
            kerror("mreplicate","main",
              "Unable to copy attributes from input to output object.");
            kexit(KEXIT_FAILURE);
          }
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lmreplicate(in_obj,clui_info->r_int,clui_info->c_int,
                         out_obj)) kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output objects and write */
        if (!kpds_set_attribute(out_obj,KPDS_HISTORY,kpds_history_string()))
          {
            kerror("mreplicate", "main","Unable to set history on output object");
            kexit(KEXIT_FAILURE);
          }
        kpds_close_object(out_obj);
        kpds_close_object(in_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: mreplicate_usage_additions
| 
|       Purpose: Prints usage additions in mreplicate_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mreplicate
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void mreplicate_usage_additions(void)
{
	kfprintf(kstderr, "\tReplicate a Given Matrix as Submatrices of a Larger Matrix\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: mreplicate_free_args
| 
|       Purpose: Frees CLUI struct allocated in mreplicate_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mreplicate
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
mreplicate_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
