 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "mrcsum.h"
/*-----------------------------------------------------------
| 
|  Routine Name: mrcsum_get_args
| 
|       Purpose: Gets command line args for mrcsum
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mrcsum
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void mrcsum_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for mrcsum is out of sync with arguments specified in mrcsum's *.pane file; please rerun ghostwriter on mrcsum.";

	char  *value_string;


	/*
	 * allocate the mrcsum structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "mrcsum_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "scale", KVF_TOGGLE_VAL,
			  &value_string,
			  &(clui_info->scale_flag))))
	{
	    kerror(NULL, "mrcsum_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	else clui_info->scale_toggle = atoi(value_string);

	if (!(kclui_get_outfile(pane, "or",
			  &(clui_info->or_file),
			  &(clui_info->or_flag))))
	{
	    kerror(NULL, "mrcsum_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "oc",
			  &(clui_info->oc_file),
			  &(clui_info->oc_flag))))
	{
	    kerror(NULL, "mrcsum_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



