 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "mextract_diag.h"
/*-----------------------------------------------------------
| 
|  Routine Name: mextract_diag_get_args
| 
|       Purpose: Gets command line args for mextract_diag
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mextract_diag
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void mextract_diag_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for mextract_diag is out of sync with arguments specified in mextract_diag's *.pane file; please rerun ghostwriter on mextract_diag.";


	/*
	 * allocate the mextract_diag structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "mextract_diag_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "num",
			  &(clui_info->num_int),
			  &(clui_info->num_flag))))
	{
	    kerror(NULL, "mextract_diag_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "mextract_diag_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "row",
			  &(clui_info->row_flag))))
	{
	    kerror(NULL, "mextract_diag_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "col",
			  &(clui_info->col_flag))))
	{
	    kerror(NULL, "mextract_diag_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "diag",
			  &(clui_info->diag_flag))))
	{
	    kerror(NULL, "mextract_diag_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



