 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "mexchg.h"
/*-----------------------------------------------------------
| 
|  Routine Name: mexchg_get_args
| 
|       Purpose: Gets command line args for mexchg
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mexchg
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void mexchg_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for mexchg is out of sync with arguments specified in mexchg's *.pane file; please rerun ghostwriter on mexchg.";


	/*
	 * allocate the mexchg structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "mexchg_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "mexchg_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "r1",
			  &(clui_info->r1_int),
			  &(clui_info->r1_flag))))
	{
	    kerror(NULL, "mexchg_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "r2",
			  &(clui_info->r2_int),
			  &(clui_info->r2_flag))))
	{
	    kerror(NULL, "mexchg_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "c1",
			  &(clui_info->c1_int),
			  &(clui_info->c1_flag))))
	{
	    kerror(NULL, "mexchg_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "c2",
			  &(clui_info->c2_int),
			  &(clui_info->c2_flag))))
	{
	    kerror(NULL, "mexchg_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



