 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for mexchg
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "mexchg.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Exchange Rows or Columns of a Matrix
|
|       Purpose: main program for mexchg
|
|         Input:
|		char *clui_info->i_file; {Input matrix}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {Output matrix}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		M.I. group:
|		    int clui_info->r1_int; {row #1}
|		    int clui_info->r1_flag; {TRUE if -r1 specified}
|
|		    int clui_info->r2_int; {row #2}
|		    int clui_info->r2_flag; {TRUE if -r2 specified}
|
|		M.I. group:
|		    int clui_info->c1_int; {Column #1}
|		    int clui_info->c1_flag; {TRUE if -c1 specified}
|
|		    int clui_info->c2_int; {Column #2}
|		    int clui_info->c2_flag; {TRUE if -c2 specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
kobject in_obj = NULL;
kobject out_obj = NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "MATRIX");
	kexit_handler(mexchg_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "MATRIX", "mexchg",
		mexchg_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	mexchg_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((in_obj = kpds_open_input_object(clui_info->i_file)) 
                == KOBJECT_INVALID)
        {
           kerror("mexchg","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }
       if ((out_obj = kpds_open_output_object(clui_info->o_file)) 
            == KOBJECT_INVALID)
         {
           kerror("mexchg","main", "Cannot open output object.");
           kexit(KEXIT_FAILURE);
         }
       if (!kpds_copy_object_attr(in_obj, out_obj))
         {
           kerror("mexchg","main", 
             "Unable to copy attributes from input object to output object.");
           kexit(KEXIT_FAILURE);
         }
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!lmexchg(in_obj,clui_info->r1_int,clui_info->r2_int,
                            clui_info->c1_int,clui_info->c2_int,
                            out_obj)) kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
        /* add history to the output object and write */
        if (!kpds_set_attribute(out_obj,KPDS_HISTORY,kpds_history_string()))
          {
            kerror("mexchg", "main","Unable to set history on output object");
            kexit(KEXIT_FAILURE);
          }
        kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: mexchg_usage_additions
| 
|       Purpose: Prints usage additions in mexchg_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mexchg
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void mexchg_usage_additions(void)
{
	kfprintf(kstderr, "\tExchange Rows or Columns of a Matrix\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: mexchg_free_args
| 
|       Purpose: Frees CLUI struct allocated in mexchg_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mexchg
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
mexchg_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
